/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.infra.workflow.entity.State;
import org.egov.tl.entity.License;
import org.joda.time.DateTime;

public class SearchForm {
    private Long licenseId;
    private String applicationNumber;
    private String licenseNumber;
    private String oldLicenseNumber;
    private String categoryName;
    private String subCategoryName;
    private String tradeTitle;
    private String tradeOwnerName;
    private String propertyAssessmentNo;
    private String mobileNo;
    private String status;
    private String ownerName;
    private String expiryYear;
    private Long categoryId;
    private Long subCategoryId;
    private Long statusId;
    private Date dateOfExpiry;
    private List<String> actions;
    private String active;
    private Boolean inactive;

    public SearchForm() {
    }

    public SearchForm(License license, String userRoles, String ownerName, String expiryYear) {
        this.setLicenseId(license.getId());
        this.setApplicationNumber(license.getApplicationNumber());
        this.setLicenseNumber(license.getLicenseNumber());
        this.setOldLicenseNumber(license.getOldLicenseNumber());
        this.setCategoryName(license.getCategory().getName());
        this.setSubCategoryName(license.getTradeName().getName());
        this.setTradeTitle(license.getNameOfEstablishment());
        this.setTradeOwnerName(license.getLicensee().getApplicantName());
        this.setMobileNo(license.getLicensee().getMobilePhoneNumber());
        this.setPropertyAssessmentNo(license.getAssessmentNo() != null ? license.getAssessmentNo() : "");
        this.setStatus(license.getStatus().getName());
        this.setActive(license.getIsActive() ? "YES" : "NO");
        this.setOwnerName(ownerName);
        this.setExpiryYear(expiryYear);
        this.setDateOfExpiry(license.getDateOfExpiry());
        this.addActions(license, userRoles);
    }

    private void addActions(License license, String userRoles) {
        ArrayList<String> licenseActions = new ArrayList<String>();
        licenseActions.add("View Trade");
        if (!userRoles.contains("CSC Operator")) {
            licenseActions.add("Generate Demand Notice");
            if (license.isLegacy() && !license.hasState()) {
                licenseActions.add("Modify Legacy License");
            }
            if (license.getStatus() != null) {
                this.addRoleSpecificActions(license, userRoles, licenseActions);
                if (license.isStatusActive()) {
                    licenseActions.add("Closure");
                }
            }
        } else if (!license.isPaid() && license.getIsActive()) {
            this.addRenewalOption(licenseActions, license.getState());
        }
        this.setActions(licenseActions);
    }

    private void addRoleSpecificActions(License license, String userRoles, List<String> licenseActions) {
        if (userRoles.contains("Collection Operator") && license.canCollectFee()) {
            licenseActions.add("Collect Fees");
        } else if (userRoles.contains("TLCreator") || userRoles.contains("TLApprover")) {
            if (license.isStatusActive() && !license.isLegacy()) {
                licenseActions.add("Print Certificate");
            }
            if (license.getStatus().getStatusCode().equals("UWF")) {
                licenseActions.add("Print Provisional Certificate");
            }
            State stateobj = license.getState();
            if (!license.isPaid() && license.getIsActive()) {
                this.addRenewalOption(licenseActions, stateobj);
            }
            Date fromRange = new DateTime().withMonthOfYear(1).withDayOfMonth(1).toDate();
            Date toRange = new DateTime().withMonthOfYear(3).withDayOfMonth(31).toDate();
            Date currentDate = new Date();
            if (currentDate.after(fromRange) && currentDate.before(toRange)) {
                this.demandGenerationOption(licenseActions, license);
            }
        }
    }

    private void addRenewalOption(List<String> licenseActions, State stateobj) {
        if (stateobj == null || "END".equals(stateobj.getValue()) || "Closed".equals(stateobj.getValue())) {
            licenseActions.add("Renew License");
        }
    }

    private void demandGenerationOption(List<String> licenseActions, License license) {
        Date nextYearInstallment = new DateTime().withMonthOfYear(4).withDayOfMonth(1).toDate();
        Date currentYearInstallment = license.getLicenseDemand().getEgInstallmentMaster().getToDate();
        if (license.isNewPermanentApplication() && license.hasState() && license.getIsActive() && currentYearInstallment.before(nextYearInstallment)) {
            licenseActions.add("Generate Demand");
        }
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public String getOldLicenseNumber() {
        return this.oldLicenseNumber;
    }

    public void setOldLicenseNumber(String oldLicenseNumber) {
        this.oldLicenseNumber = oldLicenseNumber;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getSubCategoryName() {
        return this.subCategoryName;
    }

    public void setSubCategoryName(String subCategoryName) {
        this.subCategoryName = subCategoryName;
    }

    public String getTradeTitle() {
        return this.tradeTitle;
    }

    public void setTradeTitle(String tradeTitle) {
        this.tradeTitle = tradeTitle;
    }

    public String getTradeOwnerName() {
        return this.tradeOwnerName;
    }

    public void setTradeOwnerName(String tradeOwnerName) {
        this.tradeOwnerName = tradeOwnerName;
    }

    public String getPropertyAssessmentNo() {
        return this.propertyAssessmentNo;
    }

    public void setPropertyAssessmentNo(String propertyAssessmentNo) {
        this.propertyAssessmentNo = propertyAssessmentNo;
    }

    public String getMobileNo() {
        return this.mobileNo;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public Long getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(Long licenseId) {
        this.licenseId = licenseId;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public Long getStatusId() {
        return this.statusId;
    }

    public void setStatusId(Long statusId) {
        this.statusId = statusId;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Long getSubCategoryId() {
        return this.subCategoryId;
    }

    public void setSubCategoryId(Long subCategoryId) {
        this.subCategoryId = subCategoryId;
    }

    public Date getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public void setDateOfExpiry(Date dateOfExpiry) {
        this.dateOfExpiry = dateOfExpiry;
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public Boolean getInactive() {
        return this.inactive;
    }

    public void setInactive(Boolean inactive) {
        this.inactive = inactive;
    }
}

