/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.tl.entity.License;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@Entity
@Table(name="egtl_trade_license")
@Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
public class TradeLicense
extends License {
    @Override
    public String getStateDetails() {
        StringBuilder details = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getLicenseNumber())) {
            details.append("Trade License Number ").append(this.getLicenseNumber()).append(" and ");
        }
        details.append("App No. ").append(this.applicationNumber).append(" dated ").append(DateUtils.toDefaultDateFormat((Date)this.applicationDate));
        if (StringUtils.isNotBlank((CharSequence)this.getState().getComments())) {
            details.append("<br/> Remarks : ").append(this.getState().getComments());
        }
        return details.toString();
    }

    public String myLinkId() {
        if ("Closure License".equals(this.getState().getNatureOfTask())) {
            return "/tl/viewtradelicense/viewTradeLicense-closure.action?model.id=" + this.id;
        }
        return "/tl/newtradelicense/newTradeLicense-showForApproval.action?model.id=" + this.id;
    }
}

