/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.io.Serializable;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.tl.service.LicenseNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TradeLicenseNumberGenerator
implements LicenseNumberGenerator {
    private static final String LICENSE_NUMBER_SEQ_NAME = "egtl_license_number";
    private static final String LICENSE_NUMBER_FORMAT = "TL/%05d/%s";
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;

    @Override
    public String generateLicenseNumber() {
        Serializable nextSequence = this.sequenceNumberGenerator.getNextSequence(LICENSE_NUMBER_SEQ_NAME);
        return String.format(LICENSE_NUMBER_FORMAT, nextSequence, DateUtils.currentDateToYearFormat());
    }
}

