/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.FeeType;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.repository.FeeMatrixRepositoryCustom;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class FeeMatrixRepositoryImpl
implements FeeMatrixRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<FeeMatrix> searchFeeMatrix(Long categoryId, Long subcategoryId, Long financialYearId) {
        Criteria feeMatrixCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(FeeMatrix.class, "feeMatrix").createAlias("feeMatrix.licenseCategory", "licenseCategory").createAlias("feeMatrix.subCategory", "subCategory").createAlias("feeMatrix.financialYear", "financialYear").createAlias("feeMatrix.licenseAppType", "licenseAppType").createAlias("feeMatrix.natureOfBusiness", "natureOfBusiness");
        if (categoryId != null) {
            feeMatrixCriteria.add((Criterion)Restrictions.eq((String)"licenseCategory.id", (Object)categoryId));
        }
        if (subcategoryId != null) {
            feeMatrixCriteria.add((Criterion)Restrictions.eq((String)"subCategory.id", (Object)subcategoryId));
        }
        if (financialYearId != null) {
            feeMatrixCriteria.add((Criterion)Restrictions.eq((String)"financialYear.id", (Object)financialYearId));
        }
        feeMatrixCriteria.addOrder(Order.desc((String)"financialYear.id")).addOrder(Order.asc((String)"licenseAppType.name")).addOrder(Order.asc((String)"natureOfBusiness.name"));
        return feeMatrixCriteria.list();
    }

    @Override
    public Optional<FeeMatrix> findFeeMatrix(License license, NatureOfBusiness natureOfBusiness, FeeType feeType, LicenseAppType appType, Date effectiveDate) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(FeeMatrix.class);
        Root feeMatrixRoot = criteriaQuery.from(FeeMatrix.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(criteriaBuilder.equal((Expression)feeMatrixRoot.get("natureOfBusiness"), (Object)natureOfBusiness));
        predicates.add(criteriaBuilder.equal((Expression)feeMatrixRoot.get("licenseCategory"), (Object)license.getCategory()));
        predicates.add(criteriaBuilder.equal((Expression)feeMatrixRoot.get("subCategory"), (Object)license.getTradeName()));
        predicates.add(criteriaBuilder.equal((Expression)feeMatrixRoot.get("licenseAppType"), (Object)appType));
        predicates.add(criteriaBuilder.equal((Expression)feeMatrixRoot.get("feeType"), (Object)feeType));
        predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)feeMatrixRoot.get("effectiveFrom"), (Comparable)effectiveDate));
        predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)feeMatrixRoot.get("effectiveTo"), (Comparable)effectiveDate));
        criteriaQuery.select((Selection)feeMatrixRoot).where(predicates.toArray(new Predicate[0]));
        return this.entityManager.createQuery(criteriaQuery).getResultList().stream().findFirst();
    }
}

