/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.CompareDates;
import org.egov.infra.persistence.validator.annotation.UniqueDateOverlap;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.FeeType;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.NatureOfBusiness;

@Entity
@Table(name="egtl_feematrix")
@SequenceGenerator(name="seq_egtl_feematrix", sequenceName="seq_egtl_feematrix", allocationSize=1)
@CompareDates(fromDate="effectiveFrom", toDate="effectiveTo", message="{feematrix.effective.date.range}")
@UniqueDateOverlap(fromField="effectiveFrom", toField="effectiveTo", uniqueFields={"natureOfBusiness", "licenseCategory", "subCategory", "licenseAppType", "feeType"}, message="{feematrix.exist}")
public class FeeMatrix
extends AbstractAuditable {
    public static final String SEQ = "seq_egtl_feematrix";
    private static final long serialVersionUID = 3119126267277124321L;
    @Id
    @GeneratedValue(generator="seq_egtl_feematrix", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="natureOfBusiness")
    private NatureOfBusiness natureOfBusiness;
    @NotNull
    @ManyToOne
    @JoinColumn(name="licenseCategory")
    private LicenseCategory licenseCategory;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subCategory")
    private LicenseSubCategory subCategory;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="licenseAppType")
    private LicenseAppType licenseAppType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="feeType")
    private FeeType feeType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="financialYear")
    private CFinancialYear financialYear;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date effectiveFrom;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date effectiveTo;
    @Valid
    @OrderBy(value="uomFrom")
    @OneToMany(mappedBy="feeMatrix", cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, fetch=FetchType.LAZY, orphanRemoval=true)
    private List<FeeMatrixDetail> feeMatrixDetail = new ArrayList<FeeMatrixDetail>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FeeType getFeeType() {
        return this.feeType;
    }

    public void setFeeType(FeeType feeType) {
        this.feeType = feeType;
    }

    public NatureOfBusiness getNatureOfBusiness() {
        return this.natureOfBusiness;
    }

    public void setNatureOfBusiness(NatureOfBusiness natureOfBusiness) {
        this.natureOfBusiness = natureOfBusiness;
    }

    public LicenseCategory getLicenseCategory() {
        return this.licenseCategory;
    }

    public void setLicenseCategory(LicenseCategory licenseCategory) {
        this.licenseCategory = licenseCategory;
    }

    public LicenseSubCategory getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(LicenseSubCategory subCategory) {
        this.subCategory = subCategory;
    }

    public LicenseAppType getLicenseAppType() {
        return this.licenseAppType;
    }

    public void setLicenseAppType(LicenseAppType licenseAppType) {
        this.licenseAppType = licenseAppType;
    }

    public List<FeeMatrixDetail> getFeeMatrixDetail() {
        return this.feeMatrixDetail;
    }

    public void setFeeMatrixDetail(List<FeeMatrixDetail> feeMatrixDetail) {
        this.feeMatrixDetail = feeMatrixDetail;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public Date getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public Date getEffectiveTo() {
        return this.effectiveTo;
    }

    public void setEffectiveTo(Date effectiveTo) {
        this.effectiveTo = effectiveTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeeMatrix)) {
            return false;
        }
        FeeMatrix feeMatrix = (FeeMatrix)((Object)o);
        return Objects.equals(this.natureOfBusiness.getId(), feeMatrix.natureOfBusiness.getId()) && Objects.equals(this.licenseCategory.getId(), feeMatrix.licenseCategory.getId()) && Objects.equals(this.subCategory.getId(), feeMatrix.subCategory.getId()) && Objects.equals(this.licenseAppType.getId(), feeMatrix.licenseAppType.getId()) && Objects.equals(this.feeType.getId(), feeMatrix.feeType.getId()) && Objects.equals(this.financialYear.getId(), feeMatrix.financialYear.getId());
    }

    public int hashCode() {
        return Objects.hash(this.natureOfBusiness.getId(), this.licenseCategory.getId(), this.subCategory.getId(), this.licenseAppType.getId(), this.feeType.getId(), this.financialYear.getId());
    }
}

