/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.utils;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Date;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.tl.service.LicenseNumberGenerator;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseNumberUtils {
    @Autowired
    protected AutonumberServiceBeanResolver autonumberServiceBeanResolver;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    protected ApplicationNumberGenerator applicationNumberGenerator;

    public String generateLicenseNumber() {
        return ((LicenseNumberGenerator)this.autonumberServiceBeanResolver.getAutoNumberServiceFor(LicenseNumberGenerator.class)).generateLicenseNumber();
    }

    public String generateApplicationNumber() {
        return this.applicationNumberGenerator.generate();
    }

    public String generateBillNumber() {
        try {
            Serializable sequenceNumber;
            String currentInstallmentYear = DateUtils.toYearFormat((Date)this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName("Trade License"), new Date()).getInstallmentYear());
            String sequenceName = "SEQ_BILLNO_" + currentInstallmentYear;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%s%06d", "", sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating license bill Number ", (Throwable)e);
        }
    }
}

