/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service.masters;

import java.util.List;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.repository.LicenseSubCategoryRepository;
import org.egov.tl.service.FeeTypeService;
import org.egov.tl.service.LicenseTypeService;
import org.egov.tl.service.masters.LicenseCategoryService;
import org.egov.tl.service.masters.UnitOfMeasurementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LicenseSubCategoryService {
    @Autowired
    private LicenseSubCategoryRepository licenseSubCategoryRepository;
    @Autowired
    private LicenseCategoryService licenseCategoryService;
    @Autowired
    private FeeTypeService feeTypeService;
    @Autowired
    private UnitOfMeasurementService unitOfMeasurementService;
    @Autowired
    private LicenseTypeService licenseTypeService;

    @Transactional
    public LicenseSubCategory create(LicenseSubCategory subCategory, List<LicenseSubCategoryDetails> details, Long categoryId) {
        if (categoryId != null) {
            subCategory.setCategory(this.licenseCategoryService.findById(categoryId));
        }
        subCategory.setLicenseType(this.licenseTypeService.getLicenseTypeByName("TradeLicense"));
        for (LicenseSubCategoryDetails scDetails : details) {
            if (scDetails == null) continue;
            scDetails.setSubCategory(subCategory);
            scDetails.setFeeType(this.feeTypeService.findById(scDetails.getFeeType().getId()));
            scDetails.setRateType(scDetails.getRateType());
            scDetails.setUom(this.unitOfMeasurementService.findById(scDetails.getUom().getId()));
            subCategory.addLicenseSubCategoryDetails(scDetails);
        }
        return (LicenseSubCategory)((Object)this.licenseSubCategoryRepository.save((Object)subCategory));
    }

    public List<LicenseSubCategory> findAllSubCategoryByCategory(Long categoryId) {
        return this.licenseSubCategoryRepository.findAllByCategoryId(categoryId);
    }

    public LicenseSubCategory findSubCategoryByName(String name) {
        return this.licenseSubCategoryRepository.findByName(name);
    }

    public LicenseSubCategory findSubCategoryByCode(String code) {
        return this.licenseSubCategoryRepository.findByCode(code);
    }

    public LicenseSubCategory findById(Long subCategoryId) {
        return this.licenseSubCategoryRepository.findOne(subCategoryId);
    }

    public List<LicenseSubCategory> findAll() {
        return this.licenseSubCategoryRepository.findAll();
    }

    public List<LicenseSubCategory> getLicenseSubCategoriesByLicenseTypeName(String licenseTypeName) {
        return this.licenseSubCategoryRepository.findByLicenseType_Name(licenseTypeName);
    }
}

