/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.Date;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.License;
import org.egov.tl.entity.Validity;
import org.egov.tl.repository.ValidityRepository;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ValidityService {
    private final ValidityRepository validityRepository;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;

    @Autowired
    public ValidityService(ValidityRepository validityRepository) {
        this.validityRepository = validityRepository;
    }

    @Transactional
    public Validity create(Validity validity) {
        return (Validity)((Object)this.validityRepository.save((Object)validity));
    }

    @Transactional
    public Validity update(Validity validity) {
        return (Validity)((Object)this.validityRepository.save((Object)validity));
    }

    public List<Validity> findAll() {
        return this.validityRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Validity findOne(Long id) {
        return (Validity)((Object)this.validityRepository.findOne(id));
    }

    public List<Validity> search(Long natureOfBusiness, Long licenseCategory) {
        if (natureOfBusiness != null && licenseCategory != null) {
            return this.validityRepository.findByNatureOfBusinessIdAndLicenseCategoryId(natureOfBusiness, licenseCategory);
        }
        if (natureOfBusiness != null) {
            return this.validityRepository.findByNatureOfBusinessId(natureOfBusiness);
        }
        if (licenseCategory != null) {
            return this.validityRepository.findByLicenseCategoryId(licenseCategory);
        }
        return this.validityRepository.findAll();
    }

    public void applyLicenseValidity(License license) {
        List<Validity> validityList = this.validityRepository.findByNatureOfBusinessIdAndLicenseCategoryId(license.getNatureOfBusiness().getId(), license.getTradeName().getCategory().getId());
        if (validityList.isEmpty()) {
            validityList = this.validityRepository.findByNatureOfBusinessId(license.getNatureOfBusiness().getId());
        }
        if (validityList.isEmpty()) {
            throw new ValidationException("TL-001", "License validity not defined.", new String[0]);
        }
        Validity validity = validityList.get(0);
        if (validity.isBasedOnFinancialYear()) {
            Date nextExpiryDate = license.getDateOfExpiry() == null ? new Date() : new LocalDate((Object)license.getDateOfExpiry()).plusDays(1).toDate();
            CFinancialYear currentFinancialYear = this.financialYearHibernateDAO.getFinancialYearByDate(nextExpiryDate);
            license.setDateOfExpiry(currentFinancialYear.getEndingDate());
        } else {
            LocalDate nextExpiryDate = license.getDateOfExpiry() == null ? new LocalDate() : new LocalDate((Object)license.getDateOfExpiry());
            if (validity.getYear() != null && validity.getYear() > 0) {
                nextExpiryDate.plusYears(validity.getYear().intValue());
            }
            if (validity.getMonth() != null && validity.getMonth() > 0) {
                nextExpiryDate.plusMonths(validity.getMonth().intValue());
            }
            if (validity.getWeek() != null && validity.getWeek() > 0) {
                nextExpiryDate.plusWeeks(validity.getWeek().intValue());
            }
            if (validity.getDay() != null && validity.getDay() > 0) {
                nextExpiryDate.plusDays(validity.getDay().intValue());
            }
            license.setDateOfExpiry(nextExpiryDate.toDate());
        }
    }
}

