/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.List;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.PenaltyRates;
import org.egov.tl.repository.LicenseAppTypeRepository;
import org.egov.tl.repository.PenaltyRatesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PenaltyRatesService {
    private final PenaltyRatesRepository penaltyRatesRepository;
    private final LicenseAppTypeRepository licenseAppTypeRepository;

    @Autowired
    public PenaltyRatesService(PenaltyRatesRepository penaltyRatesRepository, LicenseAppTypeRepository licenseAppTypeRepository) {
        this.penaltyRatesRepository = penaltyRatesRepository;
        this.licenseAppTypeRepository = licenseAppTypeRepository;
    }

    public PenaltyRates findByDaysAndLicenseAppType(Long days, LicenseAppType licenseAppType) {
        return this.penaltyRatesRepository.findByDaysAndLicenseAppType(days, licenseAppType);
    }

    public List<LicenseAppType> findAllLicenseAppType() {
        return this.licenseAppTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public PenaltyRates findOne(Long id) {
        return (PenaltyRates)((Object)this.penaltyRatesRepository.findOne(id));
    }

    public LicenseAppType findByLicenseAppType(Long licenseAppId) {
        return (LicenseAppType)((Object)this.licenseAppTypeRepository.findOne(licenseAppId));
    }

    @Transactional
    public PenaltyRates create(PenaltyRates penaltyRates) {
        return (PenaltyRates)((Object)this.penaltyRatesRepository.save((Object)penaltyRates));
    }

    public List<PenaltyRates> search(Long licenseAppType) {
        if (licenseAppType != null) {
            return this.penaltyRatesRepository.findByLicenseAppTypeIdOrderByIdAsc(licenseAppType);
        }
        return this.penaltyRatesRepository.findAll();
    }

    @Transactional
    public void delete(PenaltyRates penaltyRates) {
        this.penaltyRatesRepository.delete((Object)penaltyRates);
    }
}

