/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.FeeType;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.repository.FeeMatrixRepository;
import org.egov.tl.service.FeeMatrixDetailService;
import org.egov.tl.service.FeeTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FeeMatrixService<T extends License> {
    private final FeeMatrixRepository feeMatrixRepository;
    @Autowired
    private FeeTypeService feeTypeService;
    @Autowired
    private FeeMatrixDetailService feeMatrixDetailService;
    @Autowired
    private AppConfigValueService appConfigValueService;
    @Autowired
    @Qualifier(value="entityQueryService")
    private PersistenceService persistenceService;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    @Autowired
    public FeeMatrixService(FeeMatrixRepository feeMatrixRepository) {
        this.feeMatrixRepository = feeMatrixRepository;
    }

    @Transactional
    public FeeMatrix create(FeeMatrix feeMatrix) {
        feeMatrix.setUniqueNo(feeMatrix.genUniqueNo());
        if (!feeMatrix.getFeeMatrixDetail().isEmpty()) {
            for (FeeMatrixDetail fd : feeMatrix.getFeeMatrixDetail()) {
                fd.setFeeMatrix(feeMatrix);
            }
        }
        return (FeeMatrix)((Object)this.feeMatrixRepository.save((Object)feeMatrix));
    }

    @Transactional
    public FeeMatrix update(FeeMatrix feeMatrix) {
        feeMatrix.setUniqueNo(feeMatrix.genUniqueNo());
        return (FeeMatrix)((Object)this.feeMatrixRepository.save((Object)feeMatrix));
    }

    public List<FeeMatrix> findAll() {
        return this.feeMatrixRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public FeeMatrix search(FeeMatrix feeMatrix) {
        return this.feeMatrixRepository.findByUniqueNo(feeMatrix.getUniqueNo());
    }

    public List<FeeMatrixDetail> findFeeList(T license) {
        List newRenewAppconfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("Trade License", "Is Fee For New and Renew Same");
        boolean isnew_renewfee_same = ((AppConfigValues)newRenewAppconfigList.get(0)).getValue().equals("Y");
        List permTempAppconfigList = this.appConfigValueService.getConfigValuesByModuleAndKey("Trade License", "Is Fee For Permanent and Temporary Same");
        boolean ispermanent_temporaryfee_same = ((AppConfigValues)permTempAppconfigList.get(0)).getValue().equals("Y");
        LicenseAppType newapp = (LicenseAppType)((Object)this.persistenceService.find("from  LicenseAppType where name='New' "));
        NatureOfBusiness permanent = (NatureOfBusiness)((Object)this.persistenceService.find("from org.egov.tl.entity.NatureOfBusiness where   name='Permanent'"));
        String uniqueNo = isnew_renewfee_same && ispermanent_temporaryfee_same ? this.generateFeeMatirixUniqueNo(license, newapp, permanent) : (isnew_renewfee_same ? this.generateFeeMatirixUniqueNo(license, newapp) : (ispermanent_temporaryfee_same ? this.generateFeeMatirixUniqueNo(license, permanent) : this.generateFeeMatirixUniqueNo(license)));
        Date applicationDate = ((License)((Object)license)).getApplicationDate();
        ArrayList<FeeMatrixDetail> feeMatrixDetailList = new ArrayList<FeeMatrixDetail>();
        CFinancialYear financialYearByDate = this.financialYearDAO.getFinancialYearByDate(applicationDate);
        Long uomId = ((License)((Object)license)).getTradeName().getLicenseSubCategoryDetails().iterator().next().getUom().getId();
        for (FeeType fee : this.feeTypeService.findAll()) {
            if (!fee.getFeeProcessType().equals((Object)FeeType.FeeProcessType.RANGE)) continue;
            switch (fee.getCode()) {
                case "LF": {
                    FeeMatrix feeMatrix = this.feeMatrixRepository.findByUniqueNo(uniqueNo + "-" + fee.getId() + "-" + uomId + "-" + financialYearByDate.getId());
                    if (feeMatrix == null) {
                        throw new ValidationException("TL-002", "TL-002", new String[0]);
                    }
                    FeeMatrixDetail feeMatrixDetail = this.feeMatrixDetailService.findByLicenseFeeByRange(feeMatrix, ((License)((Object)license)).getTradeArea_weight(), ((License)((Object)license)).getApplicationDate(), financialYearByDate.getId());
                    if (feeMatrixDetail == null) {
                        throw new ValidationException("TL-003", "TL-003", new String[0]);
                    }
                    feeMatrixDetailList.add(feeMatrixDetail);
                    break;
                }
            }
        }
        return feeMatrixDetailList;
    }

    public List<FeeMatrix> findBySubCategory(LicenseSubCategory subCategory) {
        return this.feeMatrixRepository.findBySubCategory(subCategory);
    }

    private String generateFeeMatirixUniqueNo(T license, NatureOfBusiness permanent) {
        return permanent.getId() + "-" + ((License)((Object)license)).getLicenseAppType().getId() + "-" + ((License)((Object)license)).getCategory().getId() + "-" + ((License)((Object)license)).getTradeName().getId();
    }

    private String generateFeeMatirixUniqueNo(T license) {
        return ((License)((Object)license)).getNatureOfBusiness().getId() + "-" + ((License)((Object)license)).getLicenseAppType().getId() + "-" + ((License)((Object)license)).getCategory().getId() + "-" + ((License)((Object)license)).getTradeName().getId();
    }

    private String generateFeeMatirixUniqueNo(T license, LicenseAppType apptype) {
        return ((License)((Object)license)).getNatureOfBusiness().getId() + "-" + apptype.getId() + "-" + ((License)((Object)license)).getCategory().getId() + "-" + ((License)((Object)license)).getTradeName().getId();
    }

    private String generateFeeMatirixUniqueNo(T license, LicenseAppType apptype, NatureOfBusiness natureOfBusiness) {
        return natureOfBusiness.getId() + "-" + apptype.getId() + "-" + ((License)((Object)license)).getCategory().getId() + "-" + ((License)((Object)license)).getTradeName().getId();
    }
}

