/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.List;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.repository.LicenseDocumentTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DocumentTypeService {
    private final LicenseDocumentTypeRepository licenseDocumentTypeRepository;

    @Autowired
    public DocumentTypeService(LicenseDocumentTypeRepository licenseDocumentTypeRepository) {
        this.licenseDocumentTypeRepository = licenseDocumentTypeRepository;
    }

    @Transactional
    public LicenseDocumentType create(LicenseDocumentType documenttype) {
        return (LicenseDocumentType)((Object)this.licenseDocumentTypeRepository.save((Object)documenttype));
    }

    public LicenseDocumentType getDocumentTypeById(Long id) {
        return this.licenseDocumentTypeRepository.findById(id);
    }

    @Transactional
    public LicenseDocumentType update(LicenseDocumentType documenttype) {
        if (!documenttype.isEnabled()) {
            documenttype.setMandatory(false);
        }
        return (LicenseDocumentType)((Object)this.licenseDocumentTypeRepository.save((Object)documenttype));
    }

    public List<LicenseDocumentType> findAll() {
        return this.licenseDocumentTypeRepository.findAll();
    }

    public List<LicenseDocumentType> getDocumentTypesByApplicationType(ApplicationType applicationType) {
        return this.licenseDocumentTypeRepository.findByApplicationType(applicationType);
    }

    public List<LicenseDocumentType> search(String name, ApplicationType applicationType) {
        if (name != null && applicationType != null) {
            return this.licenseDocumentTypeRepository.findByNameAndApplicationType(name, applicationType);
        }
        if (name != null) {
            return this.licenseDocumentTypeRepository.findByName(name);
        }
        if (applicationType != null) {
            return this.licenseDocumentTypeRepository.findByApplicationType(applicationType);
        }
        return this.licenseDocumentTypeRepository.findAll();
    }
}

