/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.commons.Installment;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericHibDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.LicenseDocumentType;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.entity.enums.ApplicationType;
import org.egov.tl.repository.LicenseRepository;
import org.egov.tl.service.DocumentTypeService;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.LicenseAppTypeService;
import org.egov.tl.service.LicenseStatusService;
import org.egov.tl.service.NatureOfBusinessService;
import org.egov.tl.service.TradeLicenseUpdateIndexService;
import org.egov.tl.service.ValidityService;
import org.egov.tl.utils.LicenseNumberUtils;
import org.hibernate.CacheMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class AbstractLicenseService<T extends License> {
    public static final String ARREAR = "arrear";
    @Autowired
    @Qualifier(value="entityQueryService")
    protected PersistenceService entityQueryService;
    @Autowired
    protected InstallmentHibDao installmentDao;
    @Autowired
    protected LicenseNumberUtils licenseNumberUtils;
    @Autowired
    protected DocumentTypeService documentTypeService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    protected FileStoreService fileStoreService;
    @Autowired
    protected FeeMatrixService feeMatrixService;
    @Autowired
    @Qualifier(value="licenseDocumentTypeService")
    protected PersistenceService<LicenseDocumentType, Long> licenseDocumentTypeService;
    @Autowired
    protected TradeLicenseUpdateIndexService updateIndexService;
    @Autowired
    protected SecurityUtils securityUtils;
    @Autowired
    protected DemandGenericHibDao demandGenericDao;
    @Autowired
    protected ValidityService validityService;
    protected SimpleWorkflowService<T> licenseWorkflowService;
    @Autowired
    protected LicenseRepository licenseRepository;
    @Autowired
    protected LicenseStatusService licenseStatusService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    protected LicenseAppTypeService licenseAppTypeService;
    @Autowired
    protected PositionMasterService positionMasterService;
    @Autowired
    protected NatureOfBusinessService natureOfBusinessService;

    protected abstract LicenseAppType getLicenseApplicationTypeForRenew();

    protected abstract LicenseAppType getLicenseApplicationType();

    protected abstract Module getModuleName();

    protected abstract NatureOfBusiness getNatureOfBusiness();

    protected abstract void sendEmailAndSMS(T var1, String var2);

    public void setLicenseWorkflowService(SimpleWorkflowService<T> licenseWorkflowService) {
        this.licenseWorkflowService = licenseWorkflowService;
    }

    public T getLicenseById(Long id) {
        return (T)((Object)((License)((Object)this.licenseRepository.findOne(id))));
    }

    @Transactional
    public void create(T license, WorkflowBean workflowBean) {
        ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationType());
        this.raiseNewDemand(license);
        ((License)((Object)license)).getLicensee().setLicense((License)((Object)license));
        ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
        ((License)((Object)license)).setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TRADELICENSE", "CREATED"));
        ((License)((Object)license)).setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        this.processAndStoreDocument(((License)((Object)license)).getDocuments(), (License)((Object)license));
        this.transitionWorkFlow(license, workflowBean);
        this.licenseRepository.save(license);
        this.sendEmailAndSMS(license, workflowBean.getWorkFlowAction());
        this.updateIndexService.updateTradeLicenseIndexes((License)((Object)license));
    }

    private BigDecimal raiseNewDemand(T license) {
        LicenseDemand ld = new LicenseDemand();
        Module moduleName = this.getModuleName();
        BigDecimal totalAmount = BigDecimal.ZERO;
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(moduleName, ((License)((Object)license)).getApplicationDate());
        ld.setIsHistory("N");
        ld.setEgInstallmentMaster(installment);
        ld.setLicense((License)((Object)license));
        ld.setIsLateRenewal('0');
        ld.setCreateDate(new Date());
        List<FeeMatrixDetail> feeMatrixDetails = this.feeMatrixService.findFeeList(license);
        for (FeeMatrixDetail fm : feeMatrixDetails) {
            EgDemandReasonMaster reasonMaster = this.demandGenericDao.getDemandReasonMasterByCode(fm.getFeeMatrix().getFeeType().getName(), moduleName);
            EgDemandReason reason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(reasonMaster, installment, moduleName);
            if (fm.getFeeMatrix().getFeeType().getName().contains("Late") || reason == null) continue;
            ld.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)fm.getAmount(), (EgDemandReason)reason, (BigDecimal)BigDecimal.ZERO));
            totalAmount = totalAmount.add(fm.getAmount());
        }
        ld.setBaseDemand(totalAmount);
        ((License)((Object)license)).setLicenseDemand(ld);
        return totalAmount;
    }

    public License updateDemandForChangeTradeArea(T license) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getLicenseDemand();
        Module moduleName = this.getModuleName();
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(moduleName, ((License)((Object)license)).getApplicationDate());
        Set demandDetails = licenseDemand.getEgDemandDetails();
        List<FeeMatrixDetail> feeList = this.feeMatrixService.findFeeList(license);
        for (EgDemandDetails dmd : demandDetails) {
            for (FeeMatrixDetail fm : feeList) {
                if (!installment.getId().equals(dmd.getEgDemandReason().getEgInstallmentMaster().getId()) || !dmd.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(fm.getFeeMatrix().getFeeType().getName())) continue;
                dmd.setAmount(fm.getAmount());
                dmd.setModifiedDate(new Date());
            }
        }
        this.recalculateBaseDemand(licenseDemand);
        return license;
    }

    @Transactional
    public BigDecimal recalculateDemand(List<FeeMatrixDetail> feeList, T license) {
        Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), new Date());
        BigDecimal totalAmount = BigDecimal.ZERO;
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        for (EgDemandDetails dmd : licenseDemand.getEgDemandDetails()) {
            for (FeeMatrixDetail fm : feeList) {
                if (!installment.getId().equals(dmd.getEgDemandReason().getEgInstallmentMaster().getId()) || !dmd.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase(fm.getFeeMatrix().getFeeType().getName())) continue;
                dmd.setAmount(fm.getAmount());
                dmd.setAmtCollected(BigDecimal.ZERO);
                totalAmount = totalAmount.add(fm.getAmount());
            }
        }
        this.recalculateBaseDemand(licenseDemand);
        return totalAmount;
    }

    @Transactional
    public void createLegacyLicense(T license, Map<Integer, Integer> legacyInstallmentwiseFees, Map<Integer, Boolean> legacyFeePayStatus) {
        if (!this.licenseRepository.findByOldLicenseNumber(((License)((Object)license)).getOldLicenseNumber()).isEmpty()) {
            throw new ValidationException("TL-001", "TL-001", new String[]{((License)((Object)license)).getOldLicenseNumber()});
        }
        this.addLegacyDemand(legacyInstallmentwiseFees, legacyFeePayStatus, license);
        this.processAndStoreDocument(((License)((Object)license)).getDocuments(), (License)((Object)license));
        ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationType());
        ((License)((Object)license)).getLicensee().setLicense((License)((Object)license));
        ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Active"));
        ((License)((Object)license)).setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        ((License)((Object)license)).setLegacy(true);
        ((License)((Object)license)).setActive(true);
        ((License)((Object)license)).setLicenseNumber(this.licenseNumberUtils.generateLicenseNumber());
        this.validityService.applyLicenseValidity((License)((Object)license));
        this.licenseRepository.save(license);
    }

    private void addLegacyDemand(Map<Integer, Integer> legacyInstallmentwiseFees, Map<Integer, Boolean> legacyFeePayStatus, T license) {
        LicenseDemand licenseDemand = new LicenseDemand();
        licenseDemand.setIsHistory("N");
        licenseDemand.setCreateDate(new Date());
        licenseDemand.setLicense((License)((Object)license));
        licenseDemand.setIsLateRenewal('0');
        Module module = this.getModuleName();
        for (Map.Entry<Integer, Integer> legacyInstallmentwiseFee : legacyInstallmentwiseFees.entrySet()) {
            if (legacyInstallmentwiseFee.getValue() == null || legacyInstallmentwiseFee.getValue() <= 0) continue;
            Installment installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(module, legacyInstallmentwiseFee.getKey());
            licenseDemand.setEgInstallmentMaster(installment);
            BigDecimal demandAmount = BigDecimal.valueOf(legacyInstallmentwiseFee.getValue().intValue());
            BigDecimal amtCollected = legacyFeePayStatus.get(legacyInstallmentwiseFee.getKey()) == null || legacyFeePayStatus.get(legacyInstallmentwiseFee.getKey()) == false ? BigDecimal.ZERO : demandAmount;
            licenseDemand.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)demandAmount, (EgDemandReason)this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode("License Fee", module), installment, module), (BigDecimal)amtCollected));
            licenseDemand.setBaseDemand(demandAmount.add(licenseDemand.getBaseDemand()));
            licenseDemand.setAmtCollected(amtCollected.add(licenseDemand.getAmtCollected()));
        }
        ((License)((Object)license)).setLicenseDemand(licenseDemand);
    }

    @Transactional
    public void updateLegacyLicense(T license, Map<Integer, Integer> updatedInstallmentFees, Map<Integer, Boolean> legacyFeePayStatus) {
        this.updateLegacyDemand(license, updatedInstallmentFees, legacyFeePayStatus);
        this.processAndStoreDocument(((License)((Object)license)).getDocuments(), (License)((Object)license));
        this.licenseRepository.save(license);
    }

    private void updateLegacyDemand(T license, Map<Integer, Integer> updatedInstallmentFees, Map<Integer, Boolean> legacyFeePayStatus) {
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        Iterator demandDetails = licenseDemand.getEgDemandDetails().iterator();
        while (demandDetails.hasNext()) {
            EgDemandDetails demandDetail = (EgDemandDetails)demandDetails.next();
            Integer installmentNumber = demandDetail.getEgDemandReason().getEgInstallmentMaster().getInstallmentNumber();
            Integer updatedFee = updatedInstallmentFees.get(installmentNumber);
            Boolean feePaymentStatus = legacyFeePayStatus.get(installmentNumber);
            if (updatedFee != null) {
                BigDecimal updatedDemandAmt = BigDecimal.valueOf(updatedFee.intValue());
                demandDetail.setAmount(updatedDemandAmt);
                if (feePaymentStatus != null && feePaymentStatus.booleanValue()) {
                    demandDetail.setAmtCollected(updatedDemandAmt);
                } else {
                    demandDetail.setAmtCollected(BigDecimal.ZERO);
                }
            } else {
                demandDetails.remove();
            }
            updatedInstallmentFees.put(installmentNumber, 0);
        }
        Module module = this.getModuleName();
        for (Map.Entry<Integer, Integer> updatedInstallmentFee : updatedInstallmentFees.entrySet()) {
            if (updatedInstallmentFee.getValue() == null || updatedInstallmentFee.getValue() <= 0) continue;
            Installment installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(module, updatedInstallmentFee.getKey());
            BigDecimal demandAmount = BigDecimal.valueOf(updatedInstallmentFee.getValue().intValue());
            BigDecimal amtCollected = legacyFeePayStatus.get(updatedInstallmentFee.getKey()) == null || legacyFeePayStatus.get(updatedInstallmentFee.getKey()) == false ? BigDecimal.ZERO : demandAmount;
            licenseDemand.getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)demandAmount, (EgDemandReason)this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(this.demandGenericDao.getDemandReasonMasterByCode("License Fee", module), installment, module), (BigDecimal)amtCollected));
        }
        this.recalculateBaseDemand(licenseDemand);
    }

    public void recalculateBaseDemand(LicenseDemand licenseDemand) {
        licenseDemand.setAmtCollected(BigDecimal.ZERO);
        licenseDemand.setBaseDemand(BigDecimal.ZERO);
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            licenseDemand.setAmtCollected(licenseDemand.getAmtCollected().add(demandDetail.getAmtCollected()));
            licenseDemand.setBaseDemand(licenseDemand.getBaseDemand().add(demandDetail.getAmount()));
        }
    }

    @Transactional
    public void renew(T license, WorkflowBean workflowBean) {
        ((License)((Object)license)).setApplicationNumber(this.licenseNumberUtils.generateApplicationNumber());
        this.recalculateDemand(this.feeMatrixService.findFeeList(license), license);
        ((License)((Object)license)).setStatus(this.licenseStatusService.getLicenseStatusByName("Acknowledged"));
        ((License)((Object)license)).setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TRADELICENSE", "CREATED"));
        Position pos = null;
        ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationTypeForRenew());
        User currentUser = this.securityUtils.getCurrentUser();
        if (workflowBean.getApproverPositionId() != null && workflowBean.getApproverPositionId() != -1L) {
            pos = this.positionMasterService.getPositionById(workflowBean.getApproverPositionId());
        }
        WorkFlowMatrix wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
        license.reinitiateTransition().start().withSenderName(currentUser.getUsername() + "::" + currentUser.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(new DateTime().toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
        this.licenseRepository.save(license);
        this.sendEmailAndSMS(license, workflowBean.getWorkFlowAction());
        this.updateIndexService.updateTradeLicenseIndexes((License)((Object)license));
    }

    @Transactional
    public void transitionWorkFlow(T license, WorkflowBean workflowBean) {
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        if (null != ((License)((Object)license)).getId()) {
            wfInitiator = this.getWorkflowInitiator(license);
        }
        if (wfInitiator != null && "Reject".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            if (wfInitiator.equals(userAssignment)) {
                license.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
                if (((License)((Object)license)).getLicenseAppType() != null && ((License)((Object)license)).getLicenseAppType().getName().equals("Renew")) {
                    ((License)((Object)license)).setLicenseAppType(this.getLicenseApplicationType());
                }
            } else {
                String stateValue = license.getCurrentState().getValue().split(":")[0] + ":" + "Rejected";
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Sanitary inspector Approve pending");
            }
        } else if ("Generate Certificate".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
            license.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
        } else {
            WorkFlowMatrix wfmatrix;
            if (null != workflowBean.getApproverPositionId() && workflowBean.getApproverPositionId() != -1L) {
                pos = this.positionMasterService.getPositionById(workflowBean.getApproverPositionId());
            }
            if ("Approve".equalsIgnoreCase(workflowBean.getWorkFlowAction())) {
                Assignment commissionerUsr = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
                pos = commissionerUsr.getPosition();
            }
            if (null == license.getState()) {
                wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), workflowBean.getCurrentState(), null);
                license.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            } else if ("END".equalsIgnoreCase(license.getCurrentState().getNextAction())) {
                license.transition(true).end().withSenderName(user.getName()).withComments(workflowBean.getApproverComments()).withDateInfo(currentDate.toDate());
            } else {
                wfmatrix = this.licenseWorkflowService.getWfMatrix(license.getStateType(), null, null, workflowBean.getAdditionaRule(), license.getCurrentState().getValue(), null);
                license.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(workflowBean.getApproverComments()).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
            }
        }
    }

    protected Assignment getWorkflowInitiator(T license) {
        return this.assignmentService.getPrimaryAssignmentForUser(license.getCreatedBy().getId());
    }

    @Transactional
    public void processAndStoreDocument(List<LicenseDocument> documents, License license) {
        documents.forEach(document -> {
            document.setType((LicenseDocumentType)((Object)((Object)this.licenseDocumentTypeService.load((Serializable)document.getType().getId(), LicenseDocumentType.class))));
            if (!document.getUploads().isEmpty() && !document.getUploadsContentType().isEmpty()) {
                int fileCount = 0;
                for (File file : document.getUploads()) {
                    FileStoreMapper fileStore = this.fileStoreService.store(file, document.getUploadsFileName().get(fileCount), document.getUploadsContentType().get(fileCount++), "EGTL");
                    document.getFiles().add(fileStore);
                }
                document.setEnclosed(true);
            } else if (document.getType().isMandatory() && document.getFiles().isEmpty()) {
                document.getFiles().clear();
                throw new ValidationException("TL-004", "TL-004", new String[]{document.getType().getName()});
            }
            document.setDocDate(new Date());
            document.setLicense(license);
        });
    }

    public List<LicenseDocumentType> getDocumentTypesByApplicationType(ApplicationType applicationType) {
        return this.documentTypeService.getDocumentTypesByApplicationType(applicationType);
    }

    public List<NatureOfBusiness> getAllNatureOfBusinesses() {
        return this.natureOfBusinessService.findAll();
    }

    public T getLicenseByLicenseNumber(String licenseNumber) {
        return (T)((Object)this.licenseRepository.findByLicenseNumber(licenseNumber));
    }

    public T getLicenseByApplicationNumber(String applicationNumber) {
        return (T)((Object)this.licenseRepository.findByApplicationNumber(applicationNumber));
    }

    public List<Installment> getLastFiveYearInstallmentsForLicense() {
        List installmentList = this.installmentDao.fetchInstallments(this.getModuleName(), new Date(), 6);
        Collections.reverse(installmentList);
        return installmentList;
    }

    public Map<String, Map<String, BigDecimal>> getOutstandingFee(T license) {
        HashMap<String, Map<String, BigDecimal>> outstandingFee = new HashMap<String, Map<String, BigDecimal>>();
        Installment currentInstallmentYear = this.installmentDao.getInsatllmentByModuleForGivenDate(this.getModuleName(), new Date());
        LicenseDemand licenseDemand = ((License)((Object)license)).getCurrentDemand();
        for (EgDemandDetails demandDetail : licenseDemand.getEgDemandDetails()) {
            Map<String, BigDecimal> feeByTypes;
            String demandReason = demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster();
            Installment installmentYear = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (outstandingFee.containsKey(demandReason)) {
                feeByTypes = (Map)outstandingFee.get(demandReason);
            } else {
                feeByTypes = new HashMap();
                feeByTypes.put(ARREAR, BigDecimal.ZERO);
                feeByTypes.put("current", BigDecimal.ZERO);
            }
            BigDecimal demandAmount = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (installmentYear.equals((Object)currentInstallmentYear)) {
                feeByTypes.put("current", demandAmount);
            } else {
                feeByTypes.put(ARREAR, ((BigDecimal)feeByTypes.get(ARREAR)).add(demandAmount));
            }
            outstandingFee.put(demandReason, feeByTypes);
        }
        return outstandingFee;
    }

    public List<T> getAllLicensesByNatureOfBusiness(String natureOfBusiness) {
        return this.entityQueryService.getSession().createCriteria(License.class).createAlias("natureOfBusiness", "nb", JoinType.LEFT_OUTER_JOIN).add((Criterion)Restrictions.eq((String)"nb.name", (Object)natureOfBusiness)).setCacheMode(CacheMode.IGNORE).list();
    }

    @Transactional
    public void save(License license) {
        this.licenseRepository.save((Object)license);
    }
}

