/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.FeeType;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.UnitOfMeasurement;

@Entity
@Table(name="egtl_feematrix")
@SequenceGenerator(name="seq_egtl_feematrix", sequenceName="seq_egtl_feematrix", allocationSize=1)
public class FeeMatrix
extends AbstractAuditable {
    public static final String SEQ = "seq_egtl_feematrix";
    private static final long serialVersionUID = 3119126267277124321L;
    @Id
    @GeneratedValue(generator="seq_egtl_feematrix", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="natureOfBusiness")
    private NatureOfBusiness natureOfBusiness;
    @NotNull
    @ManyToOne
    @JoinColumn(name="licenseCategory")
    private LicenseCategory licenseCategory;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subCategory")
    private LicenseSubCategory subCategory;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="licenseAppType")
    private LicenseAppType licenseAppType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="feeType")
    private FeeType feeType;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="financialYear")
    private CFinancialYear financialYear;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="unitOfMeasurement")
    private UnitOfMeasurement unitOfMeasurement;
    private String uniqueNo;
    @Valid
    @OrderBy(value="uomFrom")
    @OneToMany(mappedBy="feeMatrix", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<FeeMatrixDetail> feeMatrixDetail = new ArrayList<FeeMatrixDetail>(0);

    public FeeType getFeeType() {
        return this.feeType;
    }

    public void setFeeType(FeeType feeType) {
        this.feeType = feeType;
    }

    public NatureOfBusiness getNatureOfBusiness() {
        return this.natureOfBusiness;
    }

    public void setNatureOfBusiness(NatureOfBusiness natureOfBusiness) {
        this.natureOfBusiness = natureOfBusiness;
    }

    public LicenseCategory getLicenseCategory() {
        return this.licenseCategory;
    }

    public void setLicenseCategory(LicenseCategory licenseCategory) {
        this.licenseCategory = licenseCategory;
    }

    public LicenseSubCategory getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(LicenseSubCategory subCategory) {
        this.subCategory = subCategory;
    }

    public LicenseAppType getLicenseAppType() {
        return this.licenseAppType;
    }

    public void setLicenseAppType(LicenseAppType licenseAppType) {
        this.licenseAppType = licenseAppType;
    }

    public UnitOfMeasurement getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    public void setUnitOfMeasurement(UnitOfMeasurement unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getAmount() {
        return null;
    }

    public List<FeeMatrixDetail> getFeeMatrixDetail() {
        return this.feeMatrixDetail;
    }

    public void setFeeMatrixDetail(List<FeeMatrixDetail> feeMatrixDetail) {
        this.feeMatrixDetail = feeMatrixDetail;
    }

    public String getUniqueNo() {
        return this.uniqueNo;
    }

    public void setUniqueNo(String uniqueNo) {
        this.uniqueNo = uniqueNo;
    }

    public CFinancialYear getFinancialYear() {
        return this.financialYear;
    }

    public void setFinancialYear(CFinancialYear financialYear) {
        this.financialYear = financialYear;
    }

    public String genUniqueNo() {
        StringBuilder sb = new StringBuilder();
        if (this.natureOfBusiness != null) {
            sb.append(this.natureOfBusiness.getId());
        }
        if (this.licenseAppType != null) {
            sb.append("-" + this.licenseAppType.getId());
        }
        if (this.licenseCategory != null) {
            sb.append("-" + this.licenseCategory.getId());
        }
        if (this.subCategory != null) {
            sb.append("-" + this.subCategory.getId());
        }
        if (this.feeType != null) {
            sb.append("-" + this.feeType.getId());
        }
        if (this.unitOfMeasurement != null) {
            sb.append("-" + this.unitOfMeasurement.getId());
        }
        if (this.financialYear != null) {
            sb.append("-" + this.financialYear.getId());
        }
        return sb.toString();
    }
}

