/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service.masters;

import java.util.List;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.LicenseSubCategoryDetails;
import org.egov.tl.repository.LicenseSubCategoryRepository;
import org.egov.tl.service.LicenseTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LicenseSubCategoryService {
    @Autowired
    private LicenseSubCategoryRepository licenseSubCategoryRepository;
    @Autowired
    private LicenseTypeService licenseTypeService;

    @Transactional
    public void createSubCategory(LicenseSubCategory subCategory) {
        subCategory.setLicenseType(this.licenseTypeService.getLicenseTypeByName("TradeLicense"));
        for (LicenseSubCategoryDetails categoryDetails : subCategory.getLicenseSubCategoryDetails()) {
            categoryDetails.setSubCategory(subCategory);
        }
        this.licenseSubCategoryRepository.save((Object)subCategory);
    }

    @Transactional
    public void updateLicenseSubCategory(LicenseSubCategory licenseSubCategory) {
        licenseSubCategory.getLicenseSubCategoryDetails().removeIf(LicenseSubCategoryDetails::isMarkedForRemoval);
        for (LicenseSubCategoryDetails categoryDetails : licenseSubCategory.getLicenseSubCategoryDetails()) {
            categoryDetails.setSubCategory(licenseSubCategory);
        }
        this.licenseSubCategoryRepository.save((Object)licenseSubCategory);
    }

    public List<LicenseSubCategory> findAllSubCategoryByCategory(Long categoryId) {
        return this.licenseSubCategoryRepository.findAllByCategoryId(categoryId);
    }

    public LicenseSubCategory findSubCategoryByName(String name) {
        return this.licenseSubCategoryRepository.findByName(name);
    }

    public LicenseSubCategory findSubCategoryByCode(String code) {
        return this.licenseSubCategoryRepository.findByCode(code);
    }

    public LicenseSubCategory findById(Long subCategoryId) {
        return this.licenseSubCategoryRepository.findOne(subCategoryId);
    }

    public List<LicenseSubCategory> findAll() {
        return this.licenseSubCategoryRepository.findAll();
    }

    public List<LicenseSubCategory> getLicenseSubCategoriesByLicenseTypeName(String licenseTypeName) {
        return this.licenseSubCategoryRepository.findByLicenseType_Name(licenseTypeName);
    }
}

