/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.search.elastic.entity.ApplicationIndex;
import org.egov.infra.search.elastic.entity.ApplicationIndexBuilder;
import org.egov.infra.search.elastic.entity.enums.ApprovalStatus;
import org.egov.infra.search.elastic.entity.enums.ClosureStatus;
import org.egov.infra.search.elastic.service.ApplicationIndexService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.tl.entity.License;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TradeLicenseUpdateIndexService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public void updateTradeLicenseIndexes(License license) {
        User user = null;
        if (license.getState() != null && license.getState().getOwnerPosition() != null) {
            Assignment assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(license.getState().getOwnerPosition().getId(), new Date());
            List<Object> asignList = null;
            if (assignment != null) {
                asignList = new ArrayList<Assignment>();
                asignList.add(assignment);
            } else if (assignment == null) {
                asignList = this.assignmentService.getAssignmentsForPosition(license.getState().getOwnerPosition().getId(), new Date());
            }
            if (!asignList.isEmpty()) {
                user = this.userService.getUserById(((Assignment)asignList.get(0)).getEmployee().getId());
            }
        } else {
            user = this.securityUtils.getCurrentUser();
        }
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(license.getApplicationNumber());
        if (applicationIndex != null) {
            if (applicationIndex != null && null != license.getId() && license.getEgwStatus() != null && (license.getEgwStatus().getCode().equals("INSPECTIONDONE") || license.getEgwStatus().getCode().equals("APPROVED") || license.getEgwStatus().getCode().equals("SECONDLVLCOLLECTIONPENDING") || license.getEgwStatus().getCode().equals("CERTIFICATEGENERATED") || license.getEgwStatus().getCode().equals("DIGITALSIGNPENDING")) || license.getStatus().getStatusCode().equals("CAN") || license.getStatus().getStatusCode().equals("FIRSTLVLCOLLECTIONDONE") || license.getEgwStatus().getCode().equals("CREATED") && license.getState().getValue().contains("Rejected")) {
                applicationIndex.setStatus(license.getEgwStatus().getDescription());
                applicationIndex.setApplicantAddress(license.getAddress());
                applicationIndex.setOwnername(user.getUsername() + "::" + user.getName());
                if (license.getLicenseNumber() != null) {
                    applicationIndex.setConsumerCode(license.getLicenseNumber());
                }
                int noofDays = 0;
                applicationIndex.setClosed(ClosureStatus.NO);
                applicationIndex.setApproved(ApprovalStatus.INPROGRESS);
                Date endDate = null;
                if (license.getEgwStatus().getCode().equals("CERTIFICATEGENERATED")) {
                    List stateHistoryList = license.getStateHistory();
                    for (StateHistory stateHisObj : stateHistoryList) {
                        if (!stateHisObj.getValue().equalsIgnoreCase("Create License:generate Certificate")) continue;
                        endDate = stateHisObj.getLastModifiedDate();
                    }
                    Date startDate = license.getApplicationDate();
                    if (endDate == null) {
                        endDate = license.getLastModifiedDate();
                    }
                    noofDays = DateUtils.noOfDays((Date)startDate, (Date)endDate);
                    applicationIndex.setElapsedDays(Integer.valueOf(noofDays));
                    applicationIndex.setClosed(ClosureStatus.YES);
                    applicationIndex.setApproved(ApprovalStatus.APPROVED);
                }
                if (license.getStatus().getStatusCode().equals("CAN")) {
                    applicationIndex.setApproved(ApprovalStatus.REJECTED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                }
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
        } else {
            String strQuery = "select md from EgModules md where md.name=:name";
            Query hql = this.getCurrentSession().createQuery("select md from EgModules md where md.name=:name");
            hql.setParameter("name", (Object)"Trade License");
            if (license.getApplicationDate() == null) {
                license.setApplicationDate(new Date());
            }
            if (license.getApplicationNumber() == null) {
                license.setApplicationNumber(license.getApplicationNumber());
            }
            if (applicationIndex == null) {
                String url = "/tl/viewtradelicense/viewTradeLicense-view.action?applicationNo=" + license.getApplicationNumber();
                ApplicationIndexBuilder applicationIndexBuilder = new ApplicationIndexBuilder("Trade License", license.getApplicationNumber(), license.getApplicationDate(), license.getLicenseAppType().getName().toString(), license.getLicensee().getApplicantName(), license.getEgwStatus().getDescription().toString(), url, license.getAddress().toString(), user.getUsername() + "::" + user.getName(), Source.SYSTEM.toString());
                applicationIndexBuilder.mobileNumber(license.getLicensee().getMobilePhoneNumber().toString());
                applicationIndexBuilder.aadharNumber(license.getLicensee().getUid());
                applicationIndexBuilder.closed(ClosureStatus.NO);
                applicationIndexBuilder.approved(ApprovalStatus.INPROGRESS);
                applicationIndex = applicationIndexBuilder.build();
                if (license.getIsActive()) {
                    this.applicationIndexService.createApplicationIndex(applicationIndex);
                }
            }
        }
    }
}

