/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service.integration;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.egov.InvalidAccountHeadException;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.dao.EgBillDetailsDao;
import org.egov.demand.dao.EgBillReceiptDao;
import org.egov.demand.dao.EgdmCollectedReceiptDao;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.BillReceipt;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.demand.model.EgReasonCategory;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.demand.utils.DemandConstants;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.tl.entity.License;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.service.TradeLicenseSmsAndEmailService;
import org.egov.tl.service.es.LicenseApplicationIndexService;
import org.egov.tl.service.integration.DemandComparatorByOrderId;
import org.egov.tl.service.integration.LicenseBill;
import org.egov.tl.utils.Constants;
import org.egov.tl.utils.LicenseUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@Scope(value="prototype")
public class LicenseBillService
extends BillServiceInterface
implements BillingIntegrationService {
    public static final String TL_FUNCTION_CODE = "1500";
    private static final Logger LOG = LoggerFactory.getLogger(LicenseBillService.class);
    protected License license;
    @Autowired
    private EgBillDetailsDao egBillDetailsDao;
    @Autowired
    @Qualifier(value="tradeLicenseWorkflowService")
    private SimpleWorkflowService tradeLicenseWorkflowService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgBillReceiptDao egBillReceiptDao;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private LicenseApplicationIndexService licenseApplicationIndexService;
    @Autowired
    private TradeLicenseSmsAndEmailService tradeLicenseSmsAndEmailService;
    @Autowired
    private EgBillDao egBillDao;
    @Autowired
    private DemandGenericDao demandGenericDao;
    @Autowired
    private EgdmCollectedReceiptDao egdmCollectedReceiptDao;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    @Qualifier(value="entityQueryService")
    private PersistenceService entityQueryService;
    @Autowired
    private LicenseUtils licenseUtils;

    public void setLicense(License license) {
        this.license = license;
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        Module module;
        ArrayList<EgBillDetails> billDetails = new ArrayList<EgBillDetails>();
        LicenseBill billable = (LicenseBill)billObj;
        EgDemand demand = billObj.getCurrentDemand();
        Date currentDate = new Date();
        HashMap installmentWise = new HashMap();
        TreeSet<Installment> sortedInstallmentSet = new TreeSet<Installment>();
        DemandComparatorByOrderId demandComparatorByOrderId = new DemandComparatorByOrderId();
        Module module2 = module = this.license.getTradeName() != null && this.license.getTradeName().getLicenseType() != null ? this.license.getTradeName().getLicenseType().getModule() : null;
        if (module == null) {
            module = this.moduleService.getModuleByName("Trade License");
        }
        this.getCurrentInstallment(module);
        ArrayList orderedDetailsList = new ArrayList();
        Map<Object, Object> installmentPenalty = new HashMap();
        if ("New".equals(this.license.getLicenseAppType().getName())) {
            installmentPenalty = billable.getCalculatedPenalty(this.license.getCommencementDate(), new Date(), demand);
        } else if ("Renew".equals(this.license.getLicenseAppType().getName())) {
            installmentPenalty = billable.getCalculatedPenalty(null, new Date(), demand);
        }
        Map<Installment, EgDemandDetails> installmentWisePenaltyDemandDetail = this.getInstallmentWisePenaltyDemandDetails(this.license.getCurrentDemand());
        for (Map.Entry<Object, Object> penalty : installmentPenalty.entrySet()) {
            if (((BigDecimal)penalty.getValue()).signum() <= 0) continue;
            EgDemandDetails penaltyDemandDetail = installmentWisePenaltyDemandDetail.get(penalty.getKey());
            if (penaltyDemandDetail != null) {
                penaltyDemandDetail.setAmount(((BigDecimal)penalty.getValue()).setScale(0, RoundingMode.HALF_UP));
                continue;
            }
            penaltyDemandDetail = this.insertPenaltyAndBillDetails(((BigDecimal)penalty.getValue()).setScale(0, RoundingMode.HALF_UP), (Installment)penalty.getKey());
            if (penaltyDemandDetail == null) continue;
            demand.getEgDemandDetails().add(penaltyDemandDetail);
            demand.addBaseDemand(penaltyDemandDetail.getAmount());
        }
        for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
            Installment installment = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (installmentWise.get(installment) == null) {
                ArrayList<EgDemandDetails> detailsList = new ArrayList<EgDemandDetails>();
                detailsList.add(demandDetail);
                installmentWise.put(demandDetail.getEgDemandReason().getEgInstallmentMaster(), detailsList);
                sortedInstallmentSet.add(installment);
                continue;
            }
            ((List)installmentWise.get(demandDetail.getEgDemandReason().getEgInstallmentMaster())).add(demandDetail);
        }
        for (Installment i : sortedInstallmentSet) {
            List installmentWiseDetails = (List)installmentWise.get(i);
            Collections.sort(installmentWiseDetails, demandComparatorByOrderId);
            orderedDetailsList.addAll(installmentWiseDetails);
        }
        int i = 1;
        for (EgDemandDetails demandDetail : orderedDetailsList) {
            EgDemandReason reason = demandDetail.getEgDemandReason();
            Installment installment = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (!"N".equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDebit()) || demandDetail.getAmount().subtract(demandDetail.getAmtRebate()).compareTo(demandDetail.getAmtCollected()) == 0) continue;
            EgBillDetails billdetail = new EgBillDetails();
            EgBillDetails billdetailRebate = new EgBillDetails();
            if (demandDetail.getAmtRebate() != null && demandDetail.getAmtRebate().compareTo(BigDecimal.ZERO) != 0) {
                EgReasonCategory reasonCategory = this.demandGenericDao.getReasonCategoryByCode("REBATE");
                List demandReasonMasterByCategory = this.demandGenericDao.getDemandReasonMasterByCategoryAndModule(reasonCategory, module);
                for (EgDemandReasonMaster demandReasonMaster : demandReasonMasterByCategory) {
                    EgDemandReason reasonDed = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(demandReasonMaster, installment, module);
                    if (!demandDetail.getEgDemandReason().getId().equals(reasonDed.getEgDemandReason().getId())) continue;
                    billdetailRebate.setDrAmount(demandDetail.getAmtRebate());
                    billdetailRebate.setCrAmount(BigDecimal.ZERO);
                    billdetailRebate.setGlcode(reasonDed.getGlcodeId().getGlcode());
                    billdetailRebate.setEgDemandReason(demandDetail.getEgDemandReason());
                    billdetailRebate.setAdditionalFlag(Integer.valueOf(1));
                    billdetailRebate.setCreateDate(currentDate);
                    billdetailRebate.setModifiedDate(currentDate);
                    billdetailRebate.setOrderNo(Integer.valueOf(i++));
                    billdetailRebate.setDescription(reasonDed.getEgDemandReasonMaster().getReasonMaster() + " - " + installment.getDescription());
                    billdetailRebate.setFunctionCode(TL_FUNCTION_CODE);
                    billdetailRebate.setPurpose(BillAccountDetails.PURPOSE.REBATE.toString());
                    billDetails.add(billdetailRebate);
                }
            }
            if (demandDetail.getAmount() != null) {
                billdetail.setDrAmount(BigDecimal.ZERO);
                billdetail.setCrAmount(demandDetail.getAmount().subtract(demandDetail.getAmtCollected()));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("demandDetail.getEgDemandReason()" + demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster() + " glcodeerror" + demandDetail.getEgDemandReason().getGlcodeId()));
            }
            billdetail.setGlcode(demandDetail.getEgDemandReason().getGlcodeId().getGlcode());
            billdetail.setEgDemandReason(demandDetail.getEgDemandReason());
            billdetail.setAdditionalFlag(Integer.valueOf(1));
            billdetail.setCreateDate(currentDate);
            billdetail.setModifiedDate(currentDate);
            billdetail.setOrderNo(Integer.valueOf(i++));
            billdetail.setDescription(reason.getEgDemandReasonMaster().getReasonMaster() + " - " + installment.getDescription());
            billdetail.setFunctionCode(TL_FUNCTION_CODE);
            billdetail.setPurpose(BillAccountDetails.PURPOSE.CURRENT_AMOUNT.toString());
            billDetails.add(billdetail);
        }
        if (LOGGER.isDebugEnabled()) {
            LOG.debug("created Bill Details");
        }
        return billDetails;
    }

    public Map<Installment, EgDemandDetails> getInstallmentWisePenaltyDemandDetails(EgDemand currentDemand) {
        TreeMap<Installment, EgDemandDetails> installmentWisePenaltyDemandDetails = new TreeMap<Installment, EgDemandDetails>();
        if (currentDemand != null) {
            for (EgDemandDetails dmdDet : currentDemand.getEgDemandDetails()) {
                if (!dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode().equals("Penalty")) continue;
                installmentWisePenaltyDemandDetails.put(dmdDet.getEgDemandReason().getEgInstallmentMaster(), dmdDet);
            }
        }
        return installmentWisePenaltyDemandDetails;
    }

    private EgDemandDetails insertPenaltyAndBillDetails(BigDecimal penalty, Installment installment) {
        return this.insertPenaltyDmdDetail(installment, penalty);
    }

    private EgDemandDetails insertPenaltyDmdDetail(Installment inst, BigDecimal penaltyAmount) {
        EgDemandDetails demandDetail = null;
        if (penaltyAmount != null && penaltyAmount.compareTo(BigDecimal.ZERO) > 0) {
            Module module = this.license.getTradeName().getLicenseType().getModule();
            EgDemandReasonMaster egDemandReasonMaster = this.demandGenericDao.getDemandReasonMasterByCode("Penalty", module);
            if (egDemandReasonMaster == null) {
                throw new ApplicationRuntimeException(" Penalty Demand reason Master is null in method  insertPenalty");
            }
            EgDemandReason egDemandReason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(egDemandReasonMaster, inst, module);
            if (egDemandReason == null) {
                throw new ApplicationRuntimeException(" Penalty Demand reason is null in method  insertPenalty ");
            }
            demandDetail = this.createDemandDetails(egDemandReason, BigDecimal.ZERO, penaltyAmount);
        }
        return demandDetail;
    }

    public EgDemandDetails createDemandDetails(EgDemandReason egDemandReason, BigDecimal amtCollected, BigDecimal dmdAmount) {
        return EgDemandDetails.fromReasonAndAmounts((BigDecimal)dmdAmount, (EgDemandReason)egDemandReason, (BigDecimal)amtCollected);
    }

    public void updateReceiptDetails(Set<BillReceiptInfo> billReceipts) {
        if (billReceipts != null) {
            try {
                this.updateNewReceipt(billReceipts);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occurred while updating receipt details for License");
                throw new ApplicationRuntimeException("Update Receipt Failed", (Throwable)e);
            }
        }
    }

    @Transactional
    public Boolean updateDemandDetails(BillReceiptInfo billReceipt) {
        try {
            BillReceiptInfoImpl billReceiptInfoImpl = (BillReceiptInfoImpl)billReceipt;
            EgBill bill = this.egBillDao.findById(Long.valueOf(billReceiptInfoImpl.getBillReferenceNum()), false);
            EgDemand demand = bill.getEgDemand();
            if (billReceipt.getEvent().equals("RECEIPT_CREATED")) {
                LicenseDemand ld = (LicenseDemand)((Object)this.entityQueryService.load((Serializable)demand.getId(), LicenseDemand.class));
                ld.getLicense().getTradeName().getLicenseType().getModule();
                HashMap installmentWiseDemandDetailsByReason = new HashMap();
                for (EgDemandDetails dmdDtls : demand.getEgDemandDetails()) {
                    if (dmdDtls.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                        EgDemandReason dmdRsn = dmdDtls.getEgDemandReason();
                        String installmentDesc = dmdRsn.getEgInstallmentMaster().getDescription();
                        HashMap<String, EgDemandDetails> demandDetailByReason = new HashMap<String, EgDemandDetails>();
                        if (installmentWiseDemandDetailsByReason.get(installmentDesc) == null) {
                            demandDetailByReason.put(dmdRsn.getEgDemandReasonMaster().getReasonMaster(), dmdDtls);
                            installmentWiseDemandDetailsByReason.put(installmentDesc, demandDetailByReason);
                            continue;
                        }
                        ((Map)installmentWiseDemandDetailsByReason.get(installmentDesc)).put(dmdRsn.getEgDemandReasonMaster().getReasonMaster(), dmdDtls);
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("saveCollectionDetails - demand detail amount is zero " + dmdDtls));
                }
                for (ReceiptAccountInfo rcptAccInfo : billReceipt.getAccountDetails()) {
                    if (rcptAccInfo.getDescription() == null || rcptAccInfo.getDescription().isEmpty() || rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1) continue;
                    String[] desc = rcptAccInfo.getDescription().split("-", 2);
                    String reason = desc[0].trim();
                    String instDesc = desc[1].trim();
                    EgDemandDetails demandDetail = (EgDemandDetails)((Map)installmentWiseDemandDetailsByReason.get(instDesc)).get(reason);
                    demandDetail.addCollectedWithOnePaisaTolerance(rcptAccInfo.getCrAmount());
                    if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDemand().booleanValue()) {
                        demand.addCollected(rcptAccInfo.getCrAmount());
                    }
                    this.persistCollectedReceipts(demandDetail, billReceipt.getReceiptNum(), billReceipt.getTotalAmount(), billReceipt.getReceiptDate(), demandDetail.getAmtCollected());
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("Persisted demand and receipt details for tax : " + reason + " installment : " + instDesc + " with receipt No : " + billReceipt.getReceiptNum() + " for Rs. " + rcptAccInfo.getCrAmount()));
                }
                if (ld.getLicense().getState() != null) {
                    this.updateWorkflowState(ld.getLicense());
                }
                this.licenseApplicationIndexService.createOrUpdateLicenseApplicationIndex(ld.getLicense());
                this.tradeLicenseSmsAndEmailService.sendSMsAndEmailOnCollection(ld.getLicense(), billReceipt.getReceiptDate(), ld.getLicense().getCurrentLicenseFee());
            } else if (billReceipt.getEvent().equals("RECEIPT_CANCELLED")) {
                this.reconcileCollForRcptCancel(demand, billReceipt);
            } else if (billReceipt.getEvent().equals("INSTRUMENT_BOUNCED")) {
                this.reconcileCollForChequeBounce(demand, billReceipt);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error occurred while updating demand details", (Throwable)e);
            throw new ApplicationRuntimeException("Updating Demand Details Failed", (Throwable)e);
        }
        return true;
    }

    @Transactional
    public void updateWorkflowState(License licenseObj) {
        String natureOfWork;
        Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(licenseObj.getCreatedBy().getId());
        Position pos = wfInitiator.getPosition();
        DateTime currentDate = new DateTime();
        User user = this.securityUtils.getCurrentUser();
        Boolean digitalSignEnabled = this.licenseUtils.isDigitalSignEnabled();
        WorkFlowMatrix wfmatrix = null;
        String string = natureOfWork = licenseObj.getLicenseAppType().getName().equals("Renew") ? "Renewal of Trade License" : "New Trade License";
        if (digitalSignEnabled.booleanValue() && !licenseObj.getEgwStatus().getCode().equals("CREATED")) {
            this.licenseUtils.applicationStatusChange(licenseObj, "DIGITALSIGNPENDING");
            pos = this.licenseUtils.getCityLevelCommissioner();
            this.licenseUtils.applicationStatusChange(licenseObj, "APPROVED");
            if (licenseObj.getLicenseAppType() != null && licenseObj.getLicenseAppType().getName().equals("Renew")) {
                licenseObj.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments("Second level fee collected").withStateValue("Digital sign-Second level fee collected").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("Digital Signature Pending");
            } else {
                licenseObj.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments("Second level fee collected").withStateValue("Digital sign-Second level fee collected").withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("Digital Signature Pending");
            }
        } else {
            this.licenseUtils.licenseStatusUpdate(licenseObj, "UWF");
            if (licenseObj.getEgwStatus().getCode().equals("CREATED")) {
                this.licenseUtils.applicationStatusChange(licenseObj, "FIRSTLVLCOLLECTIONDONE");
            } else {
                this.licenseUtils.applicationStatusChange(licenseObj, "APPROVED");
            }
            if (licenseObj.getLicenseAppType() != null && licenseObj.getLicenseAppType().getName().equals("Renew")) {
                if (licenseObj.getEgwStatus().getCode().equals("FIRSTLVLCOLLECTIONDONE")) {
                    wfmatrix = this.tradeLicenseWorkflowService.getWfMatrix("TradeLicense", null, null, "RENEWTRADELICENSE", "License Created", null);
                } else if (licenseObj.getEgwStatus().getCode().equals("APPROVED")) {
                    wfmatrix = this.tradeLicenseWorkflowService.getWfMatrix("TradeLicense", null, null, "RENEWTRADELICENSE", "Commissioner approved", null);
                }
            } else if (licenseObj.getLicenseAppType() != null && licenseObj.getLicenseAppType().getName().equals("New")) {
                if (licenseObj.getEgwStatus().getCode().equals("FIRSTLVLCOLLECTIONDONE")) {
                    wfmatrix = this.tradeLicenseWorkflowService.getWfMatrix("TradeLicense", null, null, "NEWTRADELICENSE", "License Created", null);
                } else if (licenseObj.getEgwStatus().getCode().equals("APPROVED")) {
                    wfmatrix = this.tradeLicenseWorkflowService.getWfMatrix("TradeLicense", null, null, "NEWTRADELICENSE", "Commissioner approved", null);
                }
            }
            licenseObj.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(wfmatrix.getNextStatus()).withNatureOfTask(natureOfWork).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(licenseObj.getState().getInitiatorPosition()).withNextAction(wfmatrix.getNextAction());
        }
    }

    protected void reconcileCollForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        this.cancelBill(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        demand.setAmtCollected(demand.getAmtCollected().subtract(billRcptInfo.getTotalAmount()));
        this.updateDmdDetForRcptCancel(demand, billRcptInfo);
    }

    private EgDemand cancelBill(Long billId) {
        EgDemand egDemand = null;
        if (billId != null) {
            EgBill egBill = this.egBillDao.findById(billId, false);
            egBill.setIs_Cancelled("Y");
        }
        return egDemand;
    }

    private void updateDmdDetForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)"Entering method updateDmdDetForRcptCancel");
        for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || rcptAccInfo.getIsRevenueAccount()) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String installment = desc[1].trim();
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (!reason.equals(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) || !installment.equals(demandDetail.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
                demandDetail.setAmtCollected(demandDetail.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
                LOGGER.info((Object)("Deducted Collected amount and receipt details for tax : " + reason + " installment : " + installment + " with receipt No : " + billRcptInfo.getReceiptNum() + " for Rs. " + demandDetail.getAmtCollected()));
            }
        }
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        LOGGER.debug((Object)"Exiting method saveCollectionAndDemandDetails");
    }

    protected void updateReceiptStatusWhenCancelled(String receiptNumber) {
        List egdmCollectedReceipts = this.demandGenericDao.getAllEgdmCollectedReceipts(receiptNumber);
        if (egdmCollectedReceipts != null && !egdmCollectedReceipts.isEmpty()) {
            for (EgdmCollectedReceipt egDmCollectedReceipt : egdmCollectedReceipts) {
                egDmCollectedReceipt.setStatus(DemandConstants.CANCELLED_RECEIPT);
                egDmCollectedReceipt.setUpdatedTime(new Date());
            }
        }
    }

    protected BigDecimal reconcileCollForChequeBounce(EgDemand demand, BillReceiptInfo billRcptInfo) {
        EgDemandDetails dmdDet;
        LOGGER.debug((Object)("updateDemandForChequeBounce : Updating Collection For Demand : Demand - " + demand + " with BillReceiptInfo - " + billRcptInfo));
        LicenseDemand ld = (LicenseDemand)demand;
        BigDecimal totalCollChqBounced = this.getTotalChequeAmt(billRcptInfo);
        BigDecimal chqBouncePenalty = Constants.CHQ_BOUNCE_PENALTY;
        EgDemandDetails penaltyDmdDet = this.getDemandDetail(demand, "CHEQUE BOUNCE PENALTY");
        if (penaltyDmdDet == null) {
            dmdDet = this.insertPenalty(chqBouncePenalty, ld.getLicense().getTradeName().getLicenseType().getModule());
        } else {
            BigDecimal existDmdDetAmt = penaltyDmdDet.getAmount();
            existDmdDetAmt = existDmdDetAmt == null || existDmdDetAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : existDmdDetAmt;
            penaltyDmdDet.setAmount(existDmdDetAmt.add(chqBouncePenalty));
            dmdDet = penaltyDmdDet;
        }
        demand.setMinAmtPayable(totalCollChqBounced.add(chqBouncePenalty));
        demand.setAmtCollected(demand.getAmtCollected().subtract(billRcptInfo.getTotalAmount()));
        demand.setBaseDemand(demand.getBaseDemand().add(chqBouncePenalty));
        demand.setStatus(Constants.DMD_STATUS_CHEQUE_BOUNCED);
        demand.addEgDemandDetails(dmdDet);
        totalCollChqBounced = this.updateDmdDetForChqBounce(demand, totalCollChqBounced);
        LOGGER.debug((Object)("updateDemandForChequeBounce : Updated Collection For Demand : " + demand));
        return totalCollChqBounced;
    }

    private BigDecimal updateDmdDetForChqBounce(EgDemand demand, BigDecimal totalCollChqBounced) {
        List demandList = (List)((Object)demand.getEgDemandDetails());
        Collections.sort(demandList, new DemandComparatorByOrderId());
        Collections.reverse(demandList);
        for (EgDemandDetails dd : demandList) {
            BigDecimal amtCollected = dd.getAmtCollected();
            if ((totalCollChqBounced = totalCollChqBounced.subtract(amtCollected)).longValue() >= 0L) {
                dd.setAmtCollected(BigDecimal.ZERO);
                demand.setBaseDemand(demand.getBaseDemand().subtract(amtCollected));
                continue;
            }
            dd.setAmtCollected(amtCollected.subtract(totalCollChqBounced));
            demand.setBaseDemand(demand.getBaseDemand().subtract(totalCollChqBounced));
            totalCollChqBounced = BigDecimal.ZERO;
        }
        return totalCollChqBounced;
    }

    private EgDemandDetails getDemandDetail(EgDemand demand, String demandrsnStrChqBouncePenalty) {
        EgDemandDetails chqBounceDemand = null;
        for (EgDemandDetails dd : demand.getEgDemandDetails()) {
            if (!dd.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().equalsIgnoreCase(demandrsnStrChqBouncePenalty)) continue;
            chqBounceDemand = dd;
            break;
        }
        return chqBounceDemand;
    }

    @Transactional
    public boolean updateNewReceipt(Set<BillReceiptInfo> billReceipts) {
        try {
            for (BillReceiptInfo bri : billReceipts) {
                this.linkBillToReceipt(bri);
                this.updateBillDetails(bri);
                this.updateDemandDetails(bri);
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while updating receipt for license", (Throwable)e);
        }
        return true;
    }

    private EgBill updateBill(BillReceiptInfo bri, EgBill egBill, BigDecimal totalCollectedAmt) throws InvalidAccountHeadException {
        if (bri != null) {
            for (EgBillDetails billDet : egBill.getEgBillDetails()) {
                Boolean glCodeExist = false;
                for (ReceiptAccountInfo acctDet : bri.getAccountDetails()) {
                    if (!billDet.getGlcode().equals(acctDet.getGlCode())) continue;
                    glCodeExist = true;
                    BigDecimal amtCollected = billDet.getCollectedAmount();
                    if (amtCollected == null) {
                        amtCollected = BigDecimal.ZERO;
                    }
                    billDet.setCollectedAmount(acctDet.getCrAmount().subtract(amtCollected));
                    this.egBillDetailsDao.update(billDet);
                }
                if (glCodeExist.booleanValue()) continue;
                throw new InvalidAccountHeadException("GlCode does not exist for " + billDet.getGlcode());
            }
            egBill.setTotalCollectedAmount(totalCollectedAmt);
            this.egBillDao.update(egBill);
        }
        return egBill;
    }

    public BigDecimal getEgBillDetailCollection(EgBillDetails billdet) {
        BigDecimal collectedAmt = billdet.getCollectedAmount();
        if (billdet.getCollectedAmount() == null) {
            collectedAmt = BigDecimal.ZERO;
        }
        return collectedAmt;
    }

    public EgBill updateBillForChqBounce(BillReceiptInfo bri, EgBill egBill, BigDecimal totalChqAmt) {
        BigDecimal zeroVal = BigDecimal.ZERO;
        if (totalChqAmt != null && totalChqAmt.compareTo(zeroVal) != 0 && egBill != null) {
            ArrayList billList = new ArrayList(egBill.getEgBillDetails());
            Collections.reverse(billList);
            BigDecimal carry = totalChqAmt;
            for (EgBillDetails billdet : billList) {
                BigDecimal remAmount = BigDecimal.ZERO;
                BigDecimal balanceAmt = this.getEgBillDetailCollection(billdet);
                if (balanceAmt == null || balanceAmt.compareTo(zeroVal) <= 0) continue;
                if (carry.compareTo(zeroVal) > 0 && carry.subtract(balanceAmt).compareTo(zeroVal) > 0) {
                    carry = carry.subtract(balanceAmt);
                    remAmount = balanceAmt;
                } else if (carry.compareTo(zeroVal) > 0 && carry.subtract(balanceAmt).compareTo(zeroVal) <= 0) {
                    remAmount = carry;
                    carry = BigDecimal.ZERO;
                }
                if (remAmount.compareTo(zeroVal) <= 0) continue;
                billdet.setCollectedAmount(remAmount);
                this.egBillDetailsDao.update(billdet);
            }
            egBill.setTotalCollectedAmount(totalChqAmt);
            this.egBillDao.update(egBill);
        }
        return egBill;
    }

    public EgBill updateBillDetails(BillReceiptInfo bri) throws InvalidAccountHeadException {
        if (bri == null) {
            throw new ApplicationRuntimeException(" Bill Receipt Info not found");
        }
        EgBill egBill = this.egBillDao.findById(new Long(bri.getBillReferenceNum()), false);
        List billDetList = this.egBillDetailsDao.getBillDetailsByBill(egBill);
        if (bri.getEvent() != null && bri.getEvent().equals("RECEIPT_CREATED")) {
            BigDecimal totalCollectedAmt = this.calculateTotalCollectedAmt(bri, billDetList);
            egBill = this.updateBill(bri, egBill, totalCollectedAmt);
        } else if (bri.getEvent() != null && bri.getEvent().equals("INSTRUMENT_BOUNCED")) {
            egBill = this.updateBillForChqBounce(bri, egBill, this.getTotalChequeAmt(bri));
        }
        return egBill;
    }

    public BigDecimal getTotalChequeAmt(BillReceiptInfo bri) {
        BigDecimal totalCollAmt = BigDecimal.ZERO;
        try {
            if (bri != null) {
                for (ReceiptInstrumentInfo rctInst : bri.getBouncedInstruments()) {
                    if (rctInst.getInstrumentAmount() == null) continue;
                    totalCollAmt = totalCollAmt.add(rctInst.getInstrumentAmount());
                }
            }
        }
        catch (ApplicationRuntimeException e) {
            throw new ApplicationRuntimeException("Exception in calculate Total Collected Amt" + (Object)((Object)e));
        }
        return totalCollAmt;
    }

    public BigDecimal calculateTotalCollectedAmt(BillReceiptInfo bri, List<EgBillDetails> billDetList) throws InvalidAccountHeadException {
        BigDecimal totalCollAmt = BigDecimal.ZERO;
        try {
            if (bri != null && billDetList != null) {
                for (EgBillDetails billDet : billDetList) {
                    Boolean glCodeExist = false;
                    for (ReceiptAccountInfo acctDet : bri.getAccountDetails()) {
                        if (!billDet.getGlcode().equals(acctDet.getGlCode())) continue;
                        glCodeExist = true;
                        totalCollAmt = totalCollAmt.add(acctDet.getCrAmount());
                    }
                    if (glCodeExist.booleanValue()) continue;
                    throw new InvalidAccountHeadException("GlCode does not exist for " + billDet.getGlcode());
                }
            }
        }
        catch (ApplicationRuntimeException e) {
            throw new ApplicationRuntimeException("Exception in calculate Total Collected Amt" + (Object)((Object)e));
        }
        return totalCollAmt;
    }

    private BillReceipt prepareBillReceiptBean(BillReceiptInfo bri, EgBill egBill, BigDecimal totalCollectedAmt) {
        BillReceipt billRecpt = null;
        if (bri != null && egBill != null && totalCollectedAmt != null) {
            billRecpt = new BillReceipt();
            billRecpt.setBillId(egBill);
            billRecpt.setReceiptAmt(totalCollectedAmt);
            billRecpt.setReceiptNumber(bri.getReceiptNum());
            billRecpt.setReceiptDate(bri.getReceiptDate());
            billRecpt.setCollectionStatus(bri.getReceiptStatus().getCode());
            billRecpt.setCreatedBy(bri.getCreatedBy());
            billRecpt.setModifiedBy(bri.getModifiedBy());
            billRecpt.setCreatedDate(new Date());
            billRecpt.setModifiedDate(new Date());
            billRecpt.setIsCancelled(Boolean.FALSE);
        }
        return billRecpt;
    }

    private BillReceipt linkBillToReceipt(BillReceiptInfo bri) throws InvalidAccountHeadException {
        BillReceipt billRecpt = null;
        if (bri == null) {
            throw new ApplicationRuntimeException(" BillReceiptInfo Object is null ");
        }
        EgBill egBill = this.egBillDao.findById(new Long(bri.getBillReferenceNum()), false);
        if (egBill == null) {
            throw new ApplicationRuntimeException(" EgBill Object is null for the Bill Number" + bri.getBillReferenceNum());
        }
        List billDetList = this.egBillDetailsDao.getBillDetailsByBill(egBill);
        BigDecimal totalCollectedAmt = this.calculateTotalCollectedAmt(bri, billDetList);
        if (bri.getEvent() == null) {
            throw new ApplicationRuntimeException(" Event in BillReceiptInfo Object is Null");
        }
        if (bri.getEvent().equals("RECEIPT_CREATED")) {
            billRecpt = this.prepareBillReceiptBean(bri, egBill, totalCollectedAmt);
            this.egBillReceiptDao.create(billRecpt);
        } else if (bri.getEvent().equals("RECEIPT_CANCELLED")) {
            billRecpt = this.updateBillReceiptForCancellation(bri, egBill, totalCollectedAmt);
        }
        return billRecpt;
    }

    private BillReceipt updateBillReceiptForCancellation(BillReceiptInfo bri, EgBill egBill, BigDecimal totalCollectedAmt) {
        BillReceipt billRecpt;
        if (bri == null) {
            throw new ApplicationRuntimeException(" BillReceiptInfo Object is null ");
        }
        if (egBill != null && totalCollectedAmt != null) {
            billRecpt = this.egBillReceiptDao.getBillReceiptByEgBill(egBill);
            if (billRecpt == null) {
                throw new ApplicationRuntimeException(" Bill receipt Object is null for the EgBill " + egBill.getId());
            }
            if (bri.getEvent().equals("RECEIPT_CANCELLED")) {
                billRecpt.setIsCancelled(Boolean.TRUE);
            }
        } else {
            throw new ApplicationRuntimeException(" EgBill Object is null for the Bill Number" + bri.getBillReferenceNum() + "in updateBillReceiptForCancellation method");
        }
        billRecpt.setReceiptAmt(totalCollectedAmt.subtract(billRecpt.getReceiptAmt()));
        return billRecpt;
    }

    protected EgdmCollectedReceipt persistCollectedReceipts(EgDemandDetails egDemandDetails, String receiptNumber, BigDecimal receiptAmount, Date receiptDate, BigDecimal reasonAmount) {
        EgdmCollectedReceipt egDmCollectedReceipt = new EgdmCollectedReceipt();
        egDmCollectedReceipt.setReceiptNumber(receiptNumber);
        egDmCollectedReceipt.setReceiptDate(receiptDate);
        egDmCollectedReceipt.setAmount(receiptAmount);
        egDmCollectedReceipt.setReasonAmount(reasonAmount);
        egDmCollectedReceipt.setStatus(DemandConstants.NEWRECEIPT);
        egDmCollectedReceipt.setEgdemandDetail(egDemandDetails);
        this.egdmCollectedReceiptDao.create(egDmCollectedReceipt);
        return egDmCollectedReceipt;
    }

    public void apportionPaidAmount(String billReferenceNumber, BigDecimal actualAmountPaid, ArrayList<ReceiptDetail> receiptDetailsArray) {
    }

    EgDemandDetails insertPenalty(BigDecimal chqBouncePenalty, Module module) {
        EgDemandDetails demandDetail = null;
        if (chqBouncePenalty != null && chqBouncePenalty.compareTo(BigDecimal.ZERO) > 0) {
            Installment currInstallment = this.getCurrentInstallment(module);
            EgDemandReasonMaster egDemandReasonMaster = this.demandGenericDao.getDemandReasonMasterByCode("CHQ_BUNC_PENALTY", module);
            if (egDemandReasonMaster == null) {
                throw new ApplicationRuntimeException(" Penalty Demand reason Master is null in method  insertPenalty");
            }
            EgDemandReason egDemandReason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(egDemandReasonMaster, currInstallment, module);
            if (egDemandReason == null) {
                throw new ApplicationRuntimeException(" Penalty Demand reason is null in method  insertPenalty ");
            }
            demandDetail = EgDemandDetails.fromReasonAndAmounts((BigDecimal)chqBouncePenalty, (EgDemandReason)egDemandReason, (BigDecimal)BigDecimal.ZERO);
        }
        return demandDetail;
    }

    protected Installment getInstallmentForDate(Date date, Module module) {
        return this.installmentDao.getInsatllmentByModuleForGivenDate(module, date);
    }

    protected Installment getCurrentInstallment(Module module) {
        return this.getInstallmentForDate(new Date(), module);
    }

    public void cancelBill() {
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        return Collections.emptyList();
    }

    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        return null;
    }

    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        return new ReceiptAmountInfo();
    }
}

