/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.tl.entity.FeeMatrix;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.repository.FeeMatrixDetailRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FeeMatrixDetailService {
    private final FeeMatrixDetailRepository feeMatrixDetailRepository;

    @Autowired
    public FeeMatrixDetailService(FeeMatrixDetailRepository feeMatrixDetailRepository) {
        this.feeMatrixDetailRepository = feeMatrixDetailRepository;
    }

    public List<FeeMatrixDetail> findAll() {
        return this.feeMatrixDetailRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public FeeMatrixDetail findByLicenseFeeByRange(FeeMatrix feeMatrix, BigDecimal uom, Date date, long financialYearId) {
        return this.feeMatrixDetailRepository.findFeeDetailList(feeMatrix, uom.intValue(), date, financialYearId);
    }

    public FeeMatrixDetail findByFeeMatrixDetailId(Long feeMatrixDetailId) {
        FeeMatrixDetail feeMatrixDetail = (FeeMatrixDetail)((Object)this.feeMatrixDetailRepository.findOne(feeMatrixDetailId));
        return feeMatrixDetail;
    }

    @Transactional
    public void delete(FeeMatrixDetail feeMatrixDetail) {
        this.feeMatrixDetailRepository.delete((Object)feeMatrixDetail);
    }

    public List<FeeMatrixDetail> searchFeeMatrix(Long licenseCategory, Long subCategory, Long financialYear) {
        return this.feeMatrixDetailRepository.findByParams(licenseCategory, subCategory, financialYear);
    }
}

