/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.commons.repository.CFinancialYearRepository;
import org.egov.demand.dao.DemandGenericHibDao;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.tl.entity.DemandGenerationLog;
import org.egov.tl.entity.DemandGenerationLogDetail;
import org.egov.tl.entity.FeeMatrixDetail;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.enums.ProcessStatus;
import org.egov.tl.service.DemandGenerationLogService;
import org.egov.tl.service.FeeMatrixService;
import org.egov.tl.service.TradeLicenseService;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DemandGenerationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DemandGenerationService.class);
    @Autowired
    private CFinancialYearRepository cFinancialYearRepository;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    @Qualifier(value="tradeLicenseService")
    private TradeLicenseService tradeLicenseService;
    @Autowired
    private DemandGenericHibDao demandGenericDao;
    @Autowired
    private FeeMatrixService feeMatrixService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    public DemandGenerationLogService demandGenerationLogService;
    @PersistenceContext
    public EntityManager entityManager;

    public List<CFinancialYear> financialYearList() {
        return this.cFinancialYearRepository.getAllFinancialYears();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, timeout=7200)
    public DemandGenerationLog bulkDemandGeneration(DemandGenerationLog demandGenerationLog) {
        DemandGenerationLog existingDemandGenLog = this.demandGenerationLogService.findByInstallmentYear(demandGenerationLog.getInstallmentYear());
        if (existingDemandGenLog != null) {
            return existingDemandGenLog;
        }
        CFinancialYear financialYear = this.cFinancialYearRepository.findByFinYearRange(demandGenerationLog.getInstallmentYear());
        Module module = this.moduleService.getModuleByName("Trade License");
        Installment currentInstallment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, financialYear.getStartingDate());
        List licenses = this.tradeLicenseService.getAllLicensesByNatureOfBusiness("Permanent");
        ProcessStatus demandGenerationStatus = ProcessStatus.COMPLETED;
        demandGenerationLog = this.demandGenerationLogService.createDemandGenerationLog(demandGenerationLog);
        int batchUpdateCount = 0;
        int batchSize = this.applicationProperties.getBatchUpdateSize();
        for (TradeLicense license : licenses) {
            DemandGenerationLogDetail demandGenerationLogDetail = this.demandGenerationLogService.createDemandGenerationLogDetail(demandGenerationLog, license);
            try {
                if (!license.getCurrentDemand().getEgInstallmentMaster().equals((Object)currentInstallment)) {
                    if (!license.getIsActive()) {
                        this.demandGenerationLogService.updateDemandGenerationLogDetail(demandGenerationLogDetail, ProcessStatus.INCOMPLETE, "License Not Active");
                        continue;
                    }
                    this.calculateAndPersistFeeForDemand(module, currentInstallment, license);
                    this.batchUpdateFlush(++batchUpdateCount, batchSize);
                    this.demandGenerationLogService.updateDemandGenerationLogDetail(demandGenerationLogDetail, ProcessStatus.COMPLETED, "Successful");
                    continue;
                }
                this.demandGenerationLogService.updateDemandGenerationLogDetail(demandGenerationLogDetail, ProcessStatus.COMPLETED, "Demand exist");
            }
            catch (RuntimeException e) {
                demandGenerationStatus = ProcessStatus.INCOMPLETE;
                this.updateDemandGenerationLogDetailOnException(demandGenerationLogDetail, e);
            }
        }
        return this.demandGenerationLogService.updateDemandGenerationLog(demandGenerationLog, ProcessStatus.COMPLETED, demandGenerationStatus);
    }

    private void updateDemandGenerationLogDetailOnException(DemandGenerationLogDetail demandGenerationLogDetail, RuntimeException e) {
        LOGGER.error("Error occurred while generating demand", (Throwable)e);
        String error = e instanceof ValidationException ? ((ValidationError)((ValidationException)e).getErrors().get(0)).getMessage() : "Error : " + e;
        this.demandGenerationLogService.updateDemandGenerationLogDetail(demandGenerationLogDetail, ProcessStatus.INCOMPLETE, error);
    }

    private void batchUpdateFlush(int batchUpdateCount, int batchSize) {
        if (batchUpdateCount % batchSize == 0) {
            ((Session)this.entityManager.unwrap(Session.class)).flush();
            ((Session)this.entityManager.unwrap(Session.class)).flush();
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, timeout=7200)
    public DemandGenerationLog demandRegeneration(DemandGenerationLog demandGenerationLog) {
        CFinancialYear financialYear = this.cFinancialYearRepository.findByFinYearRange(demandGenerationLog.getInstallmentYear());
        Module module = this.moduleService.getModuleByName("Trade License");
        Installment currentInstallment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, financialYear.getStartingDate());
        ProcessStatus demandGenerationStatus = ProcessStatus.COMPLETED;
        DemandGenerationLog existingDemandGenLog = this.demandGenerationLogService.findByInstallmentYear(demandGenerationLog.getInstallmentYear());
        if (existingDemandGenLog != null) {
            this.demandGenerationLogService.createDemandGenerationLog(existingDemandGenLog);
        }
        int batchUpdateCount = 0;
        int batchSize = this.applicationProperties.getBatchUpdateSize();
        for (DemandGenerationLogDetail demandGenerationLogDetail : existingDemandGenLog.getDetails()) {
            TradeLicense license = (TradeLicense)demandGenerationLogDetail.getLicense();
            try {
                if (!license.getCurrentDemand().getEgInstallmentMaster().equals((Object)currentInstallment)) {
                    if (!demandGenerationLogDetail.getLicense().getIsActive()) {
                        this.demandGenerationLogService.updateDemandGenerationLogDetail(demandGenerationLogDetail, ProcessStatus.INCOMPLETE, "License Not Active");
                        continue;
                    }
                    this.calculateAndPersistFeeForDemand(module, currentInstallment, license);
                    this.batchUpdateFlush(++batchUpdateCount, batchSize);
                    this.demandGenerationLogService.updateDemandGenerationLogDetail(demandGenerationLogDetail, ProcessStatus.COMPLETED, "Successful");
                    continue;
                }
                this.demandGenerationLogService.updateDemandGenerationLogDetail(demandGenerationLogDetail, ProcessStatus.COMPLETED, "Demand exist");
            }
            catch (RuntimeException e) {
                demandGenerationStatus = ProcessStatus.INCOMPLETE;
                this.updateDemandGenerationLogDetailOnException(demandGenerationLogDetail, e);
            }
        }
        return this.demandGenerationLogService.updateDemandGenerationLog(existingDemandGenLog, ProcessStatus.COMPLETED, demandGenerationStatus);
    }

    private void calculateAndPersistFeeForDemand(Module module, Installment currentInstallment, TradeLicense license) {
        List<FeeMatrixDetail> feeList = this.feeMatrixService.findFeeList(license);
        for (FeeMatrixDetail fm : feeList) {
            if (fm.getFeeMatrix().getFeeType().getName().contains("Late")) continue;
            EgDemandReasonMaster reasonMaster = this.demandGenericDao.getDemandReasonMasterByCode(fm.getFeeMatrix().getFeeType().getName(), module);
            EgDemandReason reason = this.demandGenericDao.getDmdReasonByDmdReasonMsterInstallAndMod(reasonMaster, currentInstallment, module);
            EgDemandDetails licenseDemandDetail = this.getReasonWiseDemandDetails(license.getCurrentDemand()).get(reason);
            if (licenseDemandDetail == null) {
                license.getLicenseDemand().getEgDemandDetails().add(EgDemandDetails.fromReasonAndAmounts((BigDecimal)fm.getAmount(), (EgDemandReason)reason, (BigDecimal)BigDecimal.ZERO));
            } else {
                licenseDemandDetail.setAmount(fm.getAmount());
            }
            license.getLicenseDemand().setEgInstallmentMaster(currentInstallment);
        }
        this.tradeLicenseService.recalculateBaseDemand(license.getLicenseDemand());
        this.tradeLicenseService.save(license);
    }

    public Map<EgDemandReason, EgDemandDetails> getReasonWiseDemandDetails(EgDemand currentDemand) {
        HashMap<EgDemandReason, EgDemandDetails> reasonWiseDemandDetails = new HashMap<EgDemandReason, EgDemandDetails>();
        if (currentDemand != null) {
            for (EgDemandDetails dmdDet : currentDemand.getEgDemandDetails()) {
                if (!dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode().equals("License Fee")) continue;
                reasonWiseDemandDetails.put(dmdDet.getEgDemandReason(), dmdDet);
            }
        }
        return reasonWiseDemandDetails;
    }
}

