/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.tl.entity.License;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGTL_LICENSEE")
@SequenceGenerator(name="SEQ_EGTL_LICENSEE", sequenceName="SEQ_EGTL_LICENSEE", allocationSize=1)
public class Licensee
extends AbstractAuditable {
    private static final long serialVersionUID = 6723590685484215531L;
    public static final String SEQUENCE = "SEQ_EGTL_LICENSEE";
    @Id
    @GeneratedValue(generator="SEQ_EGTL_LICENSEE", strategy=GenerationType.SEQUENCE)
    @DocumentId
    private Long id;
    @NotBlank(message="licensee.name.err.required")
    @Length(min=1, max=256, message="licensee.name.err.maxlength")
    @SafeHtml
    @Column(name="APPLICANT_NAME")
    private String applicantName;
    @SafeHtml
    @Length(max=256)
    @Column(name="FATHER_SPOUSE_NAME")
    private String fatherOrSpouseName;
    @SafeHtml
    @Length(max=16)
    @Column(name="MOBILE_PHONENUMBER")
    private String mobilePhoneNumber;
    @SafeHtml
    @Length(max=16)
    @Column(name="UNIQUEID")
    private String uid;
    @SafeHtml
    @Length(max=64)
    @Column(name="EMAIL_ID")
    private String emailId;
    @NotBlank
    @Length(min=1, max=250)
    @SafeHtml
    @Column(name="ADDRESS")
    private String address;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LICENSE")
    private License license;

    protected void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public String getMobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    public void setMobilePhoneNumber(String mobilePhoneNumber) {
        this.mobilePhoneNumber = mobilePhoneNumber;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getFatherOrSpouseName() {
        return this.fatherOrSpouseName;
    }

    public void setFatherOrSpouseName(String fatherOrSpouseName) {
        this.fatherOrSpouseName = fatherOrSpouseName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

