/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tl.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.tl.entity.LicenseAppType;
import org.egov.tl.entity.LicenseCategory;
import org.egov.tl.entity.LicenseDemand;
import org.egov.tl.entity.LicenseDocument;
import org.egov.tl.entity.LicenseStatus;
import org.egov.tl.entity.LicenseSubCategory;
import org.egov.tl.entity.Licensee;
import org.egov.tl.entity.NatureOfBusiness;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

public abstract class License
extends StateAware {
    private static final long serialVersionUID = 1L;
    protected Long id;
    @Required(message="license.applicationdate.err.required")
    protected Date applicationDate;
    protected String applicationNumber;
    protected EgwStatus egwStatus;
    protected Boundary boundary;
    protected Boundary parentBoundary;
    protected NatureOfBusiness natureOfBusiness;
    protected Date dateOfExpiry;
    protected boolean isActive;
    protected LicenseDemand licenseDemand;
    protected Licensee licensee;
    protected String licenseNumber;
    protected String nameOfEstablishment;
    protected String oldLicenseNumber;
    protected String remarks;
    protected LicenseStatus status;
    protected String tempLicenseNumber;
    @NotNull
    protected LicenseSubCategory tradeName;
    protected LicenseAppType licenseAppType;
    protected String ownershipType;
    protected String address;
    @NotNull
    private LicenseCategory category;
    private BigDecimal tradeArea_weight;
    private boolean legacy;
    private Date commencementDate;
    private Date agreementDate;
    private String agreementDocNo;
    private String digiSignedCertFileStoreId;
    private String assessmentNo;

    public abstract String generateLicenseNumber(Serializable var1);

    public abstract List<LicenseDocument> getDocuments();

    public abstract void setDocuments(List<LicenseDocument> var1);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LicenseDemand getLicenseDemand() {
        return this.licenseDemand;
    }

    public void setLicenseDemand(LicenseDemand licenseDemand) {
        this.licenseDemand = licenseDemand;
    }

    @Audited
    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    @Audited
    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Boundary boundary) {
        this.boundary = boundary;
    }

    public Date getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public void setDateOfExpiry(Date dateOfExpiry) {
        this.dateOfExpiry = dateOfExpiry;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Licensee getLicensee() {
        return this.licensee;
    }

    public void setLicensee(Licensee licensee) {
        this.licensee = licensee;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    @Audited
    public String getNameOfEstablishment() {
        return this.nameOfEstablishment;
    }

    public void setNameOfEstablishment(String nameOfEstablishment) {
        this.nameOfEstablishment = nameOfEstablishment;
    }

    public String getOldLicenseNumber() {
        return this.oldLicenseNumber;
    }

    public void setOldLicenseNumber(String oldLicenseNumber) {
        this.oldLicenseNumber = oldLicenseNumber;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public LicenseStatus getStatus() {
        return this.status;
    }

    public void setStatus(LicenseStatus status) {
        this.status = status;
    }

    public String getTempLicenseNumber() {
        return this.tempLicenseNumber;
    }

    public void setTempLicenseNumber(String tempLicenseNumber) {
        this.tempLicenseNumber = tempLicenseNumber;
    }

    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    public LicenseSubCategory getTradeName() {
        return this.tradeName;
    }

    public void setTradeName(LicenseSubCategory tradeName) {
        this.tradeName = tradeName;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Audited
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    public LicenseCategory getCategory() {
        return this.category;
    }

    public void setCategory(LicenseCategory category) {
        this.category = category;
    }

    @Audited
    public String getOwnershipType() {
        return this.ownershipType;
    }

    public void setOwnershipType(String ownershipType) {
        this.ownershipType = ownershipType;
    }

    @Audited
    public BigDecimal getTradeArea_weight() {
        return this.tradeArea_weight;
    }

    public void setTradeArea_weight(BigDecimal tradeArea_weight) {
        this.tradeArea_weight = tradeArea_weight;
    }

    public NatureOfBusiness getNatureOfBusiness() {
        return this.natureOfBusiness;
    }

    public void setNatureOfBusiness(NatureOfBusiness natureOfBusiness) {
        this.natureOfBusiness = natureOfBusiness;
    }

    public LicenseAppType getLicenseAppType() {
        return this.licenseAppType;
    }

    public void setLicenseAppType(LicenseAppType licenseAppType) {
        this.licenseAppType = licenseAppType;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    @Audited
    public Date getCommencementDate() {
        return this.commencementDate;
    }

    public void setCommencementDate(Date commencementDate) {
        this.commencementDate = commencementDate;
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public Boundary getParentBoundary() {
        return this.parentBoundary;
    }

    public void setParentBoundary(Boundary parentBoundary) {
        this.parentBoundary = parentBoundary;
    }

    @Audited
    public Date getAgreementDate() {
        return this.agreementDate;
    }

    public void setAgreementDate(Date agreementDate) {
        this.agreementDate = agreementDate;
    }

    @Audited
    public String getAgreementDocNo() {
        return this.agreementDocNo;
    }

    public void setAgreementDocNo(String agreementDocNo) {
        this.agreementDocNo = agreementDocNo;
    }

    public String getDigiSignedCertFileStoreId() {
        return this.digiSignedCertFileStoreId;
    }

    public void setDigiSignedCertFileStoreId(String digiSignedCertFileStoreId) {
        this.digiSignedCertFileStoreId = digiSignedCertFileStoreId;
    }

    public LicenseDemand getCurrentDemand() {
        return this.getLicenseDemand();
    }

    public BigDecimal getCurrentLicenseFee() {
        return this.getCurrentDemand().getEgDemandDetails().stream().filter(dd -> dd.getEgDemandReason().getEgInstallmentMaster().equals((Object)this.getCurrentDemand().getEgInstallmentMaster())).findAny().get().getAmount();
    }

    public boolean isPaid() {
        return this.getTotalBalance().compareTo(BigDecimal.ZERO) == 0;
    }

    public BigDecimal getTotalBalance() {
        return this.licenseDemand.getBaseDemand().subtract(this.licenseDemand.getAmtCollected());
    }

    public boolean isStateRejected() {
        return this.getState() != null && this.getState().getValue().contains("Rejected");
    }

    public String getAssessmentNo() {
        return this.assessmentNo;
    }

    public void setAssessmentNo(String assessmentNo) {
        this.assessmentNo = assessmentNo;
    }
}

