/*
 * eGov suite of products aim to improve the internal efficiency,transparency,
 *    accountability and the service delivery of the government  organizations.
 *
 *     Copyright (C) <2015>  eGovernments Foundation
 *
 *     The updated version of eGov suite of products as by eGovernments Foundation
 *     is available at http://www.egovernments.org
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program. If not, see http://www.gnu.org/licenses/ or
 *     http://www.gnu.org/licenses/gpl.html .
 *
 *     In addition to the terms of the GPL license to be adhered to in using this
 *     program, the following additional terms are to be complied with:
 *
 *         1) All versions of this program, verbatim or modified must carry this
 *            Legal Notice.
 *
 *         2) Any misrepresentation of the origin of the material is prohibited. It
 *            is required that all modified versions of this material be marked in
 *            reasonable ways as different from the original version.
 *
 *         3) This license does not grant any rights to any user of the program
 *            with regards to rights under trademark law for use of the trade names
 *            or trademarks of eGovernments Foundation.
 *
 *   In case of any queries, you can reach eGovernments Foundation at contact@egovernments.org.
 */

package org.egov.tl.entity;

import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@SequenceGenerator(name = FeeType.SEQ, sequenceName = FeeType.SEQ, allocationSize = 1)
@Table(name = "egtl_mstr_fee_type")
public class FeeType extends AbstractAuditable {
    
    private static final long serialVersionUID = -766315755023031686L;

    public static final String SEQ = "seq_egtl_mstr_fee_type";

    public enum FeeProcessType {
        RANGE
    }

    @Id
    @GeneratedValue(generator = SEQ, strategy = GenerationType.SEQUENCE)
    private Long id;
    
    @NotNull
    @Length(max = 32)
    private String name;
    
    @Length(max = 12)
    private String code;

    private FeeProcessType feeProcessType;

    @Override
    public void setId(final Long id) {

        this.id = id;
    }

    @Override
    public Long getId() {
        return id;

    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }
    
    public String getCode() {
        return code;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    public FeeProcessType getFeeProcessType() {
        return feeProcessType;
    }

    public void setFeeProcessType(final FeeProcessType feeProcessType) {
        this.feeProcessType = feeProcessType;
    }
    
    @Override
    public String toString() {
        final StringBuilder str = new StringBuilder();
        str.append("FeeType={");
        str.append("name=").append(name == null ? "null" : name.toString());
        str.append("}");
        return str.toString();
    }

}
