/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageWorkOrderNoticeController {
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;

    @RequestMapping(value={"/workordernotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> createWorkOrderReport(HttpServletRequest request) throws IOException {
        String errorMessage = "";
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(request.getParameter("pathVar"));
        if (!errorMessage.isEmpty()) {
            return this.redirect();
        }
        return this.generateReport(sewerageApplicationDetails);
    }

    private ResponseEntity<byte[]> generateReport(SewerageApplicationDetails sewerageApplicationDetails) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        ReportOutput reportOutput = new ReportOutput();
        SewerageNotice sewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(sewerageApplicationDetails.getWorkOrderNumber(), "Workorder Notice");
        if (sewerageNotice != null && sewerageNotice.getFileStore() != null) {
            FileStoreMapper fmp = sewerageNotice.getFileStore();
            File file = this.fileStoreService.fetch(fmp, "STMS");
            reportOutput.setReportOutputData(FileUtils.readFileToByteArray((File)file));
            reportOutput.setReportFormat(ReportFormat.PDF);
        } else {
            ByteArrayInputStream generateNoticePDF;
            reportOutput = this.sewerageNoticeService.generateReportOutputForWorkOrder(sewerageApplicationDetails);
            if (reportOutput != null && reportOutput.getReportOutputData() != null && (sewerageNotice = this.sewerageNoticeService.saveWorkOrderNotice(sewerageApplicationDetails, (InputStream)(generateNoticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData())))) != null) {
                sewerageApplicationDetails.addNotice(sewerageNotice);
                this.sewerageApplicationDetailsService.save(sewerageApplicationDetails);
            }
        }
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=WorkOrderNotice.pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private String validateWorkOrder(SewerageApplicationDetails sewerageApplicationDetails, Boolean isView) {
        String errorMessage = null;
        if (sewerageApplicationDetails != null) {
            if (sewerageApplicationDetails.getConnection().getLegacy()) {
                errorMessage = this.messageSource.getMessage("err.validate.workorder.for.legacy", (Object[])new String[]{""}, null);
            } else {
                if (isView.booleanValue() && null == sewerageApplicationDetails.getWorkOrderNumber()) {
                    return this.buildErrorMessage(sewerageApplicationDetails);
                }
                if (!isView.booleanValue() && !sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("WORKORDERGENERATED")) {
                    return this.buildErrorMessage(sewerageApplicationDetails);
                }
            }
        }
        return errorMessage;
    }

    private String buildErrorMessage(SewerageApplicationDetails sewerageApplicationDetails) {
        String errorMessage = this.messageSource.getMessage("err.validate.workorder.view", (Object[])new String[]{sewerageApplicationDetails.getApplicationNumber()}, null);
        return errorMessage;
    }

    @RequestMapping(value={"/workorder/view/{applicationNumber}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewReport(@PathVariable String applicationNumber) throws IOException {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        String errorMessage = this.validateWorkOrder(sewerageApplicationDetails, Boolean.valueOf(true));
        if (errorMessage != null && !errorMessage.isEmpty()) {
            return this.redirect();
        }
        return this.generateReport(sewerageApplicationDetails);
    }

    private ResponseEntity<byte[]> redirect() {
        String errorMessage = "";
        errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + errorMessage + "</p></body></html>";
        byte[] byteData = errorMessage.getBytes();
        errorMessage = "";
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }
}

