/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.pims.commons.Position;
import org.egov.stms.entity.SewerageReassignDetails;
import org.egov.stms.transactions.service.SewerageReassignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/reassignseweragetax/{applicationNum}/{appType}"})
public class SewerageReassignController {
    private static final String REASSIGN_SUCCESS = "reassign-success";
    private static final String SEWERAGE_REASSIGN = "sewerage-reassign";
    private static final String SUCCESSMESSAGE = "successMessage";
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SewerageReassignService sewerageReassignService;
    @Autowired
    private PositionMasterService positionMasterService;

    @ModelAttribute
    public SewerageReassignDetails reassign() {
        return new SewerageReassignDetails();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getReassign(@ModelAttribute(value="reassign") SewerageReassignDetails reassignDetails, Model model, @PathVariable String appType, @PathVariable String applicationNum, HttpServletRequest request) {
        Map employeeWithPosition = this.sewerageReassignService.getemployees();
        if (!employeeWithPosition.isEmpty()) {
            model.addAttribute("assignments", (Object)employeeWithPosition);
        } else {
            model.addAttribute("message", (Object)"notexists.position");
        }
        reassignDetails.setApplicationNo(applicationNum);
        reassignDetails.setStateType(appType);
        return SEWERAGE_REASSIGN;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@ModelAttribute(value="reassign") SewerageReassignDetails reassignDetails, Model model, @Valid BindingResult errors, HttpServletRequest request) {
        Long positionId = Long.valueOf(request.getParameter("approvalPosition"));
        Position position = this.positionMasterService.getPositionById(positionId);
        Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(positionId).get(0);
        String applicationNo = this.sewerageReassignService.getSewerageApplication(reassignDetails, position);
        if (StringUtils.isNotEmpty((CharSequence)applicationNo) && assignment != null) {
            String successMessage = "Sewearge Tax  application with reference number : " + applicationNo + " successfully re-assigned to " + assignment.getEmployee().getName() + "~" + assignment.getDesignation().getName() + ":" + assignment.getDepartment().getCode();
            model.addAttribute(SUCCESSMESSAGE, (Object)successMessage);
        } else {
            model.addAttribute(SUCCESSMESSAGE, (Object)"Reassign Failed!");
        }
        return REASSIGN_SUCCESS;
    }
}

