/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.stms.elasticsearch.entity.SewerageBulkExecutionResponse;
import org.egov.stms.elasticsearch.entity.SewerageExecutionResult;
import org.egov.stms.masters.repository.SewerageApplicationTypeRepository;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.utils.SewerageExecutionResultAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageExecuteConnectionController {
    @Autowired
    protected MessageSource messageSource;
    @Autowired
    private SewerageIndexService sewerageIndexService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageApplicationTypeRepository sewerageApplicationTypeRepository;

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @ModelAttribute
    public SewerageExecutionResult sewerageExecutionResult() {
        return new SewerageExecutionResult();
    }

    @RequestMapping(value={"/connexecutionsearch"}, method={RequestMethod.GET})
    public String showExecutionConnection(Model model) {
        model.addAttribute("applicationtype", (Object)this.sewerageApplicationTypeRepository.findAll());
        return "sewerageExecution-search";
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String executeSewerage(@ModelAttribute SewerageExecutionResult sewerageExecutionResult) {
        List connectionExecutionList = this.sewerageIndexService.getConnectionExecutionList(sewerageExecutionResult);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)connectionExecutionList, SewerageExecutionResult.class, SewerageExecutionResultAdapter.class) + "}";
    }

    @RequestMapping(value={"/connexecutionupdate"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public String updateData(@RequestBody SewerageBulkExecutionResponse sewerageBulkExecutionResponse) {
        ArrayList sewerageApplicationDetailsList = new ArrayList();
        String validationstatus = this.sewerageIndexService.validateDate(sewerageBulkExecutionResponse, sewerageApplicationDetailsList);
        Boolean updateStatus = this.sewerageIndexService.update(sewerageApplicationDetailsList);
        String response = sewerageBulkExecutionResponse.getSewerageExecutionResult().length <= 0 ? "EmptyList" : (!validationstatus.isEmpty() ? validationstatus : (updateStatus == false ? "UpdateExecutionFailed" : "Success"));
        return response;
    }
}

