/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.masters.entity.DocumentTypeMaster;
import org.egov.stms.masters.entity.FeesDetailMaster;
import org.egov.stms.masters.entity.SewerageApplicationType;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.masters.service.DocumentTypeMasterService;
import org.egov.stms.masters.service.FeesDetailMasterService;
import org.egov.stms.masters.service.SewerageApplicationTypeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetailsDocument;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.transactions.service.SewerageWorkflowService;
import org.egov.stms.utils.SewerageTaxUtils;
import org.egov.stms.web.controller.utils.SewerageApplicationValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageConnectionController
extends GenericWorkFlowController {
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String WORK_FLOW_ACTION = "workFlowAction";
    private static final String APPROVAL_COMMENT = "approvalComment";
    private static final String APPROVER_NAME = "approverName";
    private static final String CSCUSER = "CSCUSER";
    private static final String INSPECTIONFEEREQUIRED = "inspectionFeesCollectionRequired";
    private static final Logger LOG = LoggerFactory.getLogger(SewerageConnectionController.class);
    private final SewerageTaxUtils sewerageTaxUtils;
    private final SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageApplicationTypeService sewerageApplicationTypeService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private FeesDetailMasterService feesDetailMasterService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private DocumentTypeMasterService documentTypeMasterService;
    @Autowired
    private SewerageApplicationValidator sewerageApplicationValidator;
    @Autowired
    private SewerageWorkflowService sewerageWorkflowService;
    @Autowired
    private MessageSource messageSource;

    @Autowired
    public SewerageConnectionController(SewerageTaxUtils sewerageTaxUtils, SewerageApplicationDetailsService sewerageApplicationDetailsService) {
        this.sewerageTaxUtils = sewerageTaxUtils;
        this.sewerageApplicationDetailsService = sewerageApplicationDetailsService;
    }

    @ModelAttribute(value="documentNamesList")
    public List<SewerageApplicationDetailsDocument> documentTypeMasterList(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageApplicationDetailsDocument> tempDocList = new ArrayList<SewerageApplicationDetailsDocument>(0);
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("NEWSEWERAGECONNECTION");
        List documentTypeMasterList = this.documentTypeMasterService.getAllActiveDocumentTypeMasterByApplicationType(applicationType);
        if (sewerageApplicationDetails != null) {
            for (DocumentTypeMaster dtm : documentTypeMasterList) {
                SewerageApplicationDetailsDocument sad = new SewerageApplicationDetailsDocument();
                if (dtm == null) continue;
                sad.setDocumentTypeMaster(dtm);
                tempDocList.add(sad);
            }
        }
        return tempDocList;
    }

    @RequestMapping(value={"/newConnection-newform"}, method={RequestMethod.GET})
    public String showNewApplicationForm(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, Model model, HttpServletRequest request) {
        LOG.debug("Inside showNewApplicationForm method");
        SewerageConnection connection = new SewerageConnection();
        sewerageApplicationDetails.setApplicationDate(new Date());
        connection.setStatus(SewerageConnectionStatus.INPROGRESS);
        sewerageApplicationDetails.setConnection(connection);
        this.prepareNewForm(sewerageApplicationDetails, model);
        boolean inspectionFeeCollectionRequired = this.sewerageTaxUtils.isInspectionFeeCollectionRequired();
        model.addAttribute(INSPECTIONFEEREQUIRED, (Object)inspectionFeeCollectionRequired);
        if (inspectionFeeCollectionRequired) {
            this.createSewerageConnectionFee(sewerageApplicationDetails, "INSPECTIONCHARGE");
        }
        model.addAttribute("mode", null);
        return "newconnection-form";
    }

    private void createSewerageConnectionFee(SewerageApplicationDetails sewerageApplicationDetails, String feeCode) {
        List inspectionFeeList = this.feesDetailMasterService.findAllActiveFeesDetailByFeesCode(feeCode);
        for (FeesDetailMaster feeDetailMaster : inspectionFeeList) {
            SewerageConnectionFee connectionFee = new SewerageConnectionFee();
            connectionFee.setFeesDetail(feeDetailMaster);
            if (feeDetailMaster.getIsFixedRate().booleanValue()) {
                connectionFee.setAmount(feeDetailMaster.getAmount().doubleValue());
            }
            connectionFee.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.getConnectionFees().add(connectionFee);
        }
    }

    @RequestMapping(value={"/newConnection-create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction, @RequestParam(value="files") MultipartFile[] files) {
        Assignment assignment;
        this.sewerageApplicationValidator.validateSewerageNewApplication(sewerageApplicationDetails, (Errors)resultBinder, request);
        Boolean isEmployee = this.sewerageWorkflowService.isEmployee(this.securityUtils.getCurrentUser());
        boolean citizenPortalUser = this.sewerageWorkflowService.isCitizenPortalUser(this.securityUtils.getCurrentUser());
        ArrayList applicationDocs = new ArrayList();
        int i = 0;
        if (!sewerageApplicationDetails.getAppDetailsDocument().isEmpty()) {
            for (SewerageApplicationDetailsDocument applicationDocument : sewerageApplicationDetails.getAppDetailsDocument()) {
                this.sewerageConnectionService.validateDocuments(applicationDocs, applicationDocument, i, resultBinder);
                ++i;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.error("Model Level Validation occurs = " + resultBinder);
        }
        if (resultBinder.hasErrors()) {
            sewerageApplicationDetails.setApplicationDate(new Date());
            this.prepareNewForm(sewerageApplicationDetails, model);
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter(APPROVAL_POSITION));
            boolean inspectionFeeCollectionRequired = this.sewerageTaxUtils.isInspectionFeeCollectionRequired();
            model.addAttribute(INSPECTIONFEEREQUIRED, (Object)inspectionFeeCollectionRequired);
            model.addAttribute("mode", null);
            return "newconnection-form";
        }
        if (sewerageApplicationDetails.getState() == null) {
            if (isEmployee.booleanValue()) {
                sewerageApplicationDetails.setSource(Source.SYSTEM.name());
                if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("COLLECTINSPECTIONFEE", "SEWERAGETAXAPPLICATION"));
                } else {
                    sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
                }
            } else if (this.securityUtils.getCurrentUser().getUsername().equalsIgnoreCase(CSCUSER)) {
                sewerageApplicationDetails.setSource(Source.CSC.name());
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CSCCREATED", "SEWERAGETAXAPPLICATION"));
            } else if (citizenPortalUser) {
                sewerageApplicationDetails.setSource(Source.CITIZENPORTAL.toString());
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("FEECOLLECTIONPENDING", "SEWERAGETAXAPPLICATION"));
            } else {
                sewerageApplicationDetails.setSource("Online");
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("ANONYMOUSCREATED", "SEWERAGETAXAPPLICATION"));
            }
        }
        sewerageApplicationDetails.getAppDetailsDocument().clear();
        sewerageApplicationDetails.setAppDetailsDocument(applicationDocs);
        this.sewerageConnectionService.processAndStoreApplicationDocuments(sewerageApplicationDetails);
        Long approvalPosition = 0L;
        String approvalComment = "";
        String approverName = "";
        String nextDesignation = "";
        if (request.getParameter(APPROVER_NAME) != null) {
            approverName = request.getParameter(APPROVER_NAME);
        }
        if (request.getParameter(APPROVAL_COMMENT) != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter(WORK_FLOW_ACTION) != null) {
            workFlowAction = request.getParameter(WORK_FLOW_ACTION);
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        if ((!isEmployee.booleanValue() || citizenPortalUser) && (assignment = this.sewerageWorkflowService.getMappedAssignmentForCscOperator(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier())) != null) {
            approvalPosition = assignment.getPosition().getId();
            approverName = assignment.getEmployee().getName();
            nextDesignation = assignment.getDesignation().getName();
        }
        this.populateFeesDetails(sewerageApplicationDetails);
        SewerageApplicationDetails newSewerageApplicationDetails = this.sewerageApplicationDetailsService.createNewSewerageConnection(sewerageApplicationDetails, approvalPosition, approvalComment, sewerageApplicationDetails.getApplicationType().getCode(), files, workFlowAction, request);
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        String nextDesign = asignList != null && !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = newSewerageApplicationDetails.getApplicationNumber() + "," + this.sewerageTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        String message = this.messageSource.getMessage("msg.success.forward", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), newSewerageApplicationDetails.getApplicationNumber()}, null);
        model.addAttribute("message", (Object)message);
        if (!isEmployee.booleanValue() && !citizenPortalUser) {
            redirectAttributes.addFlashAttribute("message", (Object)message);
            return "redirect:/transactions/new-sewerage-ackowledgement/" + newSewerageApplicationDetails.getApplicationNumber();
        }
        if (citizenPortalUser) {
            return "redirect:/citizen/search/sewerageGenerateonlinebill/" + newSewerageApplicationDetails.getApplicationNumber() + "/" + newSewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier();
        }
        return "redirect:/transactions/application-success?pathVars=" + pathVars;
    }

    private void populateFeesDetails(SewerageApplicationDetails sewerageApplicationDetails) {
        if (sewerageApplicationDetails.getConnectionFees() != null && !sewerageApplicationDetails.getConnectionFees().isEmpty()) {
            for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
                scf.setApplicationDetails(sewerageApplicationDetails);
            }
        }
    }

    @RequestMapping(value={"/application-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request, Model model, ModelMap modelMap) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        String applicationNumber = "";
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                applicationNumber = keyNameArray[0];
            } else if (keyNameArray.length == 3) {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (applicationNumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        }
        model.addAttribute(APPROVER_NAME, (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        model.addAttribute("cityName", (Object)ApplicationThreadLocals.getCityName());
        model.addAttribute("mode", (Object)"ack");
        this.setCommonDetails(sewerageApplicationDetails, modelMap, request);
        boolean inspectionFeeCollectionRequired = this.sewerageTaxUtils.isInspectionFeeCollectionRequired();
        model.addAttribute(INSPECTIONFEEREQUIRED, (Object)inspectionFeeCollectionRequired);
        if (inspectionFeeCollectionRequired) {
            model.addAttribute("inspectionDetails", (Object)sewerageApplicationDetails.getConnectionFees());
        }
        model.addAttribute("documentNamesList", (Object)this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails));
        return new ModelAndView("application-success", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    private void setCommonDetails(SewerageApplicationDetails sewerageApplicationDetails, ModelMap modelMap, HttpServletRequest request) {
        String assessmentNumber = sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier();
        AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentNumber, request);
        if (propertyOwnerDetails != null) {
            modelMap.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        PropertyTaxDetails propertyTaxDetails = this.propertyExternalService.getPropertyTaxDetails(assessmentNumber, null, null);
        modelMap.addAttribute("propertyTax", (Object)propertyTaxDetails.getTotalTaxAmt());
    }

    @RequestMapping(value={"/new-sewerage-ackowledgement/{appNo}"}, method={RequestMethod.GET})
    public String showAcknowledgemnt(@PathVariable String appNo, Model model) {
        model.addAttribute("applicationNo", (Object)appNo);
        return "sewerage-acknowledgement";
    }

    @RequestMapping(value={"/printacknowledgement"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> printAck(@RequestParam(value="appNo") String appNo, Model model, HttpServletRequest request) {
        byte[] reportOutput;
        String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
        String cityName = (String)request.getSession().getAttribute("cityname");
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(appNo);
        if (sewerageApplicationDetails != null && (reportOutput = this.sewerageApplicationDetailsService.getReportParamsForSewerageAcknowdgement(sewerageApplicationDetails, cityMunicipalityName, cityName).getReportOutputData()) != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=new-sewerage-ack.pdf");
            return new ResponseEntity((Object)reportOutput, (MultiValueMap)headers, HttpStatus.CREATED);
        }
        return null;
    }

    public void prepareNewForm(SewerageApplicationDetails sewerageApplicationDetails, Model model) {
        Boolean isEmployee = this.sewerageWorkflowService.isEmployee(this.securityUtils.getCurrentUser());
        Boolean isCitizenPortalUser = this.sewerageWorkflowService.isCitizenPortalUser(this.securityUtils.getCurrentUser());
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("NEWSEWERAGECONNECTION");
        sewerageApplicationDetails.setApplicationType(applicationType);
        model.addAttribute("allowIfPTDueExists", (Object)this.sewerageTaxUtils.isNewConnectionAllowedIfPTDuePresent());
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        model.addAttribute("isEmployee", (Object)isEmployee);
        model.addAttribute("isCitizenPortalUser", (Object)isCitizenPortalUser);
        model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule(sewerageApplicationDetails.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, workFlowContainer);
        model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
        model.addAttribute("typeOfConnection", (Object)"NEWSEWERAGECONNECTION");
    }
}

