/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.reports;

import java.math.BigDecimal;
import java.util.List;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.stms.report.service.SewerageBaseRegisterReportService;
import org.egov.stms.reports.entity.SewerageBaseRegisterResult;
import org.egov.stms.web.adapter.SewerageBaseRegisterAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageBaseRegisterReportController {
    private static final String BASE_REGISTER_REPORT = "stms_base_register_report";
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageBaseRegisterReportService sewerageBaseRegisterReportService;
    @Autowired
    private ReportService reportService;

    @ModelAttribute
    public void getPropertyModel(Model model) {
        model.addAttribute("sewerageBaseRegisterResult", (Object)new SewerageBaseRegisterResult());
    }

    @RequestMapping(value={"/baseregistersearch"}, method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        model.addAttribute("wards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "baseRegisterSearch-form";
    }

    @RequestMapping(value={"/baseregisterresult"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String springPaginationDataTableUpdate(@ModelAttribute SewerageBaseRegisterResult sewerageBaseRegisterResult, Model model) {
        return new DataTable(this.sewerageBaseRegisterReportService.getBaseRegisterDetails(sewerageBaseRegisterResult, model), (long)sewerageBaseRegisterResult.draw()).toJson(SewerageBaseRegisterAdaptor.class);
    }

    @GetMapping(value={"/seweragebaseregister/grand-total"})
    @ResponseBody
    public List<BigDecimal> sewerageBaseRegisterGrandTotal(SewerageBaseRegisterResult sewerageBaseRegisterResult, Model model) {
        return this.sewerageBaseRegisterReportService.baseRegisterGrandTotal(sewerageBaseRegisterResult, model);
    }

    @GetMapping(value={"/seweragebaseregister/download"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> downloadReport(SewerageBaseRegisterResult sewerageBaseRegisterResult, Model model) {
        ReportRequest reportRequest = new ReportRequest(BASE_REGISTER_REPORT, (Object)this.sewerageBaseRegisterReportService.getAllBaseRegisterRecords(sewerageBaseRegisterResult, model));
        reportRequest.setReportFormat(sewerageBaseRegisterResult.getPrintFormat());
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        reportOutput.setReportName(BASE_REGISTER_REPORT);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

