/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.notice;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageRejectionNoticeController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;

    @RequestMapping(value={"/rejectionnotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateRejectionNotice(HttpServletRequest request, HttpSession session) {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(request.getParameter("pathVar"));
        return this.generateReport(sewerageApplicationDetails, session, request);
    }

    private ResponseEntity<byte[]> generateReport(SewerageApplicationDetails sewerageApplicationDetails, HttpSession session, HttpServletRequest request) {
        ReportOutput reportOutput = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=RejectionNotice.pdf");
        reportOutput = this.sewerageNoticeService.generateReportOutputDataForRejection(sewerageApplicationDetails, session, request);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

