/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.notice;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.PdfUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.stms.elasticsearch.entity.SewerageNoticeSearchRequest;
import org.egov.stms.elasticsearch.entity.SewerageSearchResult;
import org.egov.stms.entity.es.SewerageIndex;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.service.es.SeweragePaginationService;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageNoticeController {
    private static final Logger LOGGER = Logger.getLogger(SewerageNoticeController.class);
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    @Autowired
    private SewerageIndexService sewerageIndexService;
    @Autowired
    private SeweragePaginationService seweragePaginationService;

    @RequestMapping(value={"/search-notice"}, method={RequestMethod.GET})
    public String newSearchNoticeForm(Model model) {
        model.addAttribute("revenueWards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE"));
        return "searchSewerageNotices";
    }

    private List<SewerageIndex> getSearchResult(SewerageNoticeSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            searchRequest.setUlbName(cityWebsite.getName());
        }
        BoolQueryBuilder boolQuery = this.sewerageIndexService.getQueryFilterForNotice(searchRequest);
        return this.sewerageIndexService.getNoticeSearchResultByBoolQuery(boolQuery);
    }

    private Page<SewerageIndex> getNoticeSearchResult(SewerageNoticeSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            searchRequest.setUlbName(cityWebsite.getName());
        }
        BoolQueryBuilder boolQuery = this.sewerageIndexService.getQueryFilterForNotice(searchRequest);
        return this.sewerageIndexService.getPagedNoticeSearchResultByBoolQuery(boolQuery, searchRequest);
    }

    @RequestMapping(value={"/searchResult"}, method={RequestMethod.POST})
    @ResponseBody
    public DataTable<SewerageSearchResult> searchApplication(@ModelAttribute SewerageNoticeSearchRequest searchRequest) {
        ArrayList searchResultFomatted = new ArrayList();
        Page searchResult = this.getNoticeSearchResult(searchRequest);
        Pageable pageable = this.seweragePaginationService.sewerageNoticeSearch(searchRequest, searchResultFomatted, searchResult);
        return new DataTable((Page)new PageImpl(searchResultFomatted, pageable, searchResult.getTotalElements()), (long)searchRequest.draw());
    }

    @RequestMapping(value={"/search-NoticeResultSize"}, method={RequestMethod.GET})
    @ResponseBody
    public int getSerachResultCount(@ModelAttribute SewerageNoticeSearchRequest searchRequest) {
        List searchResult = this.getSearchResult(searchRequest);
        return searchResult.size();
    }

    private List<SewerageNotice> getSearchedNotices(SewerageNoticeSearchRequest searchRequest) {
        String noticeTypeInput = null;
        ArrayList<SewerageNotice> noticeList = new ArrayList<SewerageNotice>(0);
        List searchResult = this.getSearchResult(searchRequest);
        for (SewerageIndex sewerageIndexObject : searchResult) {
            String noticeType;
            SewerageNotice sewerageNotice;
            String noticeNo = "";
            if (searchRequest.getNoticeType() != null) {
                noticeTypeInput = searchRequest.getNoticeType();
                if (searchRequest.getNoticeType().equals("WO")) {
                    noticeNo = sewerageIndexObject.getWorkOrderNumber();
                } else if (searchRequest.getNoticeType().equals("EM")) {
                    noticeNo = sewerageIndexObject.getEstimationNumber();
                } else if (searchRequest.getNoticeType().equals("CC")) {
                    noticeNo = sewerageIndexObject.getClosureNoticeNumber();
                } else if (searchRequest.getNoticeType().equals("RN")) {
                    noticeNo = sewerageIndexObject.getRejectionNoticeNumber();
                }
            }
            if (noticeNo == null || noticeNo.isEmpty() || (sewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(noticeNo, noticeType = this.getSewerageNoticeType(noticeNo, noticeTypeInput))) == null) continue;
            noticeList.add(sewerageNotice);
        }
        return noticeList;
    }

    @RequestMapping(value={"/searchNotices-mergeAndDownload"}, method={RequestMethod.GET})
    public String mergeAndDownload(@ModelAttribute SewerageNoticeSearchRequest searchRequest, HttpServletResponse response) throws IOException {
        String noticeType = null;
        List noticeList = this.getSearchedNotices(searchRequest);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into mergeAndDownload method");
        }
        long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("mergeAndDownload : Start Time : " + startTime));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of notices : " + (noticeList != null ? noticeList.size() : 0)));
        }
        ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
        if (noticeList != null && !noticeList.isEmpty()) {
            for (SewerageNotice sewerageNotice : noticeList) {
                try {
                    if (sewerageNotice.getFileStore() == null) continue;
                    sewerageNotice.getApplicationDetails().getConnectionDetail().getPropertyIdentifier();
                    FileStoreMapper fsm = sewerageNotice.getFileStore();
                    File file = this.fileStoreService.fetch(fsm, "STMS");
                    if (file.length() <= 0L) continue;
                    byte[] bFile = FileUtils.readFileToByteArray((File)file);
                    pdfs.add(new ByteArrayInputStream(bFile));
                }
                catch (Exception e) {
                    LOGGER.error((Object)("mergeAndDownload : Getting notice failed for notice " + sewerageNotice), (Throwable)e);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of pdfs : " + (pdfs != null ? pdfs.size() : 0)));
        }
        try {
            byte[] data = PdfUtils.appendFiles(pdfs);
            response.setHeader("Content-disposition", "attachment;filename=notice_" + noticeType + ".pdf");
            response.setContentType("application/pdf");
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)"Exception in Merge and Download : ", (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError("error", e.getMessage())));
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("mergeAndDownload : End Time : " + endTime));
            LOGGER.debug((Object)("SearchNoticesAction | mergeAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from mergeAndDownload method");
        }
        return null;
    }

    @RequestMapping(value={"/searchNotices-seweragezipAndDownload"})
    public String zipAndDownload(@ModelAttribute SewerageNoticeSearchRequest searchRequest, HttpServletResponse response) {
        List noticeList = this.getSearchedNotices(searchRequest);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Entered into zipAndDownload method");
        }
        long startTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("zipAndDownload : Start Time : " + startTime));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of notices : " + (noticeList != null ? noticeList.size() : 0)));
        }
        try {
            ZipOutputStream zipOutputStream = null;
            if (noticeList != null && !noticeList.isEmpty()) {
                zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
                response.setHeader("Content-disposition", "attachment;filename=notice_.zip");
                response.setContentType("application/zip");
            }
            for (SewerageNotice sewerageNotice : noticeList) {
                try {
                    if (sewerageNotice == null || sewerageNotice.getFileStore() == null) continue;
                    FileStoreMapper fsm = sewerageNotice.getFileStore();
                    File file = this.fileStoreService.fetch(fsm, "STMS");
                    byte[] bFile = FileUtils.readFileToByteArray((File)file);
                    zipOutputStream = this.sewerageNoticeService.addFilesToZip((InputStream)new ByteArrayInputStream(bFile), file.getName(), zipOutputStream);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("zipAndDownload : Getting notice failed for notice " + sewerageNotice), (Throwable)e);
                }
            }
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception in Zip and Download : ", (Throwable)e);
            throw new ValidationException(Arrays.asList(new ValidationError("error", e.getMessage())));
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("zipAndDownload : End Time : " + endTime));
            LOGGER.debug((Object)("SewerageNoticeController | zipAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from zipAndDownload method");
        }
        return null;
    }

    public String getSewerageNoticeType(String noticeNo, String noticeTypeInput) {
        String noticeType = null;
        if (noticeNo != null && noticeTypeInput.equals("WO")) {
            noticeType = "Workorder Notice";
        } else if (noticeNo != null && noticeTypeInput.equals("EM")) {
            noticeType = "Estimation Notice";
        } else if (noticeNo != null && noticeTypeInput.equals("CC")) {
            noticeType = "Close Connection Notice";
        } else if (noticeNo != null && noticeTypeInput.equals("RN")) {
            noticeType = "Rejection Notice";
        }
        return noticeType;
    }

    @RequestMapping(value={"/searchNotices-showSewerageNotice/{noticeNo}/{noticeType}"}, method={RequestMethod.GET})
    public String showNotice(@PathVariable(value="noticeNo") String noticeNo, @PathVariable(value="noticeType") String noticeTypeInput, Model model, HttpServletResponse response) throws IOException {
        if (noticeNo != null) {
            String noticeType = this.getSewerageNoticeType(noticeNo, noticeTypeInput);
            SewerageNotice sewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(noticeNo, noticeType);
            if (sewerageNotice != null) {
                FileStoreMapper fsm = sewerageNotice.getFileStore();
                File file = this.fileStoreService.fetch(fsm, "STMS");
                try (FileInputStream is = new FileInputStream(file);){
                    int len;
                    response.setContentType("application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + sewerageNotice.getNoticeNo() + ".pdf\"");
                    ServletOutputStream os = response.getOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((len = ((InputStream)is).read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                    os.flush();
                    os.close();
                }
            } else {
                model.addAttribute("message", (Object)"msg.notice.not.found");
                return "common-error";
            }
        }
        return null;
    }
}

