/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.masters;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.FinancialYearService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.config.core.LocalizationSettings;
import org.egov.infra.utils.DateUtils;
import org.egov.stms.masters.entity.SewerageRatesMaster;
import org.egov.stms.masters.entity.SewerageRatesMasterDetails;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.entity.enums.SewerageRateStatus;
import org.egov.stms.masters.pojo.SewerageRateComparatorOrderById;
import org.egov.stms.masters.pojo.SewerageRatesSearch;
import org.egov.stms.masters.service.SewerageRatesMasterService;
import org.egov.stms.web.controller.utils.SewerageMasterDataValidator;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class SewerageRateMasterController {
    private static final Logger LOG = LoggerFactory.getLogger(SewerageRateMasterController.class);
    private static final String SEWERAGE_RATES_MASTER = "sewerageRatesMaster";
    private static final String SEWERAGE_RATES_SUCCESS_PAGE = "redirect:/masters/getseweragerates/";
    private static final String MESSAGE = "message";
    @Autowired
    private SewerageRatesMasterService sewerageRatesMasterService;
    @Autowired
    private FinancialYearService financialYearService;
    @Autowired
    private SewerageMasterDataValidator sewerageMasterDataValidator;

    private Boolean getAppconfigValue() {
        AppConfigValues appconfigvalue = this.sewerageRatesMasterService.getAppConfigValuesForSeweargeRate("Sewerage Tax Management", "SEWERAGE MONTHLY RATES BY MULTIPLE CLOSETS");
        if (appconfigvalue != null && appconfigvalue.getValue().equalsIgnoreCase("YES")) {
            return false;
        }
        return true;
    }

    @RequestMapping(value={"/seweragerates"}, method={RequestMethod.GET})
    public String showForm(Model model) {
        CFinancialYear financialYear = this.financialYearService.getCurrentFinancialYear();
        if (financialYear != null) {
            model.addAttribute("endDate", (Object)financialYear.getEndingDate());
        }
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        model.addAttribute(SEWERAGE_RATES_MASTER, (Object)new SewerageRatesMaster());
        if (this.getAppconfigValue().booleanValue()) {
            return "sewerageRates-master";
        }
        return "seweragemonthlyRates-master";
    }

    @RequestMapping(value={"/seweragerates"}, method={RequestMethod.POST})
    public String create(@ModelAttribute SewerageRatesMaster sewerageRatesMaster, RedirectAttributes redirectAttrs, Model model, BindingResult resultBinder) {
        ArrayList<SewerageRatesMasterDetails> sewerageRatesMasterDetailslist = new ArrayList<SewerageRatesMasterDetails>();
        this.sewerageMasterDataValidator.validateMonthlyRate(sewerageRatesMaster, this.getAppconfigValue(), (Errors)resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("monthlyRate", (Object)sewerageRatesMaster.getMonthlyRate());
            model.addAttribute(SEWERAGE_RATES_MASTER, (Object)sewerageRatesMaster);
            if (this.getAppconfigValue().booleanValue()) {
                return "sewerageRates-master";
            }
            return "seweragemonthlyRates-master";
        }
        List existingsewerageRatesMasterList = this.sewerageRatesMasterService.getLatestActiveRecord(sewerageRatesMaster.getPropertyType(), true);
        SewerageRatesMaster sewerageRatesMasterExisting = this.sewerageRatesMasterService.findByPropertyTypeAndFromDateAndActive(sewerageRatesMaster.getPropertyType(), sewerageRatesMaster.getFromDate(), true);
        if (sewerageRatesMasterExisting != null) {
            model.addAttribute("existingMonthlyRate", (Object)sewerageRatesMasterExisting.getMonthlyRate());
            sewerageRatesMasterExisting.setActive(false);
            DateTime dateValue = DateUtils.endOfGivenDate((DateTime)new DateTime((Object)sewerageRatesMaster.getFromDate()));
            Date formattedToDate = dateValue.toDate();
            sewerageRatesMasterExisting.setToDate(formattedToDate);
            this.sewerageRatesMasterService.update(sewerageRatesMasterExisting);
            sewerageRatesMaster.setActive(true);
            for (SewerageRatesMasterDetails sewerageRatesMasterDetails : sewerageRatesMaster.getSewerageDetailmaster()) {
                sewerageRatesMasterDetails.setSewerageratemaster(sewerageRatesMaster);
                sewerageRatesMasterDetailslist.add(sewerageRatesMasterDetails);
            }
            sewerageRatesMaster.getSewerageDetailmaster().addAll(sewerageRatesMasterDetailslist);
            this.sewerageRatesMasterService.create(sewerageRatesMaster);
        } else {
            SewerageRatesMaster sewerageRatesMasterOld = null;
            if (!existingsewerageRatesMasterList.isEmpty()) {
                sewerageRatesMasterOld = (SewerageRatesMaster)existingsewerageRatesMasterList.get(0);
            }
            if (sewerageRatesMasterOld != null) {
                if (sewerageRatesMaster.getFromDate().compareTo(new Date()) < 0) {
                    sewerageRatesMasterOld.setActive(false);
                }
                DateTime oldDate = DateUtils.endOfGivenDate((DateTime)new DateTime((Object)sewerageRatesMaster.getFromDate()).minusDays(1));
                Date formattedToDate = oldDate.toDate();
                sewerageRatesMasterOld.setToDate(formattedToDate);
                this.sewerageRatesMasterService.update(sewerageRatesMasterOld);
            }
            sewerageRatesMaster.setActive(true);
            for (SewerageRatesMasterDetails sewerageRatesMasterDetails : sewerageRatesMaster.getSewerageDetailmaster()) {
                sewerageRatesMasterDetails.setSewerageratemaster(sewerageRatesMaster);
                sewerageRatesMasterDetailslist.add(sewerageRatesMasterDetails);
            }
            sewerageRatesMaster.getSewerageDetailmaster().clear();
            sewerageRatesMaster.getSewerageDetailmaster().addAll(sewerageRatesMasterDetailslist);
            this.sewerageRatesMasterService.create(sewerageRatesMaster);
        }
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)"msg.seweragemonthlyrate.creation.success");
        return SEWERAGE_RATES_SUCCESS_PAGE + sewerageRatesMaster.getId();
    }

    @RequestMapping(value={"/getseweragerates/{id}"}, method={RequestMethod.GET})
    public String getSeweragerates(@PathVariable(value="id") Long id, Model model) {
        SewerageRatesMaster sewerageRatesMaster = this.sewerageRatesMasterService.findBy(id);
        if (this.getAppconfigValue() != null && !this.getAppconfigValue().booleanValue()) {
            for (SewerageRatesMasterDetails swdm : sewerageRatesMaster.getSewerageDetailmaster()) {
                swdm.setAmount(Double.valueOf(BigDecimal.valueOf(swdm.getAmount()).setScale(2, 6).doubleValue()));
            }
            Collections.sort(sewerageRatesMaster.getSewerageDetailmaster(), new SewerageRateComparatorOrderById());
        }
        model.addAttribute(SEWERAGE_RATES_MASTER, (Object)sewerageRatesMaster);
        if (this.getAppconfigValue().booleanValue()) {
            return "sewerageRates-success";
        }
        return "seweragemonthlyRates-success";
    }

    @RequestMapping(value={"/ajaxexistingseweragevalidate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public double getSewerageRatesByAllCombinatons(@RequestParam(value="propertyType") PropertyType propertyType, @RequestParam(value="fromDate") Date fromDate) {
        SewerageRatesMaster sewerageRatesMasterExist = this.sewerageRatesMasterService.findByPropertyTypeAndFromDateAndActive(propertyType, fromDate, true);
        if (sewerageRatesMasterExist != null) {
            return sewerageRatesMasterExist.getMonthlyRate() != null ? sewerageRatesMasterExist.getMonthlyRate() : 1.0;
        }
        return 0.0;
    }

    @RequestMapping(value={"/fromDateValidationWithLatestActiveRecord"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getLatestActiveFromDate(@RequestParam(value="propertyType") PropertyType propertyType, @RequestParam(value="fromDate") Date fromDate) {
        SewerageRatesMaster existingActiveSewerageRatesObject;
        SimpleDateFormat newFormat = new SimpleDateFormat("dd-MM-yyyy");
        List existingsewerageRatesMasterList = this.sewerageRatesMasterService.getLatestActiveRecord(propertyType, true);
        if (!existingsewerageRatesMasterList.isEmpty() && fromDate != null && fromDate.compareTo((existingActiveSewerageRatesObject = (SewerageRatesMaster)existingsewerageRatesMasterList.get(0)).getFromDate()) < 0) {
            return newFormat.format(existingActiveSewerageRatesObject.getFromDate());
        }
        return "true";
    }

    @RequestMapping(value={"/viewSewerageRate"}, method={RequestMethod.GET})
    public String view(@ModelAttribute SewerageRatesSearch sewerageRatesSearch, Model model) {
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        model.addAttribute("statusValues", (Object)SewerageRateStatus.values());
        return "sewerageRates-view";
    }

    @RequestMapping(value={"/rateView/{id}"}, method={RequestMethod.GET})
    public String view(@ModelAttribute SewerageRatesSearch sewerageRatesSearch, Model model, @PathVariable(value="id") Long id, RedirectAttributes redirectAttrs) {
        SewerageRatesMaster sewerageRatesMaster = this.sewerageRatesMasterService.findBy(id);
        model.addAttribute("sewerageRatesSearch", (Object)sewerageRatesMaster);
        return SEWERAGE_RATES_SUCCESS_PAGE + id;
    }

    @RequestMapping(value={"/search-sewerage-rates"}, method={RequestMethod.GET})
    @ResponseBody
    public void sewerageRatesSearch(Model model, @ModelAttribute SewerageRatesSearch sewerageRatesSearch, HttpServletResponse response) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("dd-MM-yyyy");
        PropertyType type = null;
        String effectivefromDate = null;
        if (sewerageRatesSearch.getPropertyType() != null) {
            type = PropertyType.valueOf((String)sewerageRatesSearch.getPropertyType());
        }
        if (sewerageRatesSearch.getFromDate() != null) {
            try {
                effectivefromDate = newFormat.format(formatter.parse(sewerageRatesSearch.getFromDate()));
            }
            catch (ParseException e) {
                LOG.error("Parse Exception " + e);
            }
        }
        List seweragesearchlist = this.sewerageRatesMasterService.getSewerageMasters(type, effectivefromDate, sewerageRatesSearch.getStatus());
        ArrayList<SewerageRatesSearch> displyalist = new ArrayList<SewerageRatesSearch>();
        for (SewerageRatesSearch seRatesSearch : seweragesearchlist) {
            if (this.getAppconfigValue().booleanValue() && seRatesSearch.getMonthlyRate() != null) {
                displyalist.add(seRatesSearch);
                continue;
            }
            if (this.getAppconfigValue().booleanValue() || seRatesSearch.getMonthlyRate() != null) continue;
            displyalist.add(seRatesSearch);
        }
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson(displyalist) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"update/{id}"}, method={RequestMethod.GET})
    public String updateSewerageRates(@ModelAttribute SewerageRatesMaster sewerageRatesMaster, @PathVariable Long id, Model model) {
        SewerageRatesMaster existingratesMaster = this.sewerageRatesMasterService.findBy(id);
        model.addAttribute(SEWERAGE_RATES_MASTER, (Object)existingratesMaster);
        if (this.getAppconfigValue().booleanValue()) {
            return "sewerageRates-update";
        }
        Collections.sort(existingratesMaster.getSewerageDetailmaster(), new SewerageRateComparatorOrderById());
        model.addAttribute(SEWERAGE_RATES_MASTER, (Object)existingratesMaster);
        model.addAttribute("sewerageDetailmaster", (Object)existingratesMaster.getSewerageDetailmaster());
        return "seweragemonthlyRates-update";
    }

    @RequestMapping(value={"update/{id}"}, method={RequestMethod.POST})
    public String update(@ModelAttribute SewerageRatesMaster sewerageRatesMaster, @PathVariable Long id, Model model, RedirectAttributes redirectAttrs, BindingResult errors) throws ParseException {
        SimpleDateFormat newFormat = new SimpleDateFormat("dd-MM-yyyy");
        SewerageRatesMaster ratesMaster = this.sewerageRatesMasterService.findBy(id);
        String todaysdate = newFormat.format(new Date());
        String effectiveFromDate = newFormat.format(ratesMaster.getFromDate());
        Date currentDate = newFormat.parse(todaysdate);
        Date effectiveDate = newFormat.parse(effectiveFromDate);
        if (this.getAppconfigValue().booleanValue()) {
            this.sewerageMasterDataValidator.validateSewerageMonthlyRateUpdate(sewerageRatesMaster, (Errors)errors);
        }
        if (errors.hasErrors()) {
            model.addAttribute(SEWERAGE_RATES_MASTER, (Object)sewerageRatesMaster);
            if (this.getAppconfigValue().booleanValue()) {
                return "seweragemonthlyRates-update";
            }
            return "sewerageRates-update";
        }
        if (effectiveDate.compareTo(currentDate) < 0) {
            model.addAttribute(MESSAGE, (Object)"msg.seweragerate.modification.rejected");
            return "sewerageRates-update";
        }
        if (this.getAppconfigValue().booleanValue()) {
            ArrayList existingSewerageDetailList = new ArrayList();
            if (sewerageRatesMaster != null && !sewerageRatesMaster.getSewerageDetailmaster().isEmpty()) {
                existingSewerageDetailList.addAll(ratesMaster.getSewerageDetailmaster());
            }
            if (sewerageRatesMaster != null && sewerageRatesMaster.getSewerageDetailmaster() != null) {
                this.sewerageRatesMasterService.updateSewerageRateMaster(sewerageRatesMaster, ratesMaster, existingSewerageDetailList);
            }
        } else {
            ratesMaster.setMonthlyRate(sewerageRatesMaster.getMonthlyRate());
            this.sewerageRatesMasterService.update(ratesMaster);
        }
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)"msg.seweragemonthlyrate.update.success");
        return SEWERAGE_RATES_SUCCESS_PAGE + id;
    }

    @RequestMapping(value={"/fromDateValues-by-propertyType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Date> effectiveFromDates(@RequestParam PropertyType propertyType) {
        return this.sewerageRatesMasterService.findFromDateByPropertyType(propertyType);
    }
}

