/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.masters;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.FinancialYearService;
import org.egov.infra.config.core.LocalizationSettings;
import org.egov.infra.utils.DateUtils;
import org.egov.stms.masters.entity.DonationDetailMaster;
import org.egov.stms.masters.entity.DonationMaster;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.entity.enums.SewerageRateStatus;
import org.egov.stms.masters.pojo.DonationMasterSearch;
import org.egov.stms.masters.pojo.DonationRateComparatorOrderById;
import org.egov.stms.masters.service.DonationMasterService;
import org.egov.stms.web.controller.utils.SewerageMasterDataValidator;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class DonationMasterController {
    private static final Logger LOG = LoggerFactory.getLogger(DonationMasterController.class);
    private static final String DONATIONMASTER = "donationMaster";
    private static final String REDIRECT_TO_SUCCESS_PAGE = "redirect:/masters/success/";
    private static final String MESSAGE = "message";
    private static final String DONATION_MASTER_UPDATE = "donation-master-update";
    @Autowired
    private DonationMasterService donationMasterService;
    @Autowired
    private FinancialYearService financialYearService;
    @Autowired
    private SewerageMasterDataValidator sewerageMasterDataValidator;

    @RequestMapping(value={"/donationmaster"}, method={RequestMethod.GET})
    public String showForm(@ModelAttribute DonationMaster donationMaster, Model model) {
        DonationMaster donationMasterObj = new DonationMaster();
        CFinancialYear financialYear = this.financialYearService.getCurrentFinancialYear();
        if (financialYear != null) {
            model.addAttribute("endDate", (Object)financialYear.getEndingDate());
        }
        model.addAttribute(DONATIONMASTER, (Object)donationMasterObj);
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        return "donation-master";
    }

    @RequestMapping(value={"/donationmaster"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createDonationMaster(@ModelAttribute DonationMaster donationMaster, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        DonationMaster donationMasterObj;
        ArrayList<DonationDetailMaster> donationMasterDetailList = new ArrayList<DonationDetailMaster>();
        this.sewerageMasterDataValidator.validateDonationMaster((Errors)errors, donationMaster);
        if (errors.hasErrors()) {
            model.addAttribute(DONATIONMASTER, (Object)donationMaster);
            return "donation-master";
        }
        List existingdonationMaster = this.donationMasterService.getLatestActiveRecordByPropertyTypeAndActive(donationMaster.getPropertyType(), true);
        DonationMaster donationMasterExist = this.donationMasterService.findByPropertyTypeAndFromDateAndActive(donationMaster.getPropertyType(), donationMaster.getFromDate(), true);
        if (donationMasterExist != null) {
            DateTime dateTime = DateUtils.endOfGivenDate((DateTime)new DateTime((Object)donationMaster.getFromDate()));
            Date dateformat = dateTime.toDate();
            donationMasterExist.setActive(false);
            donationMasterExist.setToDate(dateformat);
            donationMaster.setActive(true);
            for (DonationDetailMaster donationDetailMaster : donationMaster.getDonationDetail()) {
                donationDetailMaster.setDonation(donationMaster);
                donationMasterDetailList.add(donationDetailMaster);
            }
            donationMaster.getDonationDetail().addAll(donationMasterDetailList);
            donationMasterObj = this.donationMasterService.createDonationRate(donationMaster);
        } else {
            DonationMaster donationMasterOld = null;
            if (!existingdonationMaster.isEmpty()) {
                donationMasterOld = (DonationMaster)existingdonationMaster.get(0);
            }
            if (donationMasterOld != null) {
                if (donationMaster.getFromDate().compareTo(new Date()) < 0) {
                    donationMasterOld.setActive(false);
                }
                DateTime dateTime = DateUtils.endOfGivenDate((DateTime)new DateTime((Object)donationMaster.getFromDate()).minusDays(1));
                Date dateformat = dateTime.toDate();
                donationMasterOld.setToDate(dateformat);
                this.donationMasterService.update(donationMasterOld);
            }
            donationMaster.setActive(true);
            for (DonationDetailMaster donationDetailMaster : donationMaster.getDonationDetail()) {
                donationDetailMaster.setDonation(donationMaster);
                donationMasterDetailList.add(donationDetailMaster);
            }
            donationMaster.getDonationDetail().clear();
            donationMaster.getDonationDetail().addAll(donationMasterDetailList);
            donationMasterObj = this.donationMasterService.createDonationRate(donationMaster);
        }
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)"msg.donationrate.creation.success");
        return REDIRECT_TO_SUCCESS_PAGE + donationMasterObj.getId();
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public String getSeweragerates(@ModelAttribute DonationMaster donationMaster, @PathVariable(value="id") Long id, Model model) {
        DonationMaster donationMaster1 = this.donationMasterService.findById(id);
        for (DonationDetailMaster ddm : donationMaster1.getDonationDetail()) {
            ddm.setAmount(Double.valueOf(BigDecimal.valueOf(ddm.getAmount()).setScale(2, 6).doubleValue()));
        }
        Collections.sort(donationMaster1.getDonationDetail(), new DonationRateComparatorOrderById());
        model.addAttribute(DONATIONMASTER, (Object)donationMaster1);
        return "donation-master-success";
    }

    @RequestMapping(value={"/fromDateValidationWithActiveRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public String validateFromDateWithActiveDate(@RequestParam(value="propertyType") PropertyType propertyType, @RequestParam(value="fromDate") Date date) {
        DonationMaster existingActiveDonationObject;
        List donationList;
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        if (date != null && !(donationList = this.donationMasterService.getLatestActiveRecordByPropertyTypeAndActive(propertyType, true)).isEmpty() && (existingActiveDonationObject = (DonationMaster)donationList.get(0)).getFromDate().compareTo(new Date()) >= 0 && date.compareTo(existingActiveDonationObject.getFromDate()) < 0) {
            return formatter.format(existingActiveDonationObject.getFromDate()).toString();
        }
        return "true";
    }

    @RequestMapping(value={"/ajaxexistingdonationvalidate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public double geWaterRatesByAllCombinatons(@RequestParam(value="propertyType") PropertyType propertyType, @RequestParam(value="fromDate") Date fromDate) {
        DonationMaster donationMasterMaster = this.donationMasterService.findByPropertyTypeAndFromDateAndActive(propertyType, fromDate, true);
        if (donationMasterMaster != null) {
            return 1.0;
        }
        return 0.0;
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewDonationMaster(Model model, @ModelAttribute DonationMasterSearch donationMasterSearch) {
        model.addAttribute("propertyType", (Object)PropertyType.values());
        model.addAttribute("statusValues", (Object)SewerageRateStatus.values());
        return "donationMaster-view";
    }

    @RequestMapping(value={"/search-donation-master"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchDonationMaster(@ModelAttribute DonationMasterSearch donationMasterSearch, HttpServletResponse response) throws IOException {
        PropertyType type = null;
        String effectivefromDate = null;
        if (donationMasterSearch.getPropertyType() != null) {
            type = PropertyType.valueOf((String)donationMasterSearch.getPropertyType());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
        if (donationMasterSearch.getFromDate() != null) {
            try {
                effectivefromDate = myFormat.format(formatter.parse(donationMasterSearch.getFromDate()));
            }
            catch (ParseException e) {
                LOG.error("Parse Exception" + e);
            }
        }
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson((Object)this.donationMasterService.getDonationMasters(type, effectivefromDate, donationMasterSearch.getStatus())) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/fromDate-by-propertyType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Date> effectiveFromDates(@RequestParam PropertyType propertyType) {
        return this.donationMasterService.findFromDateByPropertyType(propertyType);
    }

    @RequestMapping(value={"/donationView/{id}"}, method={RequestMethod.GET})
    public String viewDonation(@PathVariable Long id) {
        return REDIRECT_TO_SUCCESS_PAGE + id;
    }

    @RequestMapping(value={"/donationUpdate/{id}"}, method={RequestMethod.GET})
    public String updateDonation(@PathVariable Long id, Model model) {
        DonationMaster dm = this.donationMasterService.findById(id);
        Collections.sort(dm.getDonationDetail(), new DonationRateComparatorOrderById());
        model.addAttribute(DONATIONMASTER, (Object)dm);
        model.addAttribute("donationDetail", (Object)dm.getDonationDetail());
        return DONATION_MASTER_UPDATE;
    }

    @RequestMapping(value={"/donationUpdate/{id}"}, method={RequestMethod.POST})
    public String updateDonationValues(@ModelAttribute DonationMaster donationMaster, @PathVariable Long id, Model model, BindingResult errors, RedirectAttributes redirectAttrs) throws ParseException {
        this.sewerageMasterDataValidator.validateDonationMasterUpdate((Errors)errors, donationMaster);
        if (errors.hasErrors()) {
            model.addAttribute(DONATIONMASTER, (Object)donationMaster);
            return DONATION_MASTER_UPDATE;
        }
        DonationMaster donationMstr = this.donationMasterService.findById(id);
        if (donationMstr != null) {
            Date currentDate;
            SimpleDateFormat myFormat = new SimpleDateFormat("dd-MM-yyyy");
            String todaysdate = myFormat.format(new Date());
            String effectiveFromDate = myFormat.format(donationMstr.getFromDate());
            Date effectiveDate = myFormat.parse(effectiveFromDate);
            if (effectiveDate.compareTo(currentDate = myFormat.parse(todaysdate)) < 0) {
                model.addAttribute(MESSAGE, (Object)"msg.donationrate.modification.rejected");
                return DONATION_MASTER_UPDATE;
            }
            donationMstr.setLastModifiedDate(new Date());
            ArrayList existingdonationDetailList = new ArrayList();
            if (donationMaster != null && !donationMaster.getDonationDetail().isEmpty()) {
                existingdonationDetailList.addAll(donationMstr.getDonationDetail());
            }
            if (donationMaster != null && donationMaster.getDonationDetail() != null) {
                this.updateDonationMaster(donationMaster, donationMstr, existingdonationDetailList);
            }
        } else {
            model.addAttribute(MESSAGE, (Object)"msg.donationrate.notfound");
            return DONATION_MASTER_UPDATE;
        }
        redirectAttrs.addFlashAttribute(MESSAGE, (Object)"msg.donationrate.update.success");
        return REDIRECT_TO_SUCCESS_PAGE + id;
    }

    private void updateDonationMaster(DonationMaster donationMaster, DonationMaster donationMstr, List<DonationDetailMaster> existingdonationDetailList) {
        if (!existingdonationDetailList.isEmpty()) {
            for (DonationDetailMaster dtlObject : existingdonationDetailList) {
                if (donationMaster.getDonationDetail().contains(dtlObject)) continue;
                donationMstr.deleteDonationDetail(dtlObject);
            }
            for (DonationDetailMaster dtlMaster : donationMaster.getDonationDetail()) {
                if (dtlMaster.getId() == null) {
                    DonationDetailMaster donationDetailObject = new DonationDetailMaster();
                    donationDetailObject.setNoOfClosets(dtlMaster.getNoOfClosets());
                    donationDetailObject.setAmount(dtlMaster.getAmount());
                    donationDetailObject.setDonation(donationMstr);
                    donationMstr.addDonationDetail(donationDetailObject);
                    continue;
                }
                if (dtlMaster.getId() == null || !existingdonationDetailList.contains(dtlMaster)) continue;
                this.updateDonationDetail(donationMstr, dtlMaster);
            }
        }
        this.donationMasterService.update(donationMstr);
    }

    private void updateDonationDetail(DonationMaster donationMstr, DonationDetailMaster dtlMaster) {
        for (DonationDetailMaster dtlObject : donationMstr.getDonationDetail()) {
            if (!dtlObject.getId().equals(dtlMaster.getId())) continue;
            dtlObject.setAmount(dtlMaster.getAmount());
            dtlObject.setNoOfClosets(dtlMaster.getNoOfClosets());
        }
    }
}

