/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.elasticsearch.entity.SewerageCollectFeeSearchRequest;
import org.egov.stms.elasticsearch.entity.SewerageSearchResult;
import org.egov.stms.service.es.SeweragePaginationService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/collectfee/search"})
public class SewerageCollectFeeSearchController {
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SeweragePaginationService seweragePaginationService;

    @ModelAttribute
    public SewerageCollectFeeSearchRequest searchRequest() {
        return new SewerageCollectFeeSearchRequest();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        return "seweragecollectcharges-form";
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @RequestMapping(value={"/view/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public ModelAndView view(@PathVariable String consumernumber, @PathVariable String assessmentnumber, Model model, ModelMap modelMap, HttpServletRequest request) {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber);
        AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request);
        if (propertyOwnerDetails != null) {
            modelMap.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        model.addAttribute("applicationHistory", (Object)this.sewerageApplicationDetailsService.getHistory(sewerageApplicationDetails));
        model.addAttribute("documentNamesList", (Object)this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails));
        return new ModelAndView("viewseweragedetails", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public DataTable<SewerageSearchResult> searchApplication(@ModelAttribute SewerageCollectFeeSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            searchRequest.setUlbName(cityWebsite.getName());
        }
        ArrayList searchResultList = new ArrayList();
        ArrayList roleList = new ArrayList();
        HashMap actionMap = new HashMap();
        PageRequest pageable = new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize(), searchRequest.orderDir(), new String[]{searchRequest.orderBy()});
        Page resultList = this.seweragePaginationService.sewerageCollectSearchObj(searchRequest, searchResultList, roleList, actionMap);
        return new DataTable((Page)new PageImpl(searchResultList, (Pageable)pageable, resultList.getTotalElements()), (long)searchRequest.draw());
    }
}

