/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.collection;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.egov.demand.interfaces.Billable;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.transactions.service.collection.SewerageBillServiceImpl;
import org.egov.stms.transactions.service.collection.SewerageBillable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/collection"})
public class SewerageBillGeneratorController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageBillServiceImpl sewerageBillServiceImpl;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private SewerageBillable sewerageBillable;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;

    @RequestMapping(value={"/generatebill/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public String payTax(@PathVariable String consumernumber, @PathVariable String assessmentnumber, Model model, ModelMap modelMap, @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request) {
        if (consumernumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber);
        }
        if (sewerageApplicationDetails != null) {
            if (sewerageApplicationDetails.getCurrentDemand() != null && !this.sewerageDemandService.checkAnyTaxIsPendingToCollect(sewerageApplicationDetails.getCurrentDemand()).booleanValue()) {
                model.addAttribute("message", (Object)"msg.collection.noPendingTax");
                return "collectSwtTax-error";
            }
            if (sewerageApplicationDetails.getCurrentDemand() != null && assessmentnumber != null) {
                AssessmentDetails assessmentDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request);
                Serializable referenceNumber = this.sequenceNumberGenerator.getNextSequence("SEQ_SEWERAGEBILL_NUMBER");
                this.sewerageBillable.setSewerageApplicationDetails(sewerageApplicationDetails);
                this.sewerageBillable.setAssessmentDetails(assessmentDetails);
                this.sewerageBillable.setReferenceNumber(String.format("%s%06d", "", referenceNumber));
                model.addAttribute("collectxml", (Object)this.sewerageBillServiceImpl.getBillXML((Billable)this.sewerageBillable));
            } else {
                model.addAttribute("message", (Object)"msg.collection.noPendingTax");
                return "collectAdvtax-error";
            }
        }
        return "collecttax-redirection";
    }
}

