/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.citizen;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.egov.demand.interfaces.Billable;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.elasticsearch.entity.SewerageConnSearchRequest;
import org.egov.stms.elasticsearch.entity.SewerageSearchResult;
import org.egov.stms.service.es.SeweragePaginationService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDCBReporService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.transactions.service.collection.SewerageBillServiceImpl;
import org.egov.stms.transactions.service.collection.SewerageBillable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class SewerageCitizenSupportController {
    private static final String SEARCH_STMS_ONLINE_PAYMENT = "search-sewerage-online-payment";
    private static final String MESSAGE = "message";
    private static final String COLLECT_SEWERAGETAX_ERROR = "collectSwtTax-error";
    private static final String SEWERAGE_ONLINEPAYMENT_REDIRECTION = "sewerage-onlinepayment-redirection";
    private static final String SEWERAGE_CITIZEN_ONLINE_DCBVIEW = "citizen/sewerage-citizen-dcbview";
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private SewerageBillable sewerageBillable;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private SewerageBillServiceImpl sewerageBillServiceImpl;
    @Autowired
    private SewerageDCBReporService sewerageDCBReporService;
    @Autowired
    private SeweragePaginationService seweragePaginationService;

    @RequestMapping(value={"/citizen/search/search-sewerage"}, method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        model.addAttribute("sewerage", (Object)new SewerageConnSearchRequest());
        return SEARCH_STMS_ONLINE_PAYMENT;
    }

    @RequestMapping(value={"/citizen/search/onlinepayment"}, method={RequestMethod.POST})
    @ResponseBody
    public DataTable<SewerageSearchResult> searchApplication(@ModelAttribute SewerageConnSearchRequest sewerageConnSearchRequest) {
        ArrayList searchResultList = new ArrayList();
        PageRequest pageable = new PageRequest(sewerageConnSearchRequest.pageNumber(), sewerageConnSearchRequest.pageSize(), sewerageConnSearchRequest.orderDir(), new String[]{sewerageConnSearchRequest.orderBy()});
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            sewerageConnSearchRequest.setUlbName(cityWebsite.getName());
        }
        Page resultList = this.seweragePaginationService.buildPaymentSearch(sewerageConnSearchRequest, searchResultList);
        return new DataTable((Page)new PageImpl(searchResultList, (Pageable)pageable, resultList.getTotalElements()), (long)sewerageConnSearchRequest.draw());
    }

    @RequestMapping(value={"/citizen/search/sewerageRateReportView/{consumerno}/{assessmentno}"}, method={RequestMethod.GET})
    public ModelAndView getSewerageRateReport(@PathVariable String consumerno, @PathVariable String assessmentno, Model model, HttpServletRequest request) {
        SewerageApplicationDetails sewerageApplicationDetails = null;
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        String currentDate = formatter.format(new Date());
        if (consumerno != null && (sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumerno)) != null) {
            AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentno, request);
            model.addAttribute("applicationNumber", (Object)sewerageApplicationDetails.getApplicationNumber());
            model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
            model.addAttribute("assessmentnumber", (Object)assessmentno);
            model.addAttribute("currentDate", (Object)currentDate);
            model.addAttribute("dcbResultList", (Object)this.sewerageDCBReporService.getSewerageRateDCBReport(sewerageApplicationDetails));
        }
        return new ModelAndView(SEWERAGE_CITIZEN_ONLINE_DCBVIEW, "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    @RequestMapping(value={"/citizen/search/sewerageGenerateonlinebill/{consumerno}/{assessmentno}"}, method={RequestMethod.POST, RequestMethod.GET})
    public String payTax(@PathVariable String consumerno, @PathVariable String assessmentno, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request) {
        SewerageApplicationDetails sewerageApplicationDetails = new SewerageApplicationDetails();
        if (consumerno != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumerno);
        }
        if (sewerageApplicationDetails != null) {
            if (sewerageApplicationDetails.getCurrentDemand() != null && !this.sewerageDemandService.checkAnyTaxIsPendingToCollect(sewerageApplicationDetails.getCurrentDemand()).booleanValue()) {
                model.addAttribute(MESSAGE, (Object)"msg.collection.noPendingTax");
                return COLLECT_SEWERAGETAX_ERROR;
            }
            if (sewerageApplicationDetails.getCurrentDemand() != null && assessmentno != null) {
                AssessmentDetails assessmentDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentno, request);
                Serializable referenceNumber = this.sequenceNumberGenerator.getNextSequence("SEQ_SEWERAGEBILL_NUMBER");
                this.sewerageBillable.setSewerageApplicationDetails(sewerageApplicationDetails);
                this.sewerageBillable.setAssessmentDetails(assessmentDetails);
                this.sewerageBillable.setReferenceNumber(String.format("%s%06d", "", referenceNumber));
                model.addAttribute("collectxml", (Object)this.sewerageBillServiceImpl.getBillXML((Billable)this.sewerageBillable));
                return SEWERAGE_ONLINEPAYMENT_REDIRECTION;
            }
            model.addAttribute(MESSAGE, (Object)"msg.collection.noPendingTax");
            return COLLECT_SEWERAGETAX_ERROR;
        }
        model.addAttribute(MESSAGE, (Object)"msg.invalid.request");
        return COLLECT_SEWERAGETAX_ERROR;
    }
}

