/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.application;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/application"})
public class ViewSewerageApplicationController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;

    @RequestMapping(value={"/view/{applicationNumber}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String applicationNumber, HttpServletRequest request) {
        SewerageApplicationDetails details = null;
        details = this.sewerageApplicationDetailsService.findByApplicationNumberAndConnectionStatus(applicationNumber, SewerageConnectionStatus.ACTIVE);
        if (details == null) {
            details = this.sewerageApplicationDetailsService.findByApplicationNumberAndConnectionStatus(applicationNumber, SewerageConnectionStatus.CLOSED);
        }
        if (details == null) {
            details = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        }
        model.addAttribute("sewerageApplicationDetails", (Object)details);
        model.addAttribute("checkOperator", (Object)this.sewerageTaxUtils.checkCollectionOperatorRole());
        model.addAttribute("citizenRole", (Object)this.sewerageTaxUtils.getCitizenUserRole());
        BigDecimal waterTaxDueforParent = this.sewerageApplicationDetailsService.getTotalAmount(details);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        model.addAttribute("mode", (Object)"search");
        return "application-view";
    }

    @ModelAttribute(value="cscUserRole")
    public String getCurrentUserRole() {
        String cscUserRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("CSC Operator")) continue;
            cscUserRole = userrole.getName();
            break;
        }
        return cscUserRole;
    }

    @ModelAttribute(value="ulbUserRole")
    public String getUlbOperatorUserRole() {
        String userRole = "";
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("ULB Operator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }
}

