/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.service.DonationMasterService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageDemandDetail;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class SewerageAjaxConnectionController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private DonationMasterService donationMasterService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SewerageDemandService sewerageDemandService;

    @RequestMapping(value={"/ajaxconnection/check-connection-exists"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String isConnectionPresentForProperty(@RequestParam String propertyID) {
        return this.sewerageApplicationDetailsService.isConnectionExistsForProperty(propertyID);
    }

    @RequestMapping(value={"/ajaxconnection/check-watertax-due"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public HashMap<String, Object> getWaterTaxDueAndCurrentTax(@RequestParam(value="assessmentNo") String assessmentNo, HttpServletRequest request) {
        return this.sewerageThirdPartyServices.getWaterTaxDueAndCurrentTax(assessmentNo, request);
    }

    @RequestMapping(value={"/ajaxconnection/check-closets-exists"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String isClosetsPresent(@RequestParam PropertyType propertyType, @RequestParam Integer noOfClosets, @RequestParam Boolean flag) {
        if (flag.booleanValue()) {
            return this.donationMasterService.checkClosetsPresentForGivenCombination(PropertyType.RESIDENTIAL, noOfClosets);
        }
        return this.donationMasterService.checkClosetsPresentForGivenCombination(PropertyType.NON_RESIDENTIAL, noOfClosets);
    }

    @RequestMapping(value={"/ajaxconnection/check-application-inworkflow/{shscNumber}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String checkApplicationInProgress(@PathVariable String shscNumber) {
        String validationMessage = "";
        SewerageApplicationDetails sewerageAppDtl = this.sewerageApplicationDetailsService.isApplicationInProgress(shscNumber);
        if (sewerageAppDtl != null && sewerageAppDtl.getApplicationType().getCode().equalsIgnoreCase("CHANGEINCLOSETS")) {
            validationMessage = this.messageSource.getMessage("err.validate.changenoofclosets.application.inprogress", (Object[])new String[]{sewerageAppDtl.getConnectionDetail().getPropertyIdentifier(), sewerageAppDtl.getApplicationNumber()}, null);
            return validationMessage;
        }
        if (sewerageAppDtl != null && sewerageAppDtl.getApplicationType().getCode().equalsIgnoreCase("CLOSESEWERAGECONNECTION")) {
            validationMessage = this.messageSource.getMessage("err.validate.closeconnection.application.inprogress", (Object[])new String[]{sewerageAppDtl.getConnectionDetail().getPropertyIdentifier(), sewerageAppDtl.getApplicationNumber()}, null);
            return validationMessage;
        }
        return validationMessage;
    }

    @RequestMapping(value={"/ajaxconnection/check-shscnumber-exists"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String isSHSCNumberUnique(@RequestParam String shscNumber) {
        List appDetailList = this.sewerageApplicationDetailsService.findByConnectionShscNumber(shscNumber);
        if (!appDetailList.isEmpty() && ((SewerageApplicationDetails)appDetailList.get(0)).getConnection().getShscNumber() != null) {
            return this.messageSource.getMessage("err.validate.shscnumber.exists", (Object[])new String[]{shscNumber}, null);
        }
        return "";
    }

    @RequestMapping(value={"/ajaxconnection/getlegacy-demand-details"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SewerageDemandDetail> getLegacyDemandDetails(@RequestParam(value="executionDate") String executionDate, HttpServletRequest request) {
        ArrayList<SewerageDemandDetail> demandDetailBeanList = new ArrayList<SewerageDemandDetail>();
        LinkedHashSet<SewerageDemandDetail> tempDemandDetail = new LinkedHashSet<SewerageDemandDetail>();
        List allInstallments = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            allInstallments = this.sewerageTaxUtils.getInstallmentsForCurrYear(sdf.parse(executionDate));
        }
        catch (ParseException e) {
            throw new ApplicationRuntimeException("Error while getting all installments from start date", (Throwable)e);
        }
        SewerageDemandDetail dmdDtl = null;
        for (Installment installObj : allInstallments) {
            EgDemandReason demandReasonObj = this.sewerageDemandService.getDemandReasonByCodeAndInstallment("SEWERAGETAX", installObj.getId());
            if (demandReasonObj != null) {
                dmdDtl = this.createDemandDetailBean(installObj, demandReasonObj);
            }
            tempDemandDetail.add(dmdDtl);
        }
        for (SewerageDemandDetail demandDetList : tempDemandDetail) {
            if (demandDetList == null) continue;
            demandDetailBeanList.add(demandDetList);
        }
        return demandDetailBeanList;
    }

    private SewerageDemandDetail createDemandDetailBean(Installment installment, EgDemandReason demandReasonObj) {
        SewerageDemandDetail demandDetail = new SewerageDemandDetail();
        demandDetail.setInstallment(installment.getDescription());
        demandDetail.setReasonMaster(demandReasonObj.getEgDemandReasonMaster().getCode());
        demandDetail.setInstallmentId(installment.getId());
        demandDetail.setDemandReasonId(demandReasonObj.getId());
        demandDetail.setActualAmount(BigDecimal.ZERO);
        demandDetail.setActualCollection(BigDecimal.ZERO);
        demandDetail.setReasonMasterDesc(demandReasonObj.getEgDemandReasonMaster().getReasonMaster());
        return demandDetail;
    }

    @RequestMapping(value={"/ajaxconnection/getlegacy-donation-amount"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getLegacyDonationAmount(@RequestParam(value="propertytype") PropertyType propertyType, @RequestParam(value="noofclosetsresidential") Integer noofclosetsresidential, @RequestParam(value="noofclosetsnonresidential") Integer noofclosetsnonresidential) {
        BigDecimal legacyDonationAmount = BigDecimal.ZERO;
        BigDecimal residentialAmount = BigDecimal.ZERO;
        BigDecimal nonResidentialAmount = BigDecimal.ZERO;
        if (noofclosetsresidential != null && noofclosetsresidential != 0) {
            residentialAmount = this.donationMasterService.getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(noofclosetsresidential, PropertyType.RESIDENTIAL);
        }
        if (noofclosetsnonresidential != null && noofclosetsnonresidential != 0) {
            nonResidentialAmount = this.donationMasterService.getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(noofclosetsnonresidential, PropertyType.NON_RESIDENTIAL);
        }
        if (propertyType != null && propertyType.equals((Object)PropertyType.MIXED) && residentialAmount != null && nonResidentialAmount != null) {
            legacyDonationAmount = residentialAmount.add(nonResidentialAmount);
        } else if (propertyType != null && propertyType.equals((Object)PropertyType.RESIDENTIAL) && residentialAmount != null) {
            legacyDonationAmount = residentialAmount;
        } else if (propertyType != null && propertyType.equals((Object)PropertyType.NON_RESIDENTIAL) && nonResidentialAmount != null) {
            legacyDonationAmount = nonResidentialAmount;
        } else {
            if (propertyType != null && residentialAmount == null && nonResidentialAmount == null) {
                return this.messageSource.getMessage("msg.validate.donationamount.notexistForBothcombination", (Object[])new String[]{propertyType.toString()}, null);
            }
            if (residentialAmount == null && noofclosetsresidential != null) {
                return this.messageSource.getMessage("msg.validate.donationamount.notexist", (Object[])new String[]{PropertyType.RESIDENTIAL.toString(), noofclosetsresidential.toString()}, null);
            }
            if (nonResidentialAmount == null && noofclosetsnonresidential != null) {
                return this.messageSource.getMessage("msg.validate.donationamount.notexist", (Object[])new String[]{PropertyType.NON_RESIDENTIAL.toString(), noofclosetsnonresidential.toString()}, null);
            }
        }
        return legacyDonationAmount.toString();
    }
}

