/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.stms.masters.entity.DonationDetailMaster;
import org.egov.stms.masters.entity.DonationMaster;
import org.egov.stms.masters.entity.SewerageRatesMaster;
import org.egov.stms.masters.service.DonationMasterService;
import org.egov.stms.masters.service.SewerageRatesMasterService;
import org.egov.stms.web.controller.utils.SewerageApplicationCommonValidator;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

@Component
public class SewerageMasterDataValidator
extends SewerageApplicationCommonValidator {
    private static final String NOTEMPTY_SEWERAGE_PROPERTYTYPE = "err.propertytype.required.validate";
    private static final String NOTEMPTY_SEWERAGE_FROMDATE = "notempty.sewerage.fromdate";
    private static final String NOTEMPTY_SEWERAGE_NOOFCLOSETS = "notempty.sewerage.noofclosets";
    private static final String NOTEMPTY_SEWERAGE_DONATIONAMT = "notempty.sewerage.donationamount";
    private static final Logger LOG = LoggerFactory.getLogger(SewerageMasterDataValidator.class);
    private static final String SEWERAGE_FROMDATE_LESSTHAN_CURRENTDATE = "err.validate.effective.date";
    private static final String SEWERAGE_FROMDATE_LESSTHAN_ACTIVEDATE = "err.fromdate.lessthan.activedate";
    private static final String SEWERAGE_NOOFCLOSETS_NONZERO = "err.numberofclosets.reject.0";
    private static final String SEWERAGE_NOOFCLOSETS_NONDUPLICATE = "err.validate.duplicatenoofclosets";
    private static final String FROMDATE = "fromDate";
    private static final String NOTEMPTY_SEWERAGE_MONTHLY_RATE = "notempty.sewerage.monthlyrate";
    SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
    SimpleDateFormat newFormat = new SimpleDateFormat("dd-MM-yyyy");
    @Autowired
    private DonationMasterService donationMasterService;
    @Autowired
    private SewerageRatesMasterService sewerageRatesMasterService;

    public void validateMonthlyRate(SewerageRatesMaster sewerageRatesMaster, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"propertyType", (String)NOTEMPTY_SEWERAGE_PROPERTYTYPE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)FROMDATE, (String)NOTEMPTY_SEWERAGE_FROMDATE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"monthlyRate", (String)NOTEMPTY_SEWERAGE_MONTHLY_RATE);
        try {
            if (sewerageRatesMaster.getFromDate() != null) {
                Date currentDate = this.newFormat.parse(this.newFormat.format(new Date()));
                List sewerageRateList = this.sewerageRatesMasterService.getLatestActiveRecord(sewerageRatesMaster.getPropertyType(), true);
                if (!sewerageRateList.isEmpty()) {
                    SewerageRatesMaster activeRecord = (SewerageRatesMaster)sewerageRateList.get(0);
                    this.validateSewerageRateFromDate(sewerageRatesMaster, errors, currentDate, activeRecord);
                }
            }
        }
        catch (ParseException e) {
            Log.error((Object)("Exception in parsing date " + e));
        }
    }

    private void validateSewerageRateFromDate(SewerageRatesMaster sewerageRatesMaster, Errors errors, Date currentDate, SewerageRatesMaster activeRecord) {
        if (activeRecord.getFromDate().compareTo(currentDate) <= 0 && sewerageRatesMaster.getFromDate().compareTo(currentDate) < 0) {
            errors.rejectValue(FROMDATE, SEWERAGE_FROMDATE_LESSTHAN_CURRENTDATE);
        } else if (activeRecord.getFromDate().compareTo(new Date()) >= 0 && sewerageRatesMaster.getFromDate().compareTo(activeRecord.getFromDate()) < 0) {
            errors.rejectValue(FROMDATE, SEWERAGE_FROMDATE_LESSTHAN_ACTIVEDATE, (Object[])new String[]{this.formatter.format(activeRecord.getFromDate())}, SEWERAGE_FROMDATE_LESSTHAN_ACTIVEDATE);
        }
    }

    public void validateSewerageMonthlyRateUpdate(SewerageRatesMaster sewerageRatesMaster, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"monthlyRate", (String)NOTEMPTY_SEWERAGE_MONTHLY_RATE);
    }

    public void validateDonationMaster(Errors errors, DonationMaster donationMaster) {
        ArrayList noOfClosetArray = new ArrayList();
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"propertyType", (String)NOTEMPTY_SEWERAGE_PROPERTYTYPE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)FROMDATE, (String)NOTEMPTY_SEWERAGE_FROMDATE);
        for (int i = 0; i < donationMaster.getDonationDetail().size(); ++i) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)("donationDetail[" + i + "].amount"), (String)NOTEMPTY_SEWERAGE_DONATIONAMT);
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)("donationDetail[" + i + "].noOfClosets"), (String)NOTEMPTY_SEWERAGE_NOOFCLOSETS);
        }
        if (donationMaster.getFromDate() != null) {
            try {
                Date currentDate = this.newFormat.parse(this.newFormat.format(new Date()));
                List donationList = this.donationMasterService.getLatestActiveRecordByPropertyTypeAndActive(donationMaster.getPropertyType(), true);
                if (!donationList.isEmpty()) {
                    this.validateDonationMasterFromDate(errors, donationMaster, this.newFormat, currentDate, donationList);
                }
                for (int i = 0; i < donationMaster.getDonationDetail().size(); ++i) {
                    this.validateNumberOfClosets(errors, donationMaster, noOfClosetArray, i);
                }
            }
            catch (ParseException e) {
                LOG.error("Parse Exception" + e);
            }
        }
    }

    public void validateDonationMasterUpdate(Errors errors, DonationMaster donationMaster) {
        ArrayList noOfClosetArray = new ArrayList();
        for (int i = 0; i < donationMaster.getDonationDetail().size(); ++i) {
            if (((DonationDetailMaster)donationMaster.getDonationDetail().get(i)).getNoOfClosets() == null) {
                errors.rejectValue("donationDetail[" + i + "].noOfClosets", NOTEMPTY_SEWERAGE_NOOFCLOSETS);
            }
            if (((DonationDetailMaster)donationMaster.getDonationDetail().get(i)).getAmount() == null) {
                errors.rejectValue("donationDetail[" + i + "].amount", NOTEMPTY_SEWERAGE_DONATIONAMT);
            }
            this.validateNumberOfClosets(errors, donationMaster, noOfClosetArray, i);
        }
    }

    private void validateNumberOfClosets(Errors errors, DonationMaster donationMaster, List<Integer> noOfClosetArray, int i) {
        if (((DonationDetailMaster)donationMaster.getDonationDetail().get(i)).getNoOfClosets() != null) {
            if (((DonationDetailMaster)donationMaster.getDonationDetail().get(i)).getNoOfClosets() == 0) {
                errors.rejectValue("donationDetail[" + i + "].noOfClosets", SEWERAGE_NOOFCLOSETS_NONZERO);
            } else if (noOfClosetArray.contains(((DonationDetailMaster)donationMaster.getDonationDetail().get(i)).getNoOfClosets())) {
                errors.rejectValue("donationDetail[" + i + "].noOfClosets", SEWERAGE_NOOFCLOSETS_NONDUPLICATE, (Object[])new String[]{((DonationDetailMaster)donationMaster.getDonationDetail().get(i)).getNoOfClosets().toString()}, null);
            } else {
                noOfClosetArray.add(((DonationDetailMaster)donationMaster.getDonationDetail().get(i)).getNoOfClosets());
            }
        }
    }

    private void validateDonationMasterFromDate(Errors errors, DonationMaster donationMaster, SimpleDateFormat formatter, Date currentDate, List<DonationMaster> donationList) {
        DonationMaster existingActiveRecord = donationList.get(0);
        if (existingActiveRecord.getFromDate().compareTo(currentDate) <= 0 && donationMaster.getFromDate().compareTo(currentDate) < 0) {
            errors.rejectValue(FROMDATE, SEWERAGE_FROMDATE_LESSTHAN_CURRENTDATE);
        } else if (existingActiveRecord.getFromDate().compareTo(new Date()) >= 0 && donationMaster.getFromDate().compareTo(existingActiveRecord.getFromDate()) < 0) {
            errors.rejectValue(FROMDATE, SEWERAGE_FROMDATE_LESSTHAN_ACTIVEDATE, (Object[])new String[]{formatter.format(existingActiveRecord.getFromDate())}, SEWERAGE_FROMDATE_LESSTHAN_ACTIVEDATE);
        }
    }
}

