/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.Installment;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.service.DonationMasterService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionEstimationDetails;
import org.egov.stms.transactions.entity.SewerageDemandDetail;
import org.egov.stms.transactions.entity.SewerageFieldInspection;
import org.egov.stms.transactions.entity.SewerageFieldInspectionDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.web.controller.utils.SewerageApplicationCommonValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

@Component
public class SewerageApplicationValidator
extends SewerageApplicationCommonValidator {
    private static final String NOTEMPTY_SEWERAGE_PROPERTYTYPE = "err.propertytype.required.validate";
    private static final String NOTEMPTY_SEWERAGE_PROPERTYID = "notempty.sewerage.propertyidentifier";
    private static final String RESIDENTIALCLOSETSREQUIRED = "err.noofclosetsresidential.required.validate";
    private static final String NONRESIDENTIALCLOSETSREQUIRED = "err.noofclosetsnonresidential.required.validate";
    private static final String CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL = "connectionDetail.noOfClosetsResidential";
    private static final String CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL = "connectionDetail.noOfClosetsNonResidential";
    private static final String SEWERAGE_NOOFCLOSETS_NONZERO = "err.numberofclosets.reject.0";
    private static final String NOTEMPTY_SEWERAGE_SHSC_NUMBER = "notempty.sewerage.shscnumber";
    private static final String NOTEMPTY_SEWERAGE_EXECUTION_DATE = "notempty.sewerage.executiondate";
    private static final String NOTEMPTY_DEMAND_AMOUNT_CURR_INSTALLMENT = "err.demandamount.emptynotallowed";
    private static final String NOTEMPTY_COLLECTION_AMOUNT_CURR_INSTALLMENT = "err.collectionamount.emptynotallowed";
    private static final String PROPERTY_IDENTIFIER_NOTEXISTS = "err.propertyidentifier.notexists";
    private static final String CONNECTIONDTL_PROPERTYTYPE = "connectionDetail.propertyType";
    private static final String CONNECTIONDTL_PROPERTYID_ISVALID = "err.connectionDetail.propertyIdentifier.validate";
    private static final String REJECTION_COMMENTS_REQUIRED = "err.application.reject.comments.required";
    private static final String NUMBEROFCLOSETS_INVALID = "err.numberofclosets.invalid";
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private DonationMasterService donationMasterService;

    public void validateSewerageNewApplication(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, HttpServletRequest request) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"connectionDetail.propertyIdentifier", (String)NOTEMPTY_SEWERAGE_PROPERTYID);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)CONNECTIONDTL_PROPERTYTYPE, (String)NOTEMPTY_SEWERAGE_PROPERTYTYPE);
        this.validatePropertyID(sewerageApplicationDetails, errors, request);
        if (sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null) {
            this.validateNumberOfClosets(errors, sewerageApplicationDetails);
        }
    }

    private void validateNumberOfClosets(Errors errors, SewerageApplicationDetails sewerageApplicationDetails) {
        if (sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null) {
            this.isNumberOfClosetsEntered(errors, sewerageApplicationDetails);
        }
        if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() != null && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() == 0) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, SEWERAGE_NOOFCLOSETS_NONZERO);
        }
        if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() != null && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() == 0) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL, SEWERAGE_NOOFCLOSETS_NONZERO);
        }
        this.checkNumberOfClosetsValid(errors, sewerageApplicationDetails);
    }

    private void isNumberOfClosetsEntered(Errors errors, SewerageApplicationDetails sewerageApplicationDetails) {
        if ("RESIDENTIAL".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() == null) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, RESIDENTIALCLOSETSREQUIRED);
        } else if ("NON_RESIDENTIAL".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() == null) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL, NONRESIDENTIALCLOSETSREQUIRED);
        } else if ("MIXED".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString())) {
            if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() == null && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() == null) {
                errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, RESIDENTIALCLOSETSREQUIRED);
                errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL, NONRESIDENTIALCLOSETSREQUIRED);
            } else if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() == null) {
                errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, RESIDENTIALCLOSETSREQUIRED);
            } else if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() == null) {
                errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL, NONRESIDENTIALCLOSETSREQUIRED);
            }
        }
    }

    private void checkNumberOfClosetsValid(Errors errors, SewerageApplicationDetails sewerageApplicationDetails) {
        String validationMessage;
        if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() != null && !(validationMessage = this.donationMasterService.checkClosetsPresentForGivenCombination(PropertyType.NON_RESIDENTIAL, sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential())).isEmpty()) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL, NUMBEROFCLOSETS_INVALID, (Object[])new String[]{sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential().toString()}, NUMBEROFCLOSETS_INVALID);
        }
        if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() != null && !(validationMessage = this.donationMasterService.checkClosetsPresentForGivenCombination(PropertyType.RESIDENTIAL, sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential())).isEmpty()) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, NUMBEROFCLOSETS_INVALID, (Object[])new String[]{sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential().toString()}, NUMBEROFCLOSETS_INVALID);
        }
    }

    public void validatePropertyID(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, HttpServletRequest request) {
        if (sewerageApplicationDetails.getConnectionDetail() != null && sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() != null && !"".equals(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier())) {
            String errorMessage = this.sewerageApplicationDetailsService.checkValidPropertyAssessmentNumber(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
            if (errorMessage != null && !errorMessage.equals("")) {
                errors.reject(CONNECTIONDTL_PROPERTYID_ISVALID, (Object[])new String[]{errorMessage}, null);
            } else {
                errorMessage = this.sewerageApplicationDetailsService.checkConnectionPresentForProperty(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
                if (errorMessage != null && !"".equals(errorMessage)) {
                    errors.reject(CONNECTIONDTL_PROPERTYID_ISVALID, (Object[])new String[]{errorMessage}, null);
                } else {
                    this.checkWaterTaxDue(sewerageApplicationDetails, errors, request);
                }
            }
        }
    }

    public void validateNewApplicationUpdate(SewerageApplicationDetails sewerageApplicationDetails, BindingResult errors, String workFlowAction) {
        if ((sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INITIALAPPROVED") || sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INSPECTIONFEEPAID")) && "Reject".equalsIgnoreCase(workFlowAction) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sewerageApplicationDetails.getApprovalComent())) {
            errors.reject(REJECTION_COMMENTS_REQUIRED);
        }
        if (("REJECTED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "ESTIMATIONAMOUNTPAID".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) && workFlowAction.equalsIgnoreCase("Cancel") && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sewerageApplicationDetails.getApprovalComent())) {
            errors.reject("err.application.cancel.comments.required");
        }
        if (sewerageApplicationDetails.getConnectionDetail().getPropertyType() == null) {
            errors.reject(NOTEMPTY_SEWERAGE_PROPERTYTYPE);
        } else {
            this.validateNumberOfClosets((Errors)errors, sewerageApplicationDetails);
        }
        if (sewerageApplicationDetails.getConnectionDetail() != null && sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null) {
            this.validateDonationAmount(sewerageApplicationDetails, (Errors)errors);
        }
        this.validateFieldInspectionDetails(sewerageApplicationDetails, (Errors)errors);
        this.validateEstimationDetails(sewerageApplicationDetails, (Errors)errors);
    }

    private void validateDonationAmount(SewerageApplicationDetails sewerageApplicationDetails, Errors errors) {
        if ("RESIDENTIAL".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() != null) {
            this.getDonationAmount(sewerageApplicationDetails, errors);
        }
        if ("NON_RESIDENTIAL".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() != null) {
            this.getDonationAmount(sewerageApplicationDetails, errors);
        }
        if ("MIXED".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() != null && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() != null) {
            this.getDonationAmount(sewerageApplicationDetails, errors);
        }
    }

    private void validateEstimationDetails(SewerageApplicationDetails sewerageApplicationDetails, Errors errors) {
        if (!sewerageApplicationDetails.getEstimationDetailsForUpdate().isEmpty()) {
            boolean mandatoryValueEntered = false;
            boolean mandatoryValueNotEntered = false;
            List estimationDetailList = sewerageApplicationDetails.getEstimationDetailsForUpdate();
            for (SewerageConnectionEstimationDetails estimationDetail : estimationDetailList) {
                if (estimationDetail.getUnitOfMeasurement() != null || estimationDetail.getItemDescription() != null && estimationDetail.getQuantity() != 0.0 || estimationDetail.getQuantity() != null && estimationDetail.getQuantity() != 0.0 || estimationDetail.getUnitRate() != null && estimationDetail.getUnitRate() != 0.0 || estimationDetail.getAmount() != null && estimationDetail.getAmount().intValue() != 0) {
                    mandatoryValueEntered = true;
                }
                if (estimationDetail.getUnitOfMeasurement() == null || estimationDetail.getItemDescription() == null || estimationDetail.getQuantity() == null || estimationDetail.getQuantity() == 0.0 || estimationDetail.getUnitRate() == null || estimationDetail.getUnitRate() == 0.0 || estimationDetail.getAmount() == null || estimationDetail.getAmount().intValue() == 0) {
                    mandatoryValueNotEntered = true;
                }
                if (!mandatoryValueEntered || !mandatoryValueNotEntered) continue;
                errors.reject("err.estimationdetails.mandatory.validate");
            }
        }
    }

    private void validateFieldInspectionDetails(SewerageApplicationDetails sewerageApplicationDetails, Errors errors) {
        if (!sewerageApplicationDetails.getFieldInspections().isEmpty() && !((SewerageFieldInspection)sewerageApplicationDetails.getFieldInspections().get(0)).getFieldInspectionDetailsForUpdate().isEmpty()) {
            boolean mandatoryValueEntered = false;
            boolean mandatoryValueNotEntered = false;
            List inspectionDetailList = ((SewerageFieldInspection)sewerageApplicationDetails.getFieldInspections().get(0)).getFieldInspectionDetailsForUpdate();
            for (SewerageFieldInspectionDetails inspectionDetail : inspectionDetailList) {
                if (inspectionDetail.getScrewSize() != null || inspectionDetail.getPipeSize() != null || inspectionDetail.getPipeLength() != null && inspectionDetail.getPipeLength() != 0.0 || inspectionDetail.getNoOfPipes() != null && inspectionDetail.getNoOfPipes() != 0 || inspectionDetail.getNoOfScrews() != null && inspectionDetail.getNoOfScrews() != 0 || inspectionDetail.getDistance() != null && inspectionDetail.getDistance() != 0.0) {
                    mandatoryValueEntered = true;
                }
                if (inspectionDetail.getScrewSize() == null || inspectionDetail.getPipeSize() == null || inspectionDetail.getPipeLength() == null || inspectionDetail.getPipeLength() == 0.0 || inspectionDetail.getNoOfPipes() == null || inspectionDetail.getNoOfPipes() == 0 || inspectionDetail.getNoOfScrews() == null || inspectionDetail.getNoOfScrews() == 0 || inspectionDetail.getDistance() == null || inspectionDetail.getDistance() == 0.0) {
                    mandatoryValueNotEntered = true;
                }
                if (!mandatoryValueEntered || !mandatoryValueNotEntered) continue;
                errors.reject("err.pipedetails.mandatory.validate");
            }
        }
    }

    public void getDonationAmount(SewerageApplicationDetails sewerageApplicationDetails, Errors errors) {
        String legacyDonationAmount = this.getDonationAmount(sewerageApplicationDetails.getConnectionDetail().getPropertyType(), sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential(), sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential());
        if (legacyDonationAmount == null) {
            errors.reject("err.donationamount.notexists");
        }
    }

    public void validateChangeInClosetsApplication(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, HttpServletRequest request) {
        String errorMessage;
        if (sewerageApplicationDetails.getConnectionDetail().getPropertyType() == null) {
            errors.rejectValue(CONNECTIONDTL_PROPERTYTYPE, NOTEMPTY_SEWERAGE_PROPERTYTYPE);
        } else {
            this.validateNumberOfClosets(errors, sewerageApplicationDetails);
        }
        if (sewerageApplicationDetails.getConnectionDetail() != null && sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() != null && !sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier().equals("") && (errorMessage = this.sewerageApplicationDetailsService.checkValidPropertyAssessmentNumber(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier())) != null && !errorMessage.equals("")) {
            errors.reject(CONNECTIONDTL_PROPERTYID_ISVALID, (Object[])new String[]{errorMessage}, null);
        }
        this.checkWaterTaxDue(sewerageApplicationDetails, errors, request);
    }

    public void validateChangeInClosetsUpdateApplication(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, String workFlowAction) {
        if (("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) && "Cancel".equalsIgnoreCase(workFlowAction) && StringUtils.isBlank((String)sewerageApplicationDetails.getApprovalComent())) {
            errors.reject("err.application.cancel.comments.required");
        }
        if (("INSPECTIONFEEPAID".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "INITIALAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) && "Reject".equalsIgnoreCase(workFlowAction) && StringUtils.isBlank((String)sewerageApplicationDetails.getApprovalComent())) {
            errors.reject(REJECTION_COMMENTS_REQUIRED);
        }
        if (workFlowAction != null && "Execute Connection".equalsIgnoreCase(workFlowAction)) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            if (sewerageApplicationDetails.getConnection().getExecutionDate() == null) {
                errors.rejectValue("connection.executionDate", "err.executiondate.required.validate");
            } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)sewerageApplicationDetails.getConnection().getExecutionDate().toString())) {
                formatter.format(sewerageApplicationDetails.getConnection().getExecutionDate());
                if (sewerageApplicationDetails.getConnection().getExecutionDate().compareTo(sewerageApplicationDetails.getApplicationDate()) < 0) {
                    errors.reject("err.connectionexecution.date.validate", (Object[])new String[]{formatter.format(sewerageApplicationDetails.getApplicationDate())}, "err.connectionexecution.date.validate");
                }
            }
        }
        if (sewerageApplicationDetails.getConnectionDetail().getPropertyType() == null) {
            errors.rejectValue(CONNECTIONDTL_PROPERTYTYPE, NOTEMPTY_SEWERAGE_PROPERTYTYPE);
        } else {
            this.validateNumberOfClosets(errors, sewerageApplicationDetails);
        }
        if (sewerageApplicationDetails.getConnectionDetail() != null && sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null) {
            this.validateDonationAmount(sewerageApplicationDetails, errors);
        }
        this.validateFieldInspectionDetails(sewerageApplicationDetails, errors);
        this.validateEstimationDetails(sewerageApplicationDetails, errors);
    }

    public void validateLegacyData(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, HttpServletRequest request) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"connection.shscNumber", (String)NOTEMPTY_SEWERAGE_SHSC_NUMBER);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"connection.executionDate", (String)NOTEMPTY_SEWERAGE_EXECUTION_DATE);
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)CONNECTIONDTL_PROPERTYTYPE, (String)NOTEMPTY_SEWERAGE_PROPERTYTYPE);
        if (sewerageApplicationDetails.getConnection().getShscNumber() != null && sewerageApplicationDetails.getConnection().getShscNumber().length() != 10) {
            errors.rejectValue("connection.shscNumber", "err.shscnumber.length.validate", null);
        }
        if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() != null && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() == 0 || sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() != null && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() == 0) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, SEWERAGE_NOOFCLOSETS_NONZERO, null);
        }
        if (sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null) {
            this.isNumberOfClosetsPresent(sewerageApplicationDetails, errors);
        }
        this.validatePropertyAndConnection(errors, request, sewerageApplicationDetails);
        this.validateDemandBeanList(sewerageApplicationDetails, errors);
        this.validateDonationAmount(errors, sewerageApplicationDetails);
    }

    public void isNumberOfClosetsPresent(SewerageApplicationDetails sewerageApplicationDetails, Errors errors) {
        if ("RESIDENTIAL".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() == null) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, RESIDENTIALCLOSETSREQUIRED);
        } else if ("NON_RESIDENTIAL".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() == null) {
            errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL, NONRESIDENTIALCLOSETSREQUIRED);
        } else if ("MIXED".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString())) {
            if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() == null && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() == null) {
                errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, RESIDENTIALCLOSETSREQUIRED);
                errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL, NONRESIDENTIALCLOSETSREQUIRED);
            } else if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() == null) {
                errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_RESIDENTIAL, RESIDENTIALCLOSETSREQUIRED);
            } else if (sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() == null) {
                errors.rejectValue(CONNECTIONDTL_NOOFCLOSETS_NONRESIDENTIAL, NONRESIDENTIALCLOSETSREQUIRED);
            }
        }
    }

    private void validatePropertyAndConnection(Errors errors, HttpServletRequest request, SewerageApplicationDetails sewerageApplicationDetails) {
        String result;
        AssessmentDetails details = this.sewerageThirdPartyServices.getPropertyDetails(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), request);
        if (details != null && details.getErrorDetails().getErrorMessage() != null) {
            errors.rejectValue("connectionDetail.propertyIdentifier", PROPERTY_IDENTIFIER_NOTEXISTS, null);
        }
        if ((result = this.sewerageApplicationDetailsService.isConnectionExistsForProperty(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier())) != null && result != "") {
            errors.reject("err.connection.alreadyexists");
        }
    }

    public void validateDemandBeanList(SewerageApplicationDetails sewerageApplicationDetails, Errors errors) {
        boolean isEnterDemandValue = false;
        Installment installment = this.sewerageDemandService.getCurrentInstallment();
        for (int i = 0; i < sewerageApplicationDetails.getDemandDetailBeanList().size(); ++i) {
            SewerageDemandDetail sewerageDD = (SewerageDemandDetail)sewerageApplicationDetails.getDemandDetailBeanList().get(i);
            if (sewerageDD.getActualCollection() != null && BigDecimal.ZERO != sewerageDD.getActualCollection() && sewerageDD.getActualAmount() == null) {
                errors.rejectValue("demandDetailBeanList[" + i + "].actualAmount", "err.demandamountforenteredcollectionamount.validate", (Object[])new String[]{sewerageDD.getInstallment()}, null);
            }
            if (sewerageDD.getActualAmount() != null) {
                isEnterDemandValue = true;
            }
            if (sewerageDD.getActualCollection() != null && sewerageDD.getActualAmount() != null && sewerageDD.getActualCollection().compareTo(sewerageDD.getActualAmount()) > 0) {
                errors.rejectValue("demandDetailBeanList[" + i + "].actualCollection", "err.demandamount.collectedamount.validate", (Object[])new String[]{sewerageDD.getInstallment()}, null);
            }
            if (isEnterDemandValue && sewerageDD.getActualAmount() == null) {
                errors.rejectValue("demandDetailBeanList[" + i + "].actualAmount", "err.demandamountforintermediateinstallments.required", (Object[])new String[]{sewerageDD.getInstallment()}, null);
            }
            if (!sewerageDD.getInstallment().equals(installment.toString())) continue;
            if (sewerageDD.getActualAmount() == null || sewerageDD.getActualAmount() == BigDecimal.ZERO) {
                errors.rejectValue("demandDetailBeanList[" + i + "].actualAmount", NOTEMPTY_DEMAND_AMOUNT_CURR_INSTALLMENT, (Object[])new String[]{sewerageDD.getInstallment()}, null);
            }
            if (sewerageDD.getActualCollection() != null && sewerageDD.getActualCollection() != BigDecimal.ZERO) continue;
            errors.rejectValue("demandDetailBeanList[" + i + "].actualCollection", NOTEMPTY_COLLECTION_AMOUNT_CURR_INSTALLMENT, (Object[])new String[]{sewerageDD.getInstallment()}, null);
        }
    }

    private void validateDonationAmount(Errors errors, SewerageApplicationDetails sewerageApplicationDetails) {
        if (sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null) {
            if ("RESIDENTIAL".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() != null) {
                this.getDonationAmount(sewerageApplicationDetails, errors);
            } else if ("NON_RESIDENTIAL".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() != null) {
                this.getDonationAmount(sewerageApplicationDetails, errors);
            } else if ("MIXED".equalsIgnoreCase(sewerageApplicationDetails.getConnectionDetail().getPropertyType().toString()) && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential() != null && sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential() != null) {
                this.getDonationAmount(sewerageApplicationDetails, errors);
            }
        }
    }

    public void validateClosureApplication(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, HttpServletRequest request) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sewerageApplicationDetails.getCloseConnectionReason())) {
            errors.rejectValue("closeConnectionReason", "err.closeconnection.remarks");
        }
        this.validatePropertyIdAndWaterTaxDue(sewerageApplicationDetails, errors, request);
    }

    public void validatePropertyIdAndWaterTaxDue(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, HttpServletRequest request) {
        if (sewerageApplicationDetails.getConnectionDetail() != null && sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() != null && !sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier().equals("")) {
            String errorMessage = this.sewerageApplicationDetailsService.checkValidPropertyAssessmentNumber(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
            if (errorMessage != null && !errorMessage.equals("")) {
                errors.reject(CONNECTIONDTL_PROPERTYID_ISVALID, (Object[])new String[]{errorMessage}, null);
            } else {
                this.checkWaterTaxDue(sewerageApplicationDetails, errors, request);
            }
        }
    }

    private void checkWaterTaxDue(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, HttpServletRequest request) {
        HashMap result = this.sewerageThirdPartyServices.getWaterTaxDueAndCurrentTax(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier(), request);
        BigDecimal waterTaxDue = (BigDecimal)result.get("WATERTAXDUE");
        String consumerCode = result.get("CONSUMERCODE").toString();
        if (consumerCode != "" && consumerCode != null) {
            consumerCode = consumerCode.substring(1, consumerCode.length() - 1);
        }
        if (waterTaxDue.compareTo(BigDecimal.ZERO) > 0) {
            String errorMessage = "Property tax Assessment number " + sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() + " linked water tap connection demand with Consumer code:" + consumerCode + " is due Rs." + waterTaxDue + "/- . Please clear demand and proceed";
            errors.reject(CONNECTIONDTL_PROPERTYID_ISVALID, (Object[])new String[]{errorMessage}, null);
        }
    }

    public void validateUpdateClosureApplication(SewerageApplicationDetails sewerageApplicationDetails, Errors errors, String workFlowAction) {
        if (("INITIALAPPROVED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode()) || "CREATED".equalsIgnoreCase(sewerageApplicationDetails.getStatus().getCode())) && "Reject".equalsIgnoreCase(workFlowAction) && StringUtils.isBlank((String)sewerageApplicationDetails.getApprovalComent())) {
            errors.reject(REJECTION_COMMENTS_REQUIRED);
        }
        if (StringUtils.isBlank((String)sewerageApplicationDetails.getCloseConnectionReason()) && "Forward".equalsIgnoreCase(workFlowAction)) {
            errors.reject("err.closeconnection.remarks");
        }
    }
}

