/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageTaxUtils;
import org.egov.stms.web.controller.utils.SewerageApplicationValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageCloseUpdateConnectionController
extends GenericWorkFlowController {
    private static final Logger LOGGER = Logger.getLogger(SewerageCloseUpdateConnectionController.class);
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    @Autowired
    private SewerageApplicationValidator sewerageApplicationValidator;

    @ModelAttribute(value="sewerageApplicationDetails")
    public SewerageApplicationDetails getSewerageApplicationDetails(@PathVariable String applicationNumber) {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        return sewerageApplicationDetails;
    }

    @RequestMapping(value={"/closeSewerageConnection-update/{applicationNumber}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String applicationNumber, HttpServletRequest request) {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        model.addAttribute("sewerageApplcationDetails", (Object)sewerageApplicationDetails);
        AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(sewerageApplicationDetails.getConnection().getShscNumber(), request);
        if (propertyOwnerDetails != null) {
            model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
        model.addAttribute("sewerageApplicationDetails", (Object)sewerageApplicationDetails);
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("currentState", (Object)sewerageApplicationDetails.getCurrentState().getValue());
        WorkflowContainer container = new WorkflowContainer();
        container.setAdditionalRule(sewerageApplicationDetails.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, container);
        model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        List docList = this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails);
        model.addAttribute("documentNamesList", (Object)docList);
        return "closeSewerageConnection";
    }

    @RequestMapping(value={"/closeSewerageConnection-update/{applicationNumber}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, HttpSession session, Model model, @RequestParam String workFlowAction, @RequestParam(value="files") MultipartFile[] files, HttpServletResponse response) throws Exception {
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        this.sewerageApplicationValidator.validateUpdateClosureApplication(sewerageApplicationDetails, (Errors)resultBinder, workFlowAction);
        if (resultBinder.hasErrors()) {
            WorkflowContainer container = new WorkflowContainer();
            model.addAttribute("sewerageApplicationDetails", (Object)sewerageApplicationDetails);
            AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(sewerageApplicationDetails.getConnection().getShscNumber(), request);
            if (propertyOwnerDetails != null) {
                model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
            }
            model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
            model.addAttribute("sewerageApplicationDetails", (Object)sewerageApplicationDetails);
            model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
            model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            model.addAttribute("currentState", (Object)sewerageApplicationDetails.getCurrentState().getValue());
            container.setAdditionalRule(sewerageApplicationDetails.getApplicationType().getCode());
            this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, container);
            model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
            model.addAttribute("propertyTypes", (Object)PropertyType.values());
            List docList = this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails);
            model.addAttribute("documentNamesList", (Object)docList);
            return "closeSewerageConnection";
        }
        try {
            SewerageApplicationDetails parentSewerageAppDtls;
            if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Approve") && (parentSewerageAppDtls = this.sewerageApplicationDetailsService.findByConnection_ShscNumberAndIsActive(sewerageApplicationDetails.getConnection().getShscNumber())) != null) {
                parentSewerageAppDtls.setActive(false);
                sewerageApplicationDetails.setParent(parentSewerageAppDtls);
            }
            this.sewerageApplicationDetailsService.updateCloseSewerageApplicationDetails(sewerageApplicationDetails, approvalPosition, approvalComment, sewerageApplicationDetails.getApplicationType().getCode(), workFlowAction, null, request, session);
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getMessage());
        }
        if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Generate Close Connection Notice") && sewerageApplicationDetails.getClosureNoticeNumber() != null) {
            return "redirect:/transactions/viewcloseconnectionnotice/" + sewerageApplicationDetails.getApplicationNumber() + "?closureNoticeNumber=" + sewerageApplicationDetails.getClosureNoticeNumber();
        }
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        String nextDesign = "";
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition == null || approvalPosition == 0L) {
            approvalPosition = this.assignmentService.getPrimaryAssignmentForUser(sewerageApplicationDetails.getCreatedBy().getId()).getPosition().getId();
        }
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        nextDesign = asignList != null && !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = sewerageApplicationDetails.getApplicationNumber() + "," + this.sewerageTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        return "redirect:/transactions/closeConnection-success?pathVars=" + pathVars;
    }

    @RequestMapping(value={"/viewcloseconnectionnotice/{applicationNumber}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> viewCloseConnectionNotice(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpSession session, HttpServletResponse response, HttpServletRequest request) {
        ReportOutput reportOutput = new ReportOutput();
        HttpHeaders headers = new HttpHeaders();
        SewerageNotice sewerageNotice = null;
        File file = null;
        FileStoreMapper fmp = null;
        String closureNoticeNumber = request.getParameter("closureNoticeNumber");
        if (closureNoticeNumber != null) {
            sewerageNotice = this.sewerageNoticeService.findByNoticeNoAndNoticeType(closureNoticeNumber, "Close Connection Notice");
        }
        if (sewerageNotice != null) {
            fmp = sewerageNotice.getFileStore();
        }
        if (fmp != null) {
            file = this.fileStoreService.fetch(fmp, "STMS");
        }
        try {
            if (file != null) {
                reportOutput.setReportOutputData(FileUtils.readFileToByteArray((File)file));
            }
            reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Exception while generating close connection notice", (Throwable)ioe);
            throw new ValidationException(ioe.getMessage());
        }
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=CloseConnectionNotice.pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

