/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.stms.reports.entity.SewerageNoOfConnReportResult;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.utils.SewerageConnectionHelperAdopter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageConnReportSearchController {
    private static final Logger LOG = Logger.getLogger(SewerageConnReportSearchController.class);
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageIndexService sewerageIndexService;

    @ModelAttribute(value="ward")
    public List<Boundary> getBoundary() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute(value="localities")
    public List<Boundary> getLocalities() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
    }

    @ModelAttribute
    public void getReportHelper(Model model) {
        SewerageNoOfConnReportResult sewerageReportResult = new SewerageNoOfConnReportResult();
        model.addAttribute("sewerageReportResult", (Object)sewerageReportResult);
    }

    @RequestMapping(value={"/search-no-of-application"}, method={RequestMethod.GET})
    public String getNoOfConnections(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        return "sewerage-connection-report-search";
    }

    @RequestMapping(value={"/view-no-of-application"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public void viewSewerageConnections(@RequestParam(value="ward") String ward, @RequestParam(value="block") String block, @RequestParam(value="locality") String locality, HttpServletRequest request, HttpServletResponse response) {
        block3: {
            String wardName = null;
            if (ward != null) {
                Boundary boundary = this.boundaryService.getBoundaryById(Long.valueOf(ward));
                wardName = boundary.getName();
            }
            List reportList = this.sewerageIndexService.searchNoOfApplnQuery(wardName, block, locality);
            String result = "{ \"data\":" + JsonUtils.toJSON((Collection)reportList, SewerageNoOfConnReportResult.class, SewerageConnectionHelperAdopter.class) + "}";
            response.setContentType("application/json");
            try {
                IOUtils.write((String)result, (Writer)response.getWriter());
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.error((Object)("IO Exception " + e));
            }
        }
    }
}

