/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.elasticSearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.elasticSearch.entity.SewerageConnSearchRequest;
import org.egov.stms.elasticSearch.entity.SewerageSearchResult;
import org.egov.stms.entity.es.SewerageIndex;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageActionDropDownUtil;
import org.egov.stms.utils.SewerageTaxUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/existing/sewerage"})
public class ApplicationSewerageSearchController {
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SewerageIndexService sewerageIndexService;

    @ModelAttribute
    public SewerageConnSearchRequest searchRequest() {
        return new SewerageConnSearchRequest();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        return "sewerageTaxSearch-form";
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @RequestMapping(value={"/view/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public ModelAndView view(@PathVariable String consumernumber, @PathVariable String assessmentnumber, Model model, ModelMap modelMap, @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request) {
        AssessmentDetails propertyOwnerDetails;
        if (consumernumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber);
        }
        if ((propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request)) != null) {
            modelMap.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        model.addAttribute("applicationHistory", (Object)this.sewerageApplicationDetailsService.getHistory(sewerageApplicationDetails));
        model.addAttribute("documentNamesList", (Object)this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails));
        return new ModelAndView("viewseweragedetails", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<SewerageSearchResult> searchApplication(@ModelAttribute SewerageConnSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        if (cityWebsite != null) {
            searchRequest.setUlbName(cityWebsite.getName());
        }
        BoolQueryBuilder boolQuery = this.sewerageIndexService.getQueryFilter(searchRequest);
        ArrayList<SewerageSearchResult> searchResultFomatted = new ArrayList<SewerageSearchResult>();
        SewerageApplicationDetails sewerageApplicationDetails = null;
        SewerageSearchResult searchActions = null;
        HashMap actionMap = new HashMap();
        ArrayList<String> roleList = new ArrayList<String>();
        for (Role userRole : this.sewerageTaxUtils.getLoginUserRoles()) {
            roleList.add(userRole.getName());
        }
        FieldSortBuilder sort = new FieldSortBuilder("shscNumber").order(SortOrder.DESC);
        List searchResult = this.sewerageIndexService.getSearchResultByBoolQuery(boolQuery, sort);
        for (SewerageIndex sewerageIndexObject : searchResult) {
            SewerageSearchResult searchResultObject = new SewerageSearchResult();
            searchResultObject.setApplicationNumber(sewerageIndexObject.getApplicationNumber());
            searchResultObject.setAssessmentNumber(sewerageIndexObject.getPropertyIdentifier());
            searchResultObject.setShscNumber(sewerageIndexObject.getShscNumber());
            searchResultObject.setApplicantName(sewerageIndexObject.getConsumerName());
            searchResultObject.setApplicationType(sewerageIndexObject.getApplicationType());
            searchResultObject.setPropertyType(sewerageIndexObject.getPropertyType().replace("_", " "));
            searchResultObject.setRevenueWard(sewerageIndexObject.getWard());
            searchResultObject.setAddress(sewerageIndexObject.getAddress());
            searchResultObject.setApplicationStatus(sewerageIndexObject.getApplicationStatus());
            if (sewerageIndexObject.getApplicationNumber() != null) {
                sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(sewerageIndexObject.getApplicationNumber());
            }
            if (sewerageApplicationDetails != null) {
                searchActions = SewerageActionDropDownUtil.getSearchResultWithActions(roleList, (String)sewerageIndexObject.getApplicationStatus(), (SewerageApplicationDetails)sewerageApplicationDetails);
            }
            if (searchActions != null && searchActions.getActions() != null) {
                this.getActions(searchActions, actionMap);
            }
            searchResultObject.setActions(actionMap);
            searchResultFomatted.add(searchResultObject);
        }
        return searchResultFomatted;
    }

    private void getActions(SewerageSearchResult searchActions, Map<String, String> actionMap) {
        for (Map.Entry entry : searchActions.getActions().entrySet()) {
            if (((String)entry.getValue()).equals("Collect Fee")) continue;
            actionMap.put((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

