/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.utils;

import java.math.BigDecimal;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.service.DonationMasterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class SewerageApplicationCommonValidator
implements Validator {
    @Autowired
    private DonationMasterService donationMasterService;

    public boolean supports(Class<?> clazz) {
        return SewerageApplicationCommonValidator.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
    }

    public String getDonationAmount(PropertyType propertyType, Integer noofclosetsresidential, Integer noofclosetsnonresidential) {
        BigDecimal donationAmount = BigDecimal.ZERO;
        BigDecimal residentialAmount = BigDecimal.ZERO;
        BigDecimal nonResidentialAmount = BigDecimal.ZERO;
        if (noofclosetsresidential != null && noofclosetsresidential != 0) {
            residentialAmount = this.donationMasterService.getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(noofclosetsresidential, PropertyType.RESIDENTIAL);
        }
        if (noofclosetsnonresidential != null && noofclosetsnonresidential != 0) {
            nonResidentialAmount = this.donationMasterService.getDonationAmountByNoOfClosetsAndPropertytypeForCurrentDate(noofclosetsnonresidential, PropertyType.NON_RESIDENTIAL);
        }
        if (propertyType != null && propertyType.equals((Object)PropertyType.MIXED) && residentialAmount != null && nonResidentialAmount != null) {
            donationAmount = residentialAmount.add(nonResidentialAmount);
        } else if (propertyType != null && propertyType.equals((Object)PropertyType.RESIDENTIAL) && residentialAmount != null) {
            donationAmount = residentialAmount;
        } else if (propertyType != null && propertyType.equals((Object)PropertyType.NON_RESIDENTIAL) && nonResidentialAmount != null) {
            donationAmount = nonResidentialAmount;
        } else if (propertyType != null && (residentialAmount == null && nonResidentialAmount == null || residentialAmount == null && noofclosetsresidential != null || nonResidentialAmount == null && noofclosetsnonresidential != null)) {
            return null;
        }
        return donationAmount.toString();
    }
}

