/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.JsonUtils;
import org.egov.stms.entity.SewerageDemandGenerationLog;
import org.egov.stms.entity.SewerageTaxBatchDemandGenerate;
import org.egov.stms.transactions.entity.SewerageDemandStatusDetails;
import org.egov.stms.transactions.entity.SewerageDemandStatusResponse;
import org.egov.stms.transactions.service.SewerageBatchDemandGenService;
import org.egov.stms.transactions.service.SewerageDemandGenerationLogService;
import org.egov.stms.web.adapter.SewerageDemandResponseStatusAdapter;
import org.egov.stms.web.adapter.SewerageDemandStatusDetailsAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageDemandGenerationController {
    private static final String SEWERAGE_TAX_MANAGEMENT = "Sewerage Tax Management";
    private static final String DEMAND_STATUS_FORM = "sewerage-demand-status";
    private static final String DATA = "{\"data\":";
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private SewerageBatchDemandGenService sewerageBatchDemandGenService;
    @Autowired
    private SewerageDemandGenerationLogService sewerageDemandGenerationLogService;

    @ModelAttribute(value="financialYear")
    public List<Installment> financialyear(Installment installment) throws ParseException {
        List installmentList = this.installmentDao.fetchPreviousInstallmentsInDescendingOrderByModuleAndDate(this.moduleService.getModuleByName(SEWERAGE_TAX_MANAGEMENT), new Date(), 1);
        if (installmentList != null && !installmentList.isEmpty()) {
            return this.installmentDao.fetchNextInstallmentsByModuleAndDate(this.moduleService.getModuleByName(SEWERAGE_TAX_MANAGEMENT), ((Installment)installmentList.get(0)).getFromDate());
        }
        return installmentList;
    }

    @RequestMapping(value={"/generatedemand"}, method={RequestMethod.GET})
    public String search(Model model, @ModelAttribute SewerageDemandStatusDetails sewerageDemandStatusDetails) {
        return "seweragedemand-generate";
    }

    @RequestMapping(value={"/generatedemand"}, method={RequestMethod.POST})
    public String generateDemand(Model model, @ModelAttribute SewerageDemandStatusDetails sewerageDemandStatusDetails, RedirectAttributes redirectAttributes, BindingResult resultBinder) {
        if (sewerageDemandStatusDetails.getFinancialYear() == null) {
            return "seweragedemand-generate";
        }
        Installment installment = this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName(SEWERAGE_TAX_MANAGEMENT), sewerageDemandStatusDetails.getFinancialYear());
        if (installment != null) {
            SewerageTaxBatchDemandGenerate sewerageBatchDemandGenerate = new SewerageTaxBatchDemandGenerate();
            sewerageBatchDemandGenerate.setActive(Boolean.valueOf(true));
            sewerageBatchDemandGenerate.setInstallment(installment);
            sewerageBatchDemandGenerate.setJobName("Generate Demand For " + installment.getDescription());
            this.sewerageBatchDemandGenService.createSewerageTaxBatchDemandGenerate(sewerageBatchDemandGenerate);
        }
        redirectAttributes.addFlashAttribute("message", (Object)"msg.demand.Scheduled");
        model.addAttribute("sewerageDemandStatusDetails", (Object)sewerageDemandStatusDetails);
        return "generate-success";
    }

    @RequestMapping(value={"/seweragedemand-status"}, method={RequestMethod.GET})
    public String viewDemand(@ModelAttribute SewerageDemandStatusDetails sewerageDemandStatusDetails) {
        return DEMAND_STATUS_FORM;
    }

    @RequestMapping(value={"/seweragedemand-status"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getDemandGenerationStatus(@ModelAttribute SewerageDemandStatusDetails sewerageDemandStatusDetails, @RequestParam String financialYear, HttpServletRequest request) {
        List generationLogList;
        ArrayList<SewerageDemandStatusDetails> resultList = new ArrayList<SewerageDemandStatusDetails>();
        if (financialYear != null && (generationLogList = this.sewerageDemandGenerationLogService.getDemandGenerationLogListByInstallmentYear(financialYear)) != null && !generationLogList.isEmpty()) {
            SewerageDemandStatusDetails demandStatus = this.sewerageDemandGenerationLogService.getDemandStatusResult(generationLogList);
            demandStatus.setFinancialYear(financialYear);
            resultList.add(demandStatus);
        }
        return DATA + JsonUtils.toJSON(resultList, SewerageDemandStatusDetails.class, SewerageDemandStatusDetailsAdapter.class) + "}";
    }

    @RequestMapping(value={"/seweragedemand-status-records-view/{financialYear}"}, method={RequestMethod.GET})
    public String viewDemandStatusOfRecords(@ModelAttribute SewerageDemandStatusDetails sewerageDemandStatusDetails, @PathVariable String financialYear, Model model) {
        model.addAttribute("financialYear", (Object)financialYear);
        return "seweragestatus-view";
    }

    @RequestMapping(value={"/seweragedemand-status-records-view/"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String viewDemandStatus(@RequestParam(value="financialyear") String financialyear, Model model) {
        ArrayList outputList = new ArrayList();
        ArrayList detailList = new ArrayList();
        if (financialyear != null) {
            String[] inputArray = financialyear.split("~");
            boolean val = false;
            if (inputArray[0].contains("0")) {
                val = true;
            }
            List demandGenLogList = this.sewerageDemandGenerationLogService.getDemandGenerationLogListByInstallmentYear(inputArray[1]);
            for (SewerageDemandGenerationLog generationLog : demandGenLogList) {
                List logDetailList = generationLog.getDetails();
                if (logDetailList == null || logDetailList.isEmpty()) continue;
                List resultList = this.sewerageDemandGenerationLogService.getLogDetailResultList(logDetailList, generationLog, detailList, val);
                outputList.addAll(resultList);
            }
        }
        return DATA + JsonUtils.toJSON(outputList, SewerageDemandStatusDetails.class, SewerageDemandStatusDetailsAdapter.class) + "}";
    }

    @RequestMapping(value={"/seweragedemand-batch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getDemandGeneration(@ModelAttribute SewerageDemandStatusResponse sewerageDemandStatusDetails, HttpServletRequest request, @RequestParam String financialYear, Model model) {
        ArrayList<SewerageDemandStatusResponse> batchresultList = new ArrayList<SewerageDemandStatusResponse>();
        List batchList = this.sewerageBatchDemandGenService.findActiveBatchDemands();
        if (batchList != null) {
            for (SewerageTaxBatchDemandGenerate batch : batchList) {
                SewerageDemandStatusResponse batchobj = new SewerageDemandStatusResponse();
                batchobj.setJobname(batch.getJobName());
                batchobj.setCreatedDate(batch.getCreatedDate());
                batchobj.setFinancialYear(financialYear);
                batchobj.setStatus("Demand Generation is scheduled and waiting for completion");
                batchresultList.add(batchobj);
            }
        }
        return DATA + JsonUtils.toJSON(batchresultList, SewerageDemandStatusResponse.class, SewerageDemandResponseStatusAdapter.class) + "}";
    }
}

