/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.masters.entity.DocumentTypeMaster;
import org.egov.stms.masters.entity.FeesDetailMaster;
import org.egov.stms.masters.entity.SewerageApplicationType;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.masters.service.DocumentTypeMasterService;
import org.egov.stms.masters.service.FeesDetailMasterService;
import org.egov.stms.masters.service.SewerageApplicationTypeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetailsDocument;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageTaxUtils;
import org.egov.stms.web.controller.utils.SewerageApplicationValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageChangeInClosetsController
extends GenericWorkFlowController {
    private final SewerageApplicationDetailsService sewerageApplicationDetailsService;
    private static final String MESSAGE = "message";
    private static final String COMMON_ERROR_PAGE = "common-error";
    private static final String PTASSESSMENT_NUMBER = "ptAssessmentNo";
    @Autowired
    private final SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private FeesDetailMasterService feesDetailMasterService;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageApplicationTypeService sewerageApplicationTypeService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DocumentTypeMasterService documentTypeMasterService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private SewerageApplicationValidator sewerageApplicationValidator;

    @Autowired
    public SewerageChangeInClosetsController(SewerageApplicationDetailsService sewerageApplicationDetailsService, SewerageTaxUtils sewerageTaxUtils) {
        this.sewerageApplicationDetailsService = sewerageApplicationDetailsService;
        this.sewerageTaxUtils = sewerageTaxUtils;
    }

    @RequestMapping(value={"/modifyConnection/{shscNumber}"}, method={RequestMethod.GET})
    public String showNewApplicationForm(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, @PathVariable String shscNumber, Model model, HttpServletRequest request, BindingResult errors) {
        SewerageConnection sewerageConnection = this.sewerageConnectionService.findByShscNumber(shscNumber);
        SewerageApplicationDetails sewerageApplicationDetailsFromDB = this.sewerageApplicationDetailsService.findByConnection_ShscNumberAndIsActive(shscNumber);
        if (StringUtils.isNotBlank((CharSequence)shscNumber)) {
            SewerageApplicationDetails applicationDetails = this.sewerageApplicationDetailsService.isApplicationInProgress(shscNumber);
            if (applicationDetails != null) {
                if ("CHANGEINCLOSETS".equalsIgnoreCase(applicationDetails.getApplicationType().getCode())) {
                    model.addAttribute(MESSAGE, (Object)"msg.validate.changenoofclosets.application.inprogress");
                    return COMMON_ERROR_PAGE;
                }
                if ("CLOSESEWERAGECONNECTION".equalsIgnoreCase(applicationDetails.getApplicationType().getCode())) {
                    model.addAttribute(MESSAGE, (Object)"msg.validate.closeconnection.application.inprogress");
                    return COMMON_ERROR_PAGE;
                }
            }
            if (sewerageApplicationDetailsFromDB.getConnectionDetail() != null && sewerageApplicationDetailsFromDB.getConnectionDetail().getPropertyIdentifier() != null) {
                AssessmentDetails assessmentDetails = this.sewerageThirdPartyServices.getPropertyDetails(sewerageApplicationDetailsFromDB.getConnectionDetail().getPropertyIdentifier(), request);
                if (assessmentDetails != null && assessmentDetails.getPropertyDetails() != null && assessmentDetails.getPropertyDetails().getTaxDue().compareTo(BigDecimal.ZERO) > 0) {
                    model.addAttribute(MESSAGE, (Object)"msg.sewerageapplication.propertytax.isdue");
                    return COMMON_ERROR_PAGE;
                }
                HashMap result = this.sewerageThirdPartyServices.getWaterTaxDueAndCurrentTax(sewerageApplicationDetailsFromDB.getConnectionDetail().getPropertyIdentifier(), request);
                BigDecimal waterTaxDue = (BigDecimal)result.get("WATERTAXDUE");
                if (waterTaxDue.compareTo(BigDecimal.ZERO) > 0) {
                    model.addAttribute(MESSAGE, (Object)"msg.sewerageapplication.watertax.isdue");
                    return COMMON_ERROR_PAGE;
                }
            }
        }
        sewerageApplicationDetails.setConnection(sewerageConnection);
        if (sewerageApplicationDetailsFromDB != null) {
            BigDecimal taxDue = this.sewerageApplicationDetailsService.getPendingTaxAmount(sewerageApplicationDetailsFromDB);
            if (taxDue.compareTo(BigDecimal.ZERO) > 0) {
                model.addAttribute(MESSAGE, (Object)"msg.validate.demandamountdue");
                return COMMON_ERROR_PAGE;
            }
            sewerageApplicationDetails.setConnectionDetail(sewerageApplicationDetailsFromDB.getConnectionDetail());
            model.addAttribute(PTASSESSMENT_NUMBER, (Object)sewerageApplicationDetailsFromDB.getConnectionDetail().getPropertyIdentifier());
        }
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("CHANGEINCLOSETS");
        sewerageApplicationDetails.setApplicationType(applicationType);
        sewerageApplicationDetails.setApplicationDate(new Date());
        model.addAttribute("allowIfPTDueExists", (Object)this.sewerageTaxUtils.isNewConnectionAllowedIfPTDuePresent());
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        model.addAttribute("shscNumber", (Object)shscNumber);
        model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule(sewerageApplicationDetails.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, workFlowContainer);
        model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
        model.addAttribute("typeOfConnection", (Object)"CHANGEINCLOSETS");
        boolean inspectionFeeCollectionRequired = this.sewerageTaxUtils.isInspectionFeeCollectionRequired();
        model.addAttribute("inspectionFeesCollectionRequired", (Object)inspectionFeeCollectionRequired);
        if (inspectionFeeCollectionRequired) {
            this.createSewerageConnectionFee(sewerageApplicationDetails, "INSPECTIONCHARGE");
        }
        model.addAttribute("mode", (Object)"edit");
        return "changeInClosetsConnection-form";
    }

    @ModelAttribute(value="documentNamesList")
    public List<SewerageApplicationDetailsDocument> documentTypeMasterList(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageApplicationDetailsDocument> tempDocList = new ArrayList<SewerageApplicationDetailsDocument>(0);
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("CHANGEINCLOSETS");
        List documentTypeMasterList = this.documentTypeMasterService.getAllActiveDocumentTypeMasterByApplicationType(applicationType);
        if (sewerageApplicationDetails != null) {
            for (DocumentTypeMaster dtm : documentTypeMasterList) {
                SewerageApplicationDetailsDocument sad = new SewerageApplicationDetailsDocument();
                if (dtm == null) continue;
                sad.setDocumentTypeMaster(dtm);
                tempDocList.add(sad);
            }
        }
        return tempDocList;
    }

    @RequestMapping(value={"/modifyConnection/{shscNumber}"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, @PathVariable String shscNumber, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction, @RequestParam(value="files") MultipartFile[] files) {
        sewerageApplicationDetails.getConnectionDetail().setPropertyIdentifier(request.getParameter(PTASSESSMENT_NUMBER));
        this.sewerageApplicationValidator.validateChangeInClosetsApplication(sewerageApplicationDetails, (Errors)resultBinder, request);
        ArrayList applicationDocs = new ArrayList();
        int i = 0;
        if (!sewerageApplicationDetails.getAppDetailsDocument().isEmpty()) {
            for (SewerageApplicationDetailsDocument applicationDocument : sewerageApplicationDetails.getAppDetailsDocument()) {
                this.sewerageConnectionService.validateDocuments(applicationDocs, applicationDocument, i, resultBinder);
                ++i;
            }
        }
        if (resultBinder.hasErrors()) {
            sewerageApplicationDetails.setApplicationDate(new Date());
            model.addAttribute("validateIfPTDueExists", (Object)this.sewerageTaxUtils.isNewConnectionAllowedIfPTDuePresent());
            model.addAttribute("propertyTypes", (Object)PropertyType.values());
            model.addAttribute("mode", (Object)"edit");
            model.addAttribute(PTASSESSMENT_NUMBER, (Object)sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier());
            this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, new WorkflowContainer());
            model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
            model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
            return "changeInClosetsConnection-form";
        }
        if (sewerageApplicationDetails.getState() == null) {
            if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("COLLECTINSPECTIONFEE", "SEWERAGETAXAPPLICATION"));
            } else {
                sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
            }
        }
        sewerageApplicationDetails.getAppDetailsDocument().clear();
        sewerageApplicationDetails.setAppDetailsDocument(applicationDocs);
        this.sewerageConnectionService.processAndStoreApplicationDocuments(sewerageApplicationDetails);
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        this.populateFeesDetails(sewerageApplicationDetails);
        SewerageConnection sewerageConnection = this.sewerageConnectionService.findByShscNumber(shscNumber);
        sewerageConnection.setStatus(SewerageConnectionStatus.INPROGRESS);
        sewerageApplicationDetails.setConnection(sewerageConnection);
        sewerageConnection.addApplicantDetails(sewerageApplicationDetails);
        SewerageApplicationDetails newSewerageApplicationDetails = this.sewerageApplicationDetailsService.createNewSewerageConnection(sewerageApplicationDetails, approvalPosition, approvalComment, sewerageApplicationDetails.getApplicationType().getCode(), files, workFlowAction, request);
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        String nextDesign = asignList != null && !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = newSewerageApplicationDetails.getApplicationNumber() + "," + this.sewerageTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        return "redirect:/transactions/changeInClosets-success?pathVars=" + pathVars;
    }

    @RequestMapping(value={"/changeInClosets-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request, Model model, ModelMap modelMap) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        String applicationNumber = "";
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                applicationNumber = keyNameArray[0];
            } else if (keyNameArray.length == 3) {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (applicationNumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        model.addAttribute("cityName", (Object)ApplicationThreadLocals.getCityName());
        model.addAttribute("mode", (Object)"ack");
        this.setCommonDetails(sewerageApplicationDetails, modelMap, request);
        boolean inspectionFeeCollectionRequired = this.sewerageTaxUtils.isInspectionFeeCollectionRequired();
        model.addAttribute("inspectionFeesCollectionRequired", (Object)inspectionFeeCollectionRequired);
        if (inspectionFeeCollectionRequired) {
            model.addAttribute("inspectionDetails", (Object)sewerageApplicationDetails.getConnectionFees());
        }
        model.addAttribute("documentNamesList", (Object)this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails));
        return new ModelAndView("changeInClosets-success", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    private void setCommonDetails(SewerageApplicationDetails sewerageApplicationDetails, ModelMap modelMap, HttpServletRequest request) {
        String assessmentNumber = sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier();
        AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentNumber, request);
        if (propertyOwnerDetails != null) {
            modelMap.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        PropertyTaxDetails propertyTaxDetails = this.propertyExternalService.getPropertyTaxDetails(assessmentNumber, null);
        modelMap.addAttribute("propertyTax", (Object)propertyTaxDetails.getTotalTaxAmt());
    }

    private void populateFeesDetails(SewerageApplicationDetails sewerageApplicationDetails) {
        if (sewerageApplicationDetails.getConnectionFees() != null && !sewerageApplicationDetails.getConnectionFees().isEmpty()) {
            for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
                scf.setApplicationDetails(sewerageApplicationDetails);
            }
        }
    }

    public void createSewerageConnectionFee(SewerageApplicationDetails sewerageApplicationDetails, String feeCode) {
        List inspectionFeeList = this.feesDetailMasterService.findAllActiveFeesDetailByFeesCode(feeCode);
        for (FeesDetailMaster feeDetailMaster : inspectionFeeList) {
            SewerageConnectionFee connectionFee = new SewerageConnectionFee();
            connectionFee.setFeesDetail(feeDetailMaster);
            if (feeDetailMaster.getIsFixedRate().booleanValue()) {
                connectionFee.setAmount(feeDetailMaster.getAmount().doubleValue());
            }
            connectionFee.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.getConnectionFees().add(connectionFee);
        }
    }
}

