/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.stms.masters.entity.DocumentTypeMaster;
import org.egov.stms.masters.entity.FeesDetailMaster;
import org.egov.stms.masters.entity.SewerageApplicationType;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.masters.service.DocumentTypeMasterService;
import org.egov.stms.masters.service.FeesDetailMasterService;
import org.egov.stms.masters.service.SewerageApplicationTypeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageApplicationDetailsDocument;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.entity.SewerageDemandDetail;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.utils.SewerageTaxUtils;
import org.egov.stms.web.controller.utils.SewerageApplicationValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageLegacyConnectionController
extends GenericWorkFlowController {
    private static final Logger LOG = LoggerFactory.getLogger(SewerageLegacyConnectionController.class);
    private final SewerageTaxUtils sewerageTaxUtils;
    private final SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageApplicationTypeService sewerageApplicationTypeService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private FeesDetailMasterService feesDetailMasterService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private DocumentTypeMasterService documentTypeMasterService;
    @Autowired
    private SewerageApplicationValidator sewerageApplicationValidator;

    @Autowired
    public SewerageLegacyConnectionController(SewerageTaxUtils sewerageTaxUtils, SewerageApplicationDetailsService sewerageApplicationDetailsService) {
        this.sewerageTaxUtils = sewerageTaxUtils;
        this.sewerageApplicationDetailsService = sewerageApplicationDetailsService;
    }

    @ModelAttribute(value="documentNamesList")
    public List<SewerageApplicationDetailsDocument> documentTypeMasterList(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageApplicationDetailsDocument> tempDocList = new ArrayList<SewerageApplicationDetailsDocument>(0);
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("NEWSEWERAGECONNECTION");
        List documentTypeMasterList = this.documentTypeMasterService.getAllActiveDocumentTypeMasterByApplicationType(applicationType);
        if (sewerageApplicationDetails != null) {
            for (DocumentTypeMaster dtm : documentTypeMasterList) {
                SewerageApplicationDetailsDocument sad = new SewerageApplicationDetailsDocument();
                if (dtm == null || !dtm.getDescription().equalsIgnoreCase("Others")) continue;
                sad.setDocumentTypeMaster(dtm);
                tempDocList.add(sad);
            }
        }
        return tempDocList;
    }

    @RequestMapping(value={"/legacyConnection-newform"}, method={RequestMethod.GET})
    public String showLegacyApplicationForm(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, Model model, HttpServletRequest request) {
        LOG.debug("Inside showLegacyApplicationForm method");
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("NEWSEWERAGECONNECTION");
        sewerageApplicationDetails.setApplicationType(applicationType);
        sewerageApplicationDetails.setApplicationDate(new Date());
        SewerageConnection connection = new SewerageConnection();
        connection.setStatus(SewerageConnectionStatus.ACTIVE);
        sewerageApplicationDetails.setConnection(connection);
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
        model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
        model.addAttribute("typeOfConnection", (Object)"NEWSEWERAGECONNECTION");
        this.createSewerageConnectionFee(sewerageApplicationDetails, "ESTIMATIONCHARGE");
        this.createSewerageConnectionFee(sewerageApplicationDetails, "SEWERAGETAX");
        model.addAttribute("mode", null);
        return "legacySewerageConnection-form";
    }

    private void createSewerageConnectionFee(SewerageApplicationDetails sewerageApplicationDetails, String feeCode) {
        List inspectionFeeList = this.feesDetailMasterService.findAllActiveFeesDetailByFeesCode(feeCode);
        for (FeesDetailMaster feeDetailMaster : inspectionFeeList) {
            if (feeDetailMaster.getCode().equalsIgnoreCase("SEWERAGETAX")) continue;
            SewerageConnectionFee connectionFee = new SewerageConnectionFee();
            connectionFee.setFeesDetail(feeDetailMaster);
            if (feeDetailMaster.getIsFixedRate().booleanValue()) {
                connectionFee.setAmount(feeDetailMaster.getAmount().doubleValue());
            }
            connectionFee.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.getConnectionFees().add(connectionFee);
        }
    }

    @RequestMapping(value={"/legacyConnection-create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam(value="files") MultipartFile[] files) {
        ArrayList applicationDocs = new ArrayList();
        int i = 0;
        if (!sewerageApplicationDetails.getAppDetailsDocument().isEmpty()) {
            for (SewerageApplicationDetailsDocument applicationDocument : sewerageApplicationDetails.getAppDetailsDocument()) {
                this.sewerageConnectionService.validateDocuments(applicationDocs, applicationDocument, i, resultBinder);
                ++i;
            }
        }
        this.sewerageApplicationValidator.validateLegacyData(sewerageApplicationDetails, (Errors)resultBinder, request);
        if (LOG.isDebugEnabled()) {
            LOG.error("Model Level Validation occurs = " + resultBinder);
        }
        if (resultBinder.hasErrors()) {
            sewerageApplicationDetails.setApplicationDate(new Date());
            model.addAttribute("sewerageApplicationDetails", (Object)sewerageApplicationDetails);
            model.addAttribute("demandDetailList", (Object)sewerageApplicationDetails.getDemandDetailBeanList());
            model.addAttribute("propertyTypes", (Object)PropertyType.values());
            model.addAttribute("executionDate", (Object)sewerageApplicationDetails.getConnection().getExecutionDate());
            return "legacySewerageConnection-form";
        }
        sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "SEWERAGETAXAPPLICATION"));
        sewerageApplicationDetails.getAppDetailsDocument().clear();
        sewerageApplicationDetails.setAppDetailsDocument(applicationDocs);
        this.sewerageConnectionService.processAndStoreApplicationDocuments(sewerageApplicationDetails);
        this.populateFeesDetails(sewerageApplicationDetails);
        SewerageApplicationDetails newSewerageApplicationDetails = this.sewerageApplicationDetailsService.createLegacySewerageConnection(sewerageApplicationDetails, request);
        String pathVars = newSewerageApplicationDetails.getApplicationNumber();
        return "redirect:/transactions/sewerageLegacyApplication-success?pathVars=" + pathVars;
    }

    private void populateFeesDetails(SewerageApplicationDetails sewerageApplicationDetails) {
        FeesDetailMaster sewerageTax;
        if (sewerageApplicationDetails.getConnectionFees() != null && !sewerageApplicationDetails.getConnectionFees().isEmpty()) {
            for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
                scf.setApplicationDetails(sewerageApplicationDetails);
            }
        }
        if ((sewerageTax = this.feesDetailMasterService.findByCodeAndIsActive("SEWERAGETAX", true)) != null && !sewerageApplicationDetails.getDemandDetailBeanList().isEmpty()) {
            SewerageConnectionFee connectionFee = new SewerageConnectionFee();
            connectionFee.setFeesDetail(sewerageTax);
            connectionFee.setAmount(((SewerageDemandDetail)sewerageApplicationDetails.getDemandDetailBeanList().get(sewerageApplicationDetails.getDemandDetailBeanList().size() - 1)).getActualAmount().doubleValue());
            connectionFee.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.getConnectionFees().add(connectionFee);
        }
    }

    @RequestMapping(value={"/sewerageLegacyApplication-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request, Model model, ModelMap modelMap) {
        SewerageApplicationDetails applicationDetails = null;
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        String applicationNumber = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0 && keyNameArray.length == 1) {
            applicationNumber = keyNameArray[0];
        }
        if (applicationNumber != null) {
            applicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        }
        return new ModelAndView("sewerageLegacyApplication-success", "sewerageApplicationDetails", (Object)applicationDetails);
    }
}

