/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageFieldInspection;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageEstimationNoticeController {
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    private static final int BUFFER_SIZE = 4096;
    public static final String ESTIMATION_NOTICE = "sewerageEstimationNotice";
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;

    @RequestMapping(value={"/estimationnotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateEstimationNotice(HttpServletRequest request, HttpSession session) {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(request.getParameter("pathVar"));
        return this.generateReport(sewerageApplicationDetails, session, request);
    }

    private ResponseEntity<byte[]> generateReport(SewerageApplicationDetails sewerageApplicationDetails, HttpSession session, HttpServletRequest request) {
        ReportOutput reportOutput = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=EstimationNotice.pdf");
        reportOutput = this.sewerageNoticeService.generateReportOutputDataForEstimation(sewerageApplicationDetails, session, request);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/downloadFile"}, method={RequestMethod.GET})
    public void downLoadFieldInspectionAttachment(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(request.getParameter("applicationNumber"));
        ServletContext context = request.getServletContext();
        File downloadFile = this.fileStoreService.fetch(((SewerageFieldInspection)sewerageApplicationDetails.getFieldInspections().get(0)).getFileStore().getFileStoreId(), "STMS");
        FileInputStream inputStream = new FileInputStream(downloadFile);
        String mimeType = context.getMimeType(downloadFile.getAbsolutePath());
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        response.setContentType(mimeType);
        response.setContentLength((int)downloadFile.length());
        String headerKey = "Content-Disposition";
        String headerValue = String.format("attachment; filename=\"%s\"", ((SewerageFieldInspection)sewerageApplicationDetails.getFieldInspections().get(0)).getFileStore().getFileName());
        response.setHeader("Content-Disposition", headerValue);
        ServletOutputStream outStream = response.getOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        outStream.close();
    }

    @RequestMapping(value={"/closeConnectionNotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateCloserNotice(HttpServletRequest request, HttpSession session) {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(request.getParameter("pathVar"));
        return this.generateCloseConnectionReport(sewerageApplicationDetails, session);
    }

    private ResponseEntity<byte[]> generateCloseConnectionReport(SewerageApplicationDetails sewerageApplicationDetails, HttpSession session) {
        HttpHeaders headers = new HttpHeaders();
        ReportOutput reportOutput = null;
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=CloseConnectionNotice.pdf");
        reportOutput = this.sewerageNoticeService.generateReportOutputForSewerageCloseConnection(sewerageApplicationDetails, session);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

