/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.masters.entity.SewerageApplicationType;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.masters.service.SewerageApplicationTypeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnection;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageTaxUtils;
import org.egov.stms.web.controller.utils.SewerageApplicationValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageCloseConnectionController
extends GenericWorkFlowController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageApplicationTypeService sewerageApplicationTypeService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SewerageApplicationValidator sewerageApplicationValidator;

    @RequestMapping(value={"/closeConnection/{shscNumber}"}, method={RequestMethod.GET})
    public String view(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, Model model, @PathVariable String shscNumber, HttpServletRequest request) {
        BigDecimal taxDue = BigDecimal.ZERO;
        SewerageConnection sewerageConnection = this.sewerageConnectionService.findByShscNumber(shscNumber);
        SewerageApplicationDetails sewerageApplicationDetailsFromDB = this.sewerageApplicationDetailsService.findByConnection_ShscNumberAndIsActive(shscNumber);
        sewerageApplicationDetails.setConnection(sewerageConnection);
        if (StringUtils.isNotBlank((String)shscNumber)) {
            SewerageApplicationDetails applicationDetails = this.sewerageApplicationDetailsService.isApplicationInProgress(shscNumber);
            if (applicationDetails != null && "CLOSESEWERAGECONNECTION".equalsIgnoreCase(applicationDetails.getApplicationType().getCode())) {
                model.addAttribute("message", (Object)"msg.validate.closeconnection.application.inprogress");
                return "common-error";
            }
            if (applicationDetails != null && "CHANGEINCLOSETS".equalsIgnoreCase(applicationDetails.getApplicationType().getCode())) {
                model.addAttribute("message", (Object)"msg.validate.changenoofclosets.application.inprogress");
                return "common-error";
            }
        }
        if (sewerageApplicationDetailsFromDB != null && (taxDue = this.sewerageApplicationDetailsService.getPendingTaxAmount(sewerageApplicationDetailsFromDB)).compareTo(BigDecimal.ZERO) > 0) {
            model.addAttribute("message", (Object)"msg.validate.demandamountdue");
            return "common-error";
        }
        AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(shscNumber, request);
        if (propertyOwnerDetails != null) {
            model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        SewerageApplicationType applicationType = this.sewerageApplicationTypeService.findByCode("CLOSESEWERAGECONNECTION");
        sewerageApplicationDetails.setApplicationType(applicationType);
        sewerageApplicationDetails.setApplicationDate(new Date());
        sewerageApplicationDetails.setConnectionDetail(sewerageApplicationDetailsFromDB.getConnectionDetail());
        model.addAttribute("ptAssessmentNo", (Object)sewerageApplicationDetailsFromDB.getConnectionDetail().getPropertyIdentifier());
        model.addAttribute("shscNumber", (Object)shscNumber);
        model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule(sewerageApplicationDetails.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, workFlowContainer);
        model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
        model.addAttribute("typeOfConnection", (Object)"CLOSESEWERAGECONNECTION");
        return "closeSewerageConnection";
    }

    @RequestMapping(value={"/closeConnection/{shscNumber}"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, @PathVariable String shscNumber, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction, @RequestParam(value="files") MultipartFile[] files) {
        SewerageApplicationDetails sewerageApplicationDetailsFromDB = this.sewerageApplicationDetailsService.findByConnection_ShscNumberAndIsActive(shscNumber);
        if (sewerageApplicationDetailsFromDB != null && StringUtils.isNotEmpty((String)sewerageApplicationDetailsFromDB.getConnectionDetail().toString())) {
            sewerageApplicationDetails.setConnectionDetail(sewerageApplicationDetailsFromDB.getConnectionDetail());
        }
        this.sewerageApplicationValidator.validateClosureApplication(sewerageApplicationDetails, (Errors)resultBinder, request);
        if (resultBinder.hasErrors()) {
            sewerageApplicationDetails.setApplicationDate(new Date());
            this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, new WorkflowContainer());
            AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(shscNumber, request);
            if (propertyOwnerDetails != null) {
                model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
            }
            model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
            model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
            return "closeSewerageConnection";
        }
        sewerageApplicationDetails.setStatus(this.sewerageTaxUtils.getStatusByCodeAndModuleType("CREATED", "SEWERAGETAXAPPLICATION"));
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        SewerageConnection sewerageConnection = this.sewerageConnectionService.findByShscNumber(shscNumber);
        sewerageConnection.setStatus(SewerageConnectionStatus.INPROGRESS);
        sewerageApplicationDetails.setConnection(sewerageConnection);
        sewerageConnection.addApplicantDetails(sewerageApplicationDetails);
        SewerageApplicationDetails newSewerageApplicationDetails = this.sewerageApplicationDetailsService.createNewSewerageConnection(sewerageApplicationDetails, approvalPosition, approvalComment, sewerageApplicationDetails.getApplicationType().getCode(), files, workFlowAction, request);
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        String nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = newSewerageApplicationDetails.getApplicationNumber() + "," + this.sewerageTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        return "redirect:/transactions/closeConnection-success?pathVars=" + pathVars;
    }

    @RequestMapping(value={"/closeConnection-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request, Model model, ModelMap modelMap) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        String applicationNumber = "";
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                applicationNumber = keyNameArray[0];
            } else if (keyNameArray.length == 3) {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (applicationNumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        model.addAttribute("cityName", (Object)ApplicationThreadLocals.getCityName());
        return new ModelAndView("closeConnection-success", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }
}

