/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.reports;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.stms.notice.entity.SewerageNotice;
import org.egov.stms.notice.service.SewerageNoticeService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDCBReporService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageGenerateDemandBillController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SewerageDCBReporService sewerageDCBReportService;
    @Autowired
    private SewerageNoticeService sewerageNoticeService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private MessageSource messageSource;
    private static final Logger LOGGER = Logger.getLogger(SewerageGenerateDemandBillController.class);

    @RequestMapping(value={"/generate-sewerage-demand-bill/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> generateSewerageDemandBill(@PathVariable String consumernumber, @PathVariable String assessmentnumber, HttpServletRequest request, HttpSession session) {
        ReportOutput reportOutput = new ReportOutput();
        HttpHeaders headers = new HttpHeaders();
        SewerageNotice sewerageNotice = null;
        SewerageApplicationDetails sewerageApplicationDetails = null;
        String errorMessage = "";
        if (consumernumber != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber);
        }
        if (sewerageApplicationDetails != null && sewerageApplicationDetails.getApplicationNumber() != null) {
            sewerageNotice = this.sewerageNoticeService.findByNoticeTypeAndApplicationNumber("Demand Bill", sewerageApplicationDetails.getApplicationNumber());
            if (sewerageNotice != null && sewerageNotice.getFileStore() != null) {
                FileStoreMapper fmp = sewerageNotice.getFileStore();
                if (fmp != null) {
                    reportOutput = new ReportOutput();
                    File file = this.fileStoreService.fetch(fmp, "STMS");
                    try {
                        reportOutput.setReportOutputData(FileUtils.readFileToByteArray((File)file));
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)("Error in loading sewerage demand bill" + e.getMessage()), (Throwable)e);
                    }
                    reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
                }
            } else if (this.sewerageDemandService.checkAnyTaxIsPendingToCollectExcludingAdvance(sewerageApplicationDetails.getCurrentDemand()).booleanValue()) {
                reportOutput = this.sewerageDCBReportService.generateAndSaveDemandBillNotice(sewerageApplicationDetails, this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request), request, session);
            } else {
                errorMessage = this.messageSource.getMessage("err.demandbill.demandpaid", (Object[])new String[]{""}, null);
                return this.redirect(errorMessage);
            }
            if (reportOutput != null && reportOutput.getReportOutputData() != null) {
                headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
                headers.add("content-disposition", "inline;filename=DemandBill.pdf");
            }
        }
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private ResponseEntity<byte[]> redirect(String errorMessage) {
        errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + errorMessage + "</p></body></html>";
        byte[] byteData = errorMessage.getBytes();
        errorMessage = "";
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }
}

