/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.masters;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.pojo.DCBReportWardwiseResult;
import org.egov.stms.service.es.SewerageIndexService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDCBReporService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/reports"})
public class SewerageRateDCBReportController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageDCBReporService sewerageDCBReporService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @PersistenceContext
    EntityManager entityManager;
    @Autowired
    private CityService cityService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private SewerageIndexService sewerageIndexService;

    @ModelAttribute
    public DCBReportWardwiseResult dCBReportWardWise() {
        return new DCBReportWardwiseResult();
    }

    @RequestMapping(value={"/sewerageRateReportView/{consumernumber}/{assessmentnumber}"}, method={RequestMethod.GET})
    public ModelAndView getSewerageRateReport(@PathVariable String consumernumber, @PathVariable String assessmentnumber, Model model, ModelMap modelMap, HttpServletRequest request) {
        SewerageApplicationDetails sewerageApplicationDetails = null;
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        String currentDate = formatter.format(new Date());
        if (consumernumber != null && (sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(consumernumber)) != null) {
            AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentnumber, request);
            model.addAttribute("applicationNumber", (Object)sewerageApplicationDetails.getApplicationNumber());
            model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
            model.addAttribute("assessmentnumber", (Object)assessmentnumber);
            model.addAttribute("currentDate", (Object)currentDate);
            model.addAttribute("dcbResultList", (Object)this.sewerageDCBReporService.getSewerageRateDCBReport(sewerageApplicationDetails));
        }
        return new ModelAndView("report-sewerageRate-view", "sewerageApplicationDetails", (Object)sewerageApplicationDetails);
    }

    @RequestMapping(value={"/dcb-report-wardwise"}, method={RequestMethod.GET})
    public String wardWiseSearch(@ModelAttribute DCBReportWardwiseResult dcbReportWardwiseResult, Model model) {
        model.addAttribute("dcbReportWardwiseResult", (Object)dcbReportWardwiseResult);
        ArrayList<String> propertytype = new ArrayList<String>();
        for (PropertyType s : PropertyType.values()) {
            propertytype.add(s.toString());
        }
        ArrayList<String> boundaryList = new ArrayList<String>();
        boundaryList.add("ALL");
        List bList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
        for (Boundary b : bList) {
            boundaryList.add(b.toString());
        }
        model.addAttribute("propertyType", propertytype);
        model.addAttribute("wards", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        return "sewerage-dcbwardwise";
    }

    @RequestMapping(value={"/dcbReportWardwiseList"}, method={RequestMethod.GET})
    @ResponseBody
    public void searchApplication(@ModelAttribute DCBReportWardwiseResult searchRequest, Model model, HttpServletResponse response) throws IOException {
        ArrayList<Boundary> wardList = new ArrayList<Boundary>();
        ArrayList wards = new ArrayList();
        ArrayList<String> propertyTypeList = new ArrayList<String>();
        ArrayList<String> wardNames = new ArrayList<String>();
        if (searchRequest.getMode() != null) {
            String[] wardIds;
            for (String idValue : wardIds = searchRequest.getMode().split("~")) {
                Boundary ward = this.boundaryService.getBoundaryById(Long.valueOf(Long.parseLong(idValue)));
                if (ward == null) continue;
                wardList.add(ward);
            }
        }
        if (wardList != null && !wardList.isEmpty()) {
            searchRequest.setWards(wardList);
        }
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        if (null != searchRequest.getWards() && !searchRequest.getWards().isEmpty() && searchRequest.getWards().get(0) != null) {
            wards.addAll(searchRequest.getWards());
        } else {
            wards.addAll(this.boundaryService.getBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE"));
        }
        for (Boundary boundary : wards) {
            if (boundary == null) continue;
            searchRequest.setRevenueWard(boundary.getLocalName());
            model.addAttribute("wardId", (Object)boundary.getId());
            if (boundary.getLocalName() == null) continue;
            wardNames.add(boundary.getLocalName());
        }
        if (searchRequest.getPropertyType().equals("ALL")) {
            propertyTypeList.add("RESIDENTIAL");
            propertyTypeList.add("NON_RESIDENTIAL");
            propertyTypeList.add("MIXED");
        } else {
            propertyTypeList.add(searchRequest.getPropertyType());
        }
        Map dcbMap = this.sewerageIndexService.wardWiseBoolQueryFilter(searchRequest.getUlbName(), wardNames, propertyTypeList);
        List wardwiseResultList = this.sewerageDCBReporService.getSewerageRateDCBWardwiseReport(dcbMap, searchRequest.getPropertyType());
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)wardwiseResultList) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/dcbViewWardConnections/{id}"}, method={RequestMethod.GET})
    public String getConnectionDCBReport(@ModelAttribute DCBReportWardwiseResult searchRequest, Model model, @PathVariable String id, HttpServletRequest request) {
        String propType = null;
        String revenueWard = null;
        ArrayList<String> propertyTypeList = new ArrayList<String>();
        String[] wardDtl = id.split("~");
        ArrayList<String> wardList = new ArrayList<String>();
        for (String value : wardDtl) {
            wardList.add(value);
        }
        Long wardId = Long.parseLong((String)wardList.get(0));
        if (wardId != null) {
            Boundary boundary = this.boundaryService.getBoundaryById(wardId);
            revenueWard = boundary.getLocalName();
        }
        if (wardList.size() == 2 && StringUtils.isNotBlank((CharSequence)((CharSequence)wardList.get(1)))) {
            propType = (String)wardList.get(1);
        }
        if ("ALL".equals(propType)) {
            propertyTypeList.add("NON_RESIDENTIAL");
            propertyTypeList.add("MIXED");
            propertyTypeList.add("RESIDENTIAL");
        } else {
            propertyTypeList.add(propType);
        }
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        String ulbName = cityWebsite.getName();
        Map wardConnectionMap = this.sewerageIndexService.wardWiseConnectionQueryFilter(propertyTypeList, revenueWard, ulbName);
        model.addAttribute("currentDate", (Object)new Date());
        model.addAttribute("revenueWard", (Object)revenueWard);
        model.addAttribute("dcbResultList", (Object)this.sewerageDCBReporService.getSewerageDCBWardConnections(wardConnectionMap, propType));
        return "sewerage-dcbWardConnections";
    }
}

