/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.transactions;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.egov.commons.service.UOMService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.stms.masters.entity.FeesDetailMaster;
import org.egov.stms.masters.entity.enums.OwnerOfTheRoad;
import org.egov.stms.masters.entity.enums.PropertyType;
import org.egov.stms.masters.service.FeesDetailMasterService;
import org.egov.stms.transactions.charges.SewerageChargeCalculationService;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionEstimationDetails;
import org.egov.stms.transactions.entity.SewerageConnectionFee;
import org.egov.stms.transactions.entity.SewerageFieldInspection;
import org.egov.stms.transactions.entity.SewerageFieldInspectionDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageConnectionFeeService;
import org.egov.stms.transactions.service.SewerageConnectionService;
import org.egov.stms.transactions.service.SewerageEstimationDetailsService;
import org.egov.stms.transactions.service.SewerageFieldInspectionDetailsService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.egov.stms.utils.SewerageInspectionDetailsComparatorById;
import org.egov.stms.utils.SewerageTaxUtils;
import org.egov.stms.utils.constants.SewerageTaxConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.SmartValidator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/transactions"})
public class SewerageUpdateConnectionController
extends GenericWorkFlowController {
    private final SewerageApplicationDetailsService sewerageApplicationDetailsService;
    private final DepartmentService departmentService;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private FeesDetailMasterService feesDetailMasterService;
    @Autowired
    private UOMService uOMService;
    @Autowired
    private SewerageChargeCalculationService sewerageChargeCalculationService;
    @Autowired
    private SewerageConnectionFeeService SewerageConnectionFeeService;
    @Autowired
    private SewerageConnectionService sewerageConnectionService;
    @Autowired
    private SewerageEstimationDetailsService sewerageEstimationDetailsService;
    @Autowired
    private SewerageFieldInspectionDetailsService sewerageFieldInspectionDetailsService;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;

    @Autowired
    public SewerageUpdateConnectionController(SewerageApplicationDetailsService sewerageApplicationDetailsService, DepartmentService departmentService, SmartValidator validator) {
        this.sewerageApplicationDetailsService = sewerageApplicationDetailsService;
        this.departmentService = departmentService;
    }

    @ModelAttribute(value="sewerageApplicationDetails")
    public SewerageApplicationDetails getSewerageApplicationDetails(@PathVariable String applicationNumber) {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        return sewerageApplicationDetails;
    }

    @RequestMapping(value={"/update/{applicationNumber}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String applicationNumber, HttpServletRequest request) {
        SewerageApplicationDetails sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByApplicationNumber(applicationNumber);
        if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEINCLOSETS")) {
            return "redirect:/transactions/modifyConnection-update/" + applicationNumber;
        }
        if (sewerageApplicationDetails.getApplicationType().getCode().equalsIgnoreCase("CLOSESEWERAGECONNECTION")) {
            return "redirect:/transactions/closeSewerageConnection-update/" + applicationNumber;
        }
        if (sewerageApplicationDetails.getEstimationDetails() != null && !sewerageApplicationDetails.getEstimationDetails().isEmpty()) {
            sewerageApplicationDetails.setEstimationDetailsForUpdate(sewerageApplicationDetails.getEstimationDetails());
        }
        if (sewerageApplicationDetails.getFieldInspections() != null && !sewerageApplicationDetails.getFieldInspections().isEmpty() && sewerageApplicationDetails.getFieldInspections().get(0) != null && ((SewerageFieldInspection)sewerageApplicationDetails.getFieldInspections().get(0)).getFieldInspectionDetails() != null) {
            ((SewerageFieldInspection)sewerageApplicationDetails.getFieldInspections().get(0)).setFieldInspectionDetailsForUpdate(((SewerageFieldInspection)sewerageApplicationDetails.getFieldInspections().get(0)).getFieldInspectionDetails());
        }
        model.addAttribute("sewerageApplcationDetails", (Object)sewerageApplicationDetails);
        this.setCommonDetails(sewerageApplicationDetails, model, request);
        return this.loadViewData(model, request, sewerageApplicationDetails);
    }

    private String loadViewData(Model model, HttpServletRequest request, SewerageApplicationDetails sewerageApplicationDetails) {
        FeesDetailMaster fdm;
        List connectionFeeList;
        model.addAttribute("stateType", (Object)sewerageApplicationDetails.getClass().getSimpleName());
        for (SewerageFieldInspection fieldInspection : sewerageApplicationDetails.getFieldInspections()) {
            Collections.sort(fieldInspection.getFieldInspectionDetails(), new SewerageInspectionDetailsComparatorById());
        }
        model.addAttribute("additionalRule", (Object)sewerageApplicationDetails.getApplicationType().getCode());
        model.addAttribute("currentUser", (Object)this.sewerageTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("currentState", (Object)sewerageApplicationDetails.getCurrentState().getValue());
        if (sewerageApplicationDetails.getCurrentState().getValue().equalsIgnoreCase("Rejected")) {
            if (this.sewerageTaxUtils.isInspectionFeeCollectionRequired()) {
                model.addAttribute("pendingActions", (Object)"Rejected Inspection Fee Collection");
            } else {
                model.addAttribute("pendingActions", (Object)"Rejected");
            }
        }
        this.prepareWorkflow(model, (StateAware)sewerageApplicationDetails, new WorkflowContainer());
        model.addAttribute("sewerageApplicationDetails", (Object)sewerageApplicationDetails);
        model.addAttribute("applicationHistory", (Object)this.sewerageApplicationDetailsService.getHistory(sewerageApplicationDetails));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("pipeSize", (Object)SewerageTaxConstants.PIPE_SCREW_SIZE);
        model.addAttribute("roadOwner", (Object)OwnerOfTheRoad.values());
        model.addAttribute("uomList", (Object)this.uOMService.findAllOrderByCategory());
        Map modelParams = this.sewerageApplicationDetailsService.showApprovalDetailsByApplcationCurState(sewerageApplicationDetails);
        model.addAttribute("mode", modelParams.get("mode"));
        model.addAttribute("showApprovalDtls", modelParams.get("showApprovalDtls"));
        if (((String)modelParams.get("mode")).equalsIgnoreCase("edit") && (connectionFeeList = this.SewerageConnectionFeeService.findAllByApplicationDetailsAndFeesDetail(sewerageApplicationDetails, fdm = this.feesDetailMasterService.findByCodeAndIsActive("ESTIMATIONCHARGE", true))).isEmpty()) {
            this.createSewerageConnectionFee(sewerageApplicationDetails, "ESTIMATIONCHARGE");
        }
        if (sewerageApplicationDetails.getStatus() != null && sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INITIALAPPROVED")) {
            this.populateDonationSewerageTax(sewerageApplicationDetails);
        }
        if (((String)modelParams.get("mode")).equals("editOnReject")) {
            List docList = this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails);
            model.addAttribute("documentNamesList", (Object)docList);
        } else {
            model.addAttribute("documentNamesList", (Object)this.sewerageConnectionService.getSewerageApplicationDoc(sewerageApplicationDetails));
        }
        BigDecimal sewerageTaxDue = this.sewerageApplicationDetailsService.getTotalAmount(sewerageApplicationDetails);
        model.addAttribute("sewerageTaxDue", (Object)sewerageTaxDue);
        model.addAttribute("propertyTypes", (Object)PropertyType.values());
        return "newconnection-edit";
    }

    private void setCommonDetails(SewerageApplicationDetails sewerageApplicationDetails, Model model, HttpServletRequest request) {
        String assessmentNumber = sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier();
        AssessmentDetails propertyOwnerDetails = this.sewerageThirdPartyServices.getPropertyDetails(assessmentNumber, request);
        if (propertyOwnerDetails != null) {
            model.addAttribute("propertyOwnerDetails", (Object)propertyOwnerDetails);
        }
        PropertyTaxDetails propertyTaxDetails = this.propertyExternalService.getPropertyTaxDetails(assessmentNumber, null);
        model.addAttribute("propertyTax", (Object)propertyTaxDetails.getTotalTaxAmt());
    }

    private void createSewerageConnectionFee(SewerageApplicationDetails sewerageApplicationDetails, String feeCode) {
        List inspectionFeeList = this.feesDetailMasterService.findAllActiveFeesDetailByFeesCode(feeCode);
        for (FeesDetailMaster feeDetailMaster : inspectionFeeList) {
            SewerageConnectionFee connectionFee = new SewerageConnectionFee();
            connectionFee.setFeesDetail(feeDetailMaster);
            if (feeDetailMaster.getIsFixedRate().booleanValue()) {
                connectionFee.setAmount(feeDetailMaster.getAmount().doubleValue());
            }
            connectionFee.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.getConnectionFees().add(connectionFee);
        }
    }

    @RequestMapping(value={"/update/{applicationNumber}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute SewerageApplicationDetails sewerageApplicationDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, HttpSession session, Model model, @RequestParam(value="files") MultipartFile[] files, @RequestParam String removedInspectRowId, @RequestParam String removedEstimationDtlRowId) {
        String mode = "";
        String workFlowAction = "";
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        request.getSession().setAttribute("workFlowAction", (Object)workFlowAction);
        if ((sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("CREATED") || sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INSPECTIONFEEPAID")) && mode.equalsIgnoreCase("edit")) {
            if (workFlowAction.equalsIgnoreCase("Forward")) {
                List existingSewerage = this.populateEstimationDetails(sewerageApplicationDetails);
                List existingInspection = this.populateInspectionDetails(sewerageApplicationDetails, request, files);
                this.populateFeesDetails(sewerageApplicationDetails);
                this.sewerageApplicationDetailsService.save(sewerageApplicationDetails);
                if (existingSewerage != null && !existingSewerage.isEmpty()) {
                    this.sewerageEstimationDetailsService.deleteAllInBatch(existingSewerage);
                }
                if (existingInspection != null && !existingInspection.isEmpty()) {
                    this.sewerageFieldInspectionDetailsService.deleteAllInBatch(existingInspection);
                }
            } else if (workFlowAction.equalsIgnoreCase("Reject")) {
                this.sewerageApplicationDetailsService.getCurrentSession().evict((Object)sewerageApplicationDetails);
                sewerageApplicationDetails = this.sewerageApplicationDetailsService.findBy(sewerageApplicationDetails.getId());
            }
        }
        if (sewerageApplicationDetails.getStatus().getCode() != null && sewerageApplicationDetails.getStatus().getCode().equalsIgnoreCase("INITIALAPPROVED") && !workFlowAction.equalsIgnoreCase("Reject")) {
            this.populateDonationSewerageTax(sewerageApplicationDetails);
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (!resultBinder.hasErrors()) {
            try {
                if (null != workFlowAction && workFlowAction.equalsIgnoreCase("Preview") && sewerageApplicationDetails.getApplicationType().getCode().equals("NEWSEWERAGECONNECTION")) {
                    return "redirect:/transactions/workorder?pathVar=" + sewerageApplicationDetails.getApplicationNumber();
                }
                this.sewerageApplicationDetailsService.updateSewerageApplicationDetails(sewerageApplicationDetails, approvalPosition, approvalComment, sewerageApplicationDetails.getApplicationType().getCode(), workFlowAction, mode, null, request, session);
            }
            catch (ValidationException e) {
                throw new ValidationException(e.getMessage());
            }
            if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Generate Estimation Notice")) {
                return "redirect:/transactions/estimationnotice?pathVar=" + sewerageApplicationDetails.getApplicationNumber();
            }
            if (workFlowAction != null && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Generate Acknowledgement")) {
                return "redirect:/applications/acknowlgementNotice?pathVar=" + sewerageApplicationDetails.getApplicationNumber();
            }
            Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
            String nextDesign = "";
            Assignment assignObj = null;
            List<Object> asignList = null;
            if (approvalPosition == null || approvalPosition == 0L) {
                approvalPosition = this.assignmentService.getPrimaryAssignmentForUser(sewerageApplicationDetails.getCreatedBy().getId()).getPosition().getId();
            }
            if (approvalPosition != null) {
                assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
            }
            if (assignObj != null) {
                asignList = new ArrayList<Assignment>();
                asignList.add(assignObj);
            } else if (assignObj == null && approvalPosition != null) {
                asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
            }
            nextDesign = asignList != null && !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
            String pathVars = sewerageApplicationDetails.getApplicationNumber() + "," + this.sewerageTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
            return "redirect:/transactions/application-success?pathVars=" + pathVars;
        }
        return this.loadViewData(model, request, sewerageApplicationDetails);
    }

    private void populateDonationSewerageTax(SewerageApplicationDetails sewerageApplicationDetails) {
        FeesDetailMaster sewerageTax;
        List sewerageTaxFeeList;
        FeesDetailMaster donationCharge = this.feesDetailMasterService.findByCodeAndIsActive("DONATIONCHARGE", true);
        List donationChargeList = this.SewerageConnectionFeeService.findAllByApplicationDetailsAndFeesDetail(sewerageApplicationDetails, donationCharge);
        if (donationChargeList.isEmpty()) {
            SewerageConnectionFee connectionFee = new SewerageConnectionFee();
            connectionFee.setFeesDetail(donationCharge);
            connectionFee.setAmount(this.sewerageChargeCalculationService.calculateDonationCharges(sewerageApplicationDetails).doubleValue());
            connectionFee.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.getConnectionFees().add(connectionFee);
        }
        if ((sewerageTaxFeeList = this.SewerageConnectionFeeService.findAllByApplicationDetailsAndFeesDetail(sewerageApplicationDetails, sewerageTax = this.feesDetailMasterService.findByCodeAndIsActive("SEWERAGETAX", true))).isEmpty()) {
            SewerageConnectionFee connectionFee = new SewerageConnectionFee();
            connectionFee = new SewerageConnectionFee();
            connectionFee.setFeesDetail(sewerageTax);
            connectionFee.setAmount(this.sewerageChargeCalculationService.calculateSewerageCharges(sewerageApplicationDetails).doubleValue());
            connectionFee.setApplicationDetails(sewerageApplicationDetails);
            sewerageApplicationDetails.getConnectionFees().add(connectionFee);
        }
    }

    private List<SewerageConnectionEstimationDetails> populateEstimationDetails(SewerageApplicationDetails sewerageApplicationDetails) {
        ArrayList<SewerageConnectionEstimationDetails> sewerageConnectionEstimationDetailList = new ArrayList<SewerageConnectionEstimationDetails>();
        ArrayList<SewerageConnectionEstimationDetails> existingSewerage = new ArrayList<SewerageConnectionEstimationDetails>();
        if (!sewerageApplicationDetails.getEstimationDetailsForUpdate().isEmpty()) {
            for (SewerageConnectionEstimationDetails estimationDetails : sewerageApplicationDetails.getEstimationDetails()) {
                existingSewerage.add(estimationDetails);
            }
            for (SewerageConnectionEstimationDetails estimationDetail : sewerageApplicationDetails.getEstimationDetailsForUpdate()) {
                if (!this.validSewerageConnectioEstimationDetail(estimationDetail)) continue;
                SewerageConnectionEstimationDetails estimationDtl = new SewerageConnectionEstimationDetails();
                estimationDtl.setAmount(estimationDetail.getAmount());
                estimationDtl.setItemDescription(estimationDetail.getItemDescription());
                estimationDtl.setQuantity(estimationDetail.getQuantity());
                estimationDtl.setUnitOfMeasurement(estimationDetail.getUnitOfMeasurement());
                estimationDtl.setUnitRate(estimationDetail.getUnitRate());
                estimationDtl.setApplicationDetails(sewerageApplicationDetails);
                sewerageConnectionEstimationDetailList.add(estimationDtl);
            }
        }
        sewerageApplicationDetails.setEstimationDetails(sewerageConnectionEstimationDetailList);
        if (!existingSewerage.isEmpty()) {
            return existingSewerage;
        }
        return null;
    }

    private void populateFeesDetails(SewerageApplicationDetails sewerageApplicationDetails) {
        if (!sewerageApplicationDetails.getConnectionFees().isEmpty()) {
            for (SewerageConnectionFee scf : sewerageApplicationDetails.getConnectionFees()) {
                scf.setApplicationDetails(sewerageApplicationDetails);
            }
        }
    }

    private List<SewerageFieldInspectionDetails> populateInspectionDetails(SewerageApplicationDetails sewerageApplicationDetails, HttpServletRequest request, MultipartFile[] files) {
        new ArrayList();
        String inspectionDate = request.getParameter("inspectionDate");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        ArrayList<SewerageFieldInspectionDetails> existingInspectionDtlList = new ArrayList<SewerageFieldInspectionDetails>();
        if (!sewerageApplicationDetails.getFieldInspections().isEmpty()) {
            for (SewerageFieldInspection sewerageFieldInspection : sewerageApplicationDetails.getFieldInspections()) {
                ArrayList<SewerageFieldInspectionDetails> sewerageFieldInspectionDetailList = new ArrayList<SewerageFieldInspectionDetails>();
                sewerageFieldInspection.setApplicationDetails(sewerageApplicationDetails);
                try {
                    sewerageFieldInspection.setInspectionDate(sdf.parse(inspectionDate));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                Set fileStoreSet = this.sewerageTaxUtils.addToFileStore(files);
                Iterator fsIterator = null;
                if (fileStoreSet != null && !fileStoreSet.isEmpty()) {
                    fsIterator = fileStoreSet.iterator();
                }
                if (fsIterator != null && fsIterator.hasNext()) {
                    sewerageFieldInspection.setFileStore((FileStoreMapper)fsIterator.next());
                }
                if (!sewerageFieldInspection.getFieldInspectionDetailsForUpdate().isEmpty()) {
                    for (SewerageFieldInspectionDetails fieldInspectionDtls : sewerageFieldInspection.getFieldInspectionDetails()) {
                        existingInspectionDtlList.add(fieldInspectionDtls);
                    }
                    for (SewerageFieldInspectionDetails fieldInspectionDtl : sewerageFieldInspection.getFieldInspectionDetailsForUpdate()) {
                        if (!this.validSewerageFieldInspectionDetails(fieldInspectionDtl)) continue;
                        SewerageFieldInspectionDetails sewerageFieldInspectionDetails = new SewerageFieldInspectionDetails();
                        sewerageFieldInspectionDetails.setNoOfPipes(fieldInspectionDtl.getNoOfPipes());
                        sewerageFieldInspectionDetails.setPipeSize(fieldInspectionDtl.getPipeSize());
                        sewerageFieldInspectionDetails.setPipeLength(fieldInspectionDtl.getPipeLength());
                        sewerageFieldInspectionDetails.setScrewSize(fieldInspectionDtl.getScrewSize());
                        sewerageFieldInspectionDetails.setNoOfScrews(fieldInspectionDtl.getNoOfScrews());
                        sewerageFieldInspectionDetails.setDistance(fieldInspectionDtl.getDistance());
                        sewerageFieldInspectionDetails.setRoadDigging(fieldInspectionDtl.isRoadDigging());
                        sewerageFieldInspectionDetails.setRoadLength(fieldInspectionDtl.getRoadLength());
                        sewerageFieldInspectionDetails.setRoadOwner(fieldInspectionDtl.getRoadOwner());
                        sewerageFieldInspectionDetails.setFieldInspection(sewerageFieldInspection);
                        sewerageFieldInspectionDetailList.add(sewerageFieldInspectionDetails);
                    }
                }
                sewerageFieldInspection.setFieldInspectionDetails(sewerageFieldInspectionDetailList);
            }
        }
        if (existingInspectionDtlList != null) {
            return existingInspectionDtlList;
        }
        return null;
    }

    private boolean validSewerageFieldInspectionDetails(SewerageFieldInspectionDetails sewerageFieldInspectionDetails) {
        return sewerageFieldInspectionDetails != null && (sewerageFieldInspectionDetails == null || sewerageFieldInspectionDetails.getNoOfPipes() != null && sewerageFieldInspectionDetails.getNoOfPipes() != 0);
    }

    private boolean validSewerageConnectioEstimationDetail(SewerageConnectionEstimationDetails sewerageConnectionEstimationDetails) {
        return sewerageConnectionEstimationDetails != null && (sewerageConnectionEstimationDetails == null || sewerageConnectionEstimationDetails.getItemDescription() != null);
    }
}

