/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.web.controller.reports;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.egov.stms.elasticSearch.entity.DailySTCollectionReportSearch;
import org.egov.stms.elasticSearch.entity.SewerageDailyCollectionReport;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports/dailySTCollectionReport/search/"})
public class DailySTCollectionReportController {
    @Autowired
    private SearchService searchService;
    @Autowired
    public EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    public AssignmentService assignmentService;
    @Autowired
    public AppConfigValueService appConfigValueService;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute
    public void reportModel(Model model) {
        DailySTCollectionReportSearch dailyCollectionReportResut = new DailySTCollectionReportSearch();
        model.addAttribute("dailySTCollectionReport", (Object)dailyCollectionReportResut);
    }

    @ModelAttribute(value="collectionMode")
    public Map<String, String> loadInstrumentTypes() {
        LinkedHashMap<String, String> collectionModeMap = new LinkedHashMap<String, String>(0);
        collectionModeMap.put(Source.ESEVA.toString(), Source.ESEVA.toString());
        collectionModeMap.put(Source.MEESEVA.toString(), Source.MEESEVA.toString());
        collectionModeMap.put(Source.APONLINE.toString(), Source.APONLINE.toString());
        collectionModeMap.put(Source.SOFTTECH.toString(), Source.SOFTTECH.toString());
        collectionModeMap.put(Source.SYSTEM.toString(), Source.SYSTEM.toString());
        return collectionModeMap;
    }

    @ModelAttribute(value="operators")
    public Set<User> loadCollectionOperators() {
        String operatorDesignation = this.appConfigValueService.getAppConfigValueByDate("Collection", "COLLECTIONDESIGNATIONFORCSCOPERATORASCLERK", new Date()).getValue();
        return this.assignmentService.getUsersByDesignations(operatorDesignation.split(","));
    }

    @ModelAttribute(value="status")
    public List<EgwStatus> loadStatus() {
        return this.egwStatusHibernateDAO.getStatusByModule("ReceiptHeader");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("currentDate", (Object)new Date());
        return "dailySTCollection-search";
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<SewerageDailyCollectionReport> searchCollection(@ModelAttribute DailySTCollectionReportSearch searchRequest) {
        String consumerNumber = null;
        SearchResult collectionIndexSearchResult = null;
        ArrayList<SewerageDailyCollectionReport> searchResultFomatted = new ArrayList<SewerageDailyCollectionReport>(0);
        Sort sortByAssessment = Sort.by().field("clauses.revwardname", SortOrder.ASC);
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        collectionIndexSearchResult = this.getCollectionIndex(searchRequest);
        block0: for (Document collectionIndexDocument : collectionIndexSearchResult.getDocuments()) {
            Map searchableObjects = (Map)collectionIndexDocument.getResource().get((Object)"common");
            if (searchableObjects == null) continue;
            consumerNumber = (String)searchableObjects.get("consumercode");
            DailySTCollectionReportSearch searchRequestObj = new DailySTCollectionReportSearch();
            if (null != searchRequest.getRevenueWard()) {
                searchRequestObj.setRevenueWard(searchRequest.getRevenueWard());
            }
            searchRequestObj.setConsumerNumber(consumerNumber);
            SearchResult searchResult = this.getSewerageSearchResult(searchRequestObj);
            if (searchResult == null || searchResult.getDocuments().isEmpty()) continue;
            SewerageDailyCollectionReport searchSewerageResult = new SewerageDailyCollectionReport();
            for (Document document : searchResult.getDocuments()) {
                Map searchableSewerageObjects = (Map)document.getResource().get((Object)"searchable");
                if (searchableSewerageObjects == null || !((String)searchableSewerageObjects.get("consumernumber")).equalsIgnoreCase(consumerNumber)) continue;
                searchSewerageResult.setCollectionDocument(collectionIndexDocument);
                searchSewerageResult.setSewerageSearchDocument(document);
                searchResultFomatted.add(searchSewerageResult);
                continue block0;
            }
        }
        return searchResultFomatted;
    }

    private SearchResult getCollectionIndex(DailySTCollectionReportSearch searchRequest) {
        Sort sortByReceiptDate = Sort.by().field("searchable.receiptdate", SortOrder.ASC);
        return this.searchService.search(Arrays.asList(Index.COLLECTION.toString()), Arrays.asList(IndexType.COLLECTION_BIFURCATION.toString()), searchRequest.searchQuery(), searchRequest.searchCollectionFilters(), sortByReceiptDate, Page.NULL);
    }

    private SearchResult getSewerageSearchResult(DailySTCollectionReportSearch searchRequest) {
        Sort sortByApplicationDate = Sort.by().field("clauses.applicationdate", SortOrder.ASC);
        return this.searchService.search(Arrays.asList(Index.SEWARAGE.toString()), Arrays.asList(IndexType.SEWARAGESEARCH.toString()), searchRequest.searchQuery(), searchRequest.searchFilters(), sortByApplicationDate, Page.NULL);
    }
}

